/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.cluster.controller;

import com.ohaotian.abilityadmin.cluster.model.AgentNodeReqBO;
import com.ohaotian.abilityadmin.cluster.model.ClusterReqBO;
import com.ohaotian.abilityadmin.cluster.model.NodeReqBO;
import com.ohaotian.abilityadmin.cluster.service.ClusterService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.portalcommon.model.bo.RspBO;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cluster"})
public class ClusterController {
    @Resource
    private ClusterService clusterService;

    @PostMapping(value={"/clusterList"})
    @BusiResponseBody
    public RspBO clusterList(@RequestBody ClusterReqBO clusterReqBO) {
        return this.clusterService.qryClusterList(clusterReqBO);
    }

    @PostMapping(value={"/clusterAdd"})
    @BusiResponseBody
    public RspBO clusterAdd(@RequestBody ClusterReqBO clusterReqBO) {
        return this.clusterService.clusterAdd(clusterReqBO);
    }

    @PostMapping(value={"/qryClusterById"})
    @BusiResponseBody
    public RspBO qryClusterById(@RequestBody ClusterReqBO clusterReqBO) {
        return this.clusterService.qryClusterById(clusterReqBO.getClusterId());
    }

    @PostMapping(value={"/clusterDel"})
    @BusiResponseBody
    public RspBO clusterDel(@RequestBody ClusterReqBO clusterReqBO) {
        return this.clusterService.delClusterById(clusterReqBO.getClusterId());
    }

    @PostMapping(value={"/clusterModify"})
    @BusiResponseBody
    public RspBO clusterModify(@RequestBody ClusterReqBO clusterReqBO) {
        return this.clusterService.updateCluster(clusterReqBO);
    }

    @PostMapping(value={"/coreNodeList"})
    @BusiResponseBody
    public RspBO coreNodeList(@RequestBody NodeReqBO nodeReqBO) {
        return this.clusterService.qryCoreNodeList(nodeReqBO);
    }

    @PostMapping(value={"/delInvalidNods"})
    @BusiResponseBody
    public RspBO delInvalidNods(@RequestBody NodeReqBO nodeReqBO) {
        return this.clusterService.delInvalidNods(nodeReqBO);
    }

    @PostMapping(value={"/agentNodeList"})
    @BusiResponseBody
    public RspBO agentNodeList(@RequestBody AgentNodeReqBO agentNodeReqBO) {
        return this.clusterService.qryAgentNodeList(agentNodeReqBO);
    }

    @PostMapping(value={"/qryAgentNodeById"})
    @BusiResponseBody
    public RspBO qryAgentNodeById(@RequestBody AgentNodeReqBO agentNodeReqBO) {
        return this.clusterService.qryAgentNodeById(agentNodeReqBO.getAgentNodeId());
    }
}

