/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.system.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.abilityadmin.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityadmin.mapper.AbilityAppMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.PluginTypeMapper;
import com.ohaotian.abilityadmin.mapper.RegionMapper;
import com.ohaotian.abilityadmin.mapper.RspCodeMapper;
import com.ohaotian.abilityadmin.mapper.SystemCodeTypeMapper;
import com.ohaotian.abilityadmin.mapper.SystemCodeValueMapper;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.PluginTypePO;
import com.ohaotian.abilityadmin.model.po.RegionPO;
import com.ohaotian.abilityadmin.model.po.RspCodePO;
import com.ohaotian.abilityadmin.model.po.SystemCodeTypePO;
import com.ohaotian.abilityadmin.model.po.SystemCodeValuePO;
import com.ohaotian.abilityadmin.system.model.bo.ImportUrlReqBO;
import com.ohaotian.abilityadmin.system.model.bo.OptionRspBO;
import com.ohaotian.abilityadmin.system.model.bo.ReqSystemCodeBO;
import com.ohaotian.abilityadmin.system.model.bo.RspCodeReqBO;
import com.ohaotian.abilityadmin.system.model.bo.RspCodeRspBO;
import com.ohaotian.abilityadmin.system.model.bo.RspSystemCodeBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncReqBO;
import com.ohaotian.abilityadmin.system.model.bo.SysReqBO;
import com.ohaotian.abilityadmin.system.service.SysService;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeMap;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeType;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeValue;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.FisrtLevelEnum;
import com.ohaotian.portalcommon.enums.SecondLevelEnum;
import com.ohaotian.portalcommon.model.bo.NodeDataBO;
import com.ohaotian.portalcommon.model.bo.OptionGenerRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.DataFormatUtil;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SysServiceImpl
implements SysService {
    @Resource
    private PluginTypeMapper pluginTypeMapper;
    @Resource
    private AbilityMapper abilityMapper;
    @Resource
    private AbilityAppMapper abilityAppMapper;
    @Resource
    private RegionMapper regionMapper;
    @Resource
    private AppMapper appMapper;
    @Resource
    private ClusterMapper clusterMapper;
    @Resource
    private SystemCodeValueMapper systemCodeValueMapper;
    @Resource
    RspCodeMapper rspCodeMapper;
    @Resource
    AuthorityService authorityService;
    @Resource
    private SystemCodeTypeMapper systemCodeTypeMapper;
    @Autowired
    private PubSubMsgHandler pubSubMsgHandler;
    private static final Logger log = LogManager.getLogger(SysServiceImpl.class);
    private static final String APP = "app";
    private static final String ABILITY_BASIC = "abilityBasic";
    private static final String ABILITY_RELATION = "abilityRelation";
    private static final String PLUGIN = "plugin";
    private static final String SYSTEM_CODE = "systemCode";
    private static final String EXCEPTION = "exception";
    private static final String REGION = "region";

    public RspBO qryDomain() {
        List<SystemCodeValue> list = this.getValueList("1008");
        return RspBO.success(this.fomate(list));
    }

    public RspBO qryIndustry() {
        List<SystemCodeValue> list = this.getValueList("1019");
        return RspBO.success(this.fomate(list));
    }

    public RspBO qryAreaCode() {
        List<SystemCodeValue> list = this.getValueList("1009");
        return RspBO.success(this.fomate(list));
    }

    public RspBO qryInputProtocal() {
        List<SystemCodeValue> list = this.getValueList("1004");
        return RspBO.success(this.fomate(list));
    }

    @Override
    public RspBO<List<OptionRspBO>> qryOutputProtocal() {
        List<SystemCodeValue> list = this.getValueList("1023");
        return RspBO.success(this.fomate(list));
    }

    @Override
    public RspBO<List<OptionRspBO>> qryOutputClient() {
        ArrayList list = Lists.newArrayList();
        SystemCodeValue systemCodeValue1 = new SystemCodeValue();
        systemCodeValue1.setDicCode("WebClient");
        systemCodeValue1.setDicValue("WebClient");
        SystemCodeValue systemCodeValue2 = new SystemCodeValue();
        systemCodeValue2.setDicCode("HttpClient");
        systemCodeValue2.setDicValue("HttpClient");
        SystemCodeValue systemCodeValue3 = new SystemCodeValue();
        systemCodeValue3.setDicCode("PushClient");
        systemCodeValue3.setDicValue("PushClient");
        list.add(systemCodeValue1);
        list.add(systemCodeValue2);
        list.add(systemCodeValue3);
        return RspBO.success(this.fomate(list));
    }

    public RspBO qryPluginType() {
        PluginTypePO po = new PluginTypePO();
        po.setIsSingleInstance(0);
        List<PluginTypePO> list = this.pluginTypeMapper.queryByCond(po);
        List bos = list.stream().map(tmp -> {
            OptionRspBO bo = new OptionRspBO();
            bo.setLabel(tmp.getPluginTypeName());
            bo.setValue(tmp.getPluginType());
            return bo;
        }).collect(Collectors.toList());
        return RspBO.success(bos);
    }

    public RspBO qryAbilityType() {
        List collect = this.getValueList("1035").stream().map(s -> new OptionGenerRspBO((Serializable)((Object)s.getDicValue()), (Serializable)Integer.valueOf(s.getDicCode()))).collect(Collectors.toList());
        return RspBO.success(collect);
    }

    public RspBO qrySubAbilityInfo() {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        AbilityPO abilityPO = new AbilityPO();
        abilityPO.setHirerId(tenantId);
        abilityPO.setIsDraft(Constants.AbilityDraftType.NORMAL);
        ValidBatchUtils.isNotEmpty((Object)abilityPO, (String[])new String[]{"hirerId"});
        List collect = this.abilityMapper.queryByCond(abilityPO).stream().map(a -> {
            StringBuilder label = new StringBuilder();
            label.append(a.getAbilityEname()).append("_");
            if (a.getAbilityVersion().toUpperCase().indexOf("V") >= 0) {
                label.append(a.getAbilityVersion());
            } else {
                label.append("v").append(a.getAbilityVersion());
            }
            OptionGenerRspBO rsp = new OptionGenerRspBO((Serializable)((Object)label.toString()), (Serializable)a.getAbilityId());
            return rsp;
        }).collect(Collectors.toList());
        return RspBO.success(collect);
    }

    @Override
    public RspBO<List<OptionGenerRspBO>> qryAbilityAppCodeSourceType() {
        List collect = this.getValueList("1036").stream().map(s -> new OptionGenerRspBO((Serializable)((Object)s.getDicValue()), (Serializable)Integer.valueOf(s.getDicCode()))).collect(Collectors.toList());
        return RspBO.success(collect);
    }

    @Override
    public RspBO<List<OptionRspBO>> qryPriority() {
        List<SystemCodeValue> list = this.getValueList("1037");
        return RspBO.success(this.fomate(list));
    }

    @Override
    public RspBO queryRegionByAbilityAndCluster(SysReqBO sysReqBO) {
        String appCode = this.abilityAppMapper.selectByAbilityId(sysReqBO.getAbilityId());
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        List<RegionPO> regionPOList = this.regionMapper.queryRegionByAppId(tenantId, appCode, sysReqBO.getClusterId());
        List bos = regionPOList.stream().map(tmp -> {
            OptionRspBO bo = new OptionRspBO();
            bo.setLabel(tmp.getRegionName());
            bo.setValue(tmp.getRegionId() + "");
            return bo;
        }).collect(Collectors.toList());
        return RspBO.success(bos);
    }

    @Override
    public RspBO queryRegionByAppIdAndCluster(ImportUrlReqBO importUrlReqBO) {
        String appCode = this.appMapper.queryByAppId(importUrlReqBO.getAppId()).getAppCode();
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        List<RegionPO> regionPOList = this.regionMapper.queryRegionByAppId(tenantId, appCode, importUrlReqBO.getClusterId());
        List bos = regionPOList.stream().map(tmp -> {
            OptionRspBO bo = new OptionRspBO();
            bo.setLabel(tmp.getRegionName());
            bo.setValue(tmp.getRegionId() + "");
            return bo;
        }).collect(Collectors.toList());
        return RspBO.success(bos);
    }

    @Override
    public RspBO<List<OptionRspBO>> qryHaddrPolicy() {
        List<SystemCodeValue> list = this.getValueList("1011");
        return RspBO.success(this.fomate(list));
    }

    @Override
    public RspBO<List<OptionRspBO>> qryRegionType() {
        List<SystemCodeValue> list = this.getValueList("1010");
        return RspBO.success(this.fomate(list));
    }

    @Override
    public RspBO<List<Map<String, Object>>> qryClusterInfo() {
        ClusterPO clusterPO = new ClusterPO();
        ArrayList list = Lists.newArrayList();
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        clusterPO.setHirerId(tenantId);
        List<ClusterPO> clusterPOList = this.clusterMapper.queryByCond(clusterPO);
        clusterPOList.forEach(po -> {
            HashMap map = Maps.newHashMap();
            map.put("label", po.getClusterName());
            map.put("value", po.getClusterId());
            list.add(map);
        });
        return RspBO.success((Object)list);
    }

    @Override
    public RspBO qrySystemCode(ReqSystemCodeBO reqSystemCodeBO) {
        StringBuilder order = new StringBuilder();
        if (reqSystemCodeBO.getSortName() != null) {
            order.append(reqSystemCodeBO.getSortName());
            if (reqSystemCodeBO.getSortOrder() != null) {
                order.append(" ");
                order.append(reqSystemCodeBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        Page page = PageMethod.startPage((int)reqSystemCodeBO.getPageNo(), (int)reqSystemCodeBO.getPageSize(), (String)order.toString());
        List<RspSystemCodeBO> rspSystemCodeBOS = this.systemCodeValueMapper.queryLikeTypeName(reqSystemCodeBO);
        RspPage rspPage = new RspPage(Integer.valueOf(reqSystemCodeBO.getPageSize()), Integer.valueOf(reqSystemCodeBO.getPageNo()), rspSystemCodeBOS, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO qrySystemCodeByCodeId(ReqSystemCodeBO reqSystemCodeBO) {
        ValidBatchUtils.isNotEmpty((Object)reqSystemCodeBO, (String[])new String[]{"codeId"});
        RspSystemCodeBO rspSystemCodeBO = this.systemCodeValueMapper.qrySystemCodeByCodeId(reqSystemCodeBO.getCodeId());
        return RspBO.success((Object)rspSystemCodeBO);
    }

    @Override
    @Transactional
    public RspBO modSystemCode(ReqSystemCodeBO reqSystemCodeBO) {
        ValidBatchUtils.isNotEmpty((Object)reqSystemCodeBO, (String[])new String[]{"codeId", "dicCode", "dicValue"});
        SystemCodeValuePO systemCodeValuePO_old = new SystemCodeValuePO();
        systemCodeValuePO_old.setCodeId(reqSystemCodeBO.getCodeId());
        systemCodeValuePO_old = this.systemCodeValueMapper.queryLimitOne(systemCodeValuePO_old);
        if (!reqSystemCodeBO.getDicCode().equals(systemCodeValuePO_old.getDicCode())) {
            SystemCodeValuePO systemCodeValuePO_isExist = new SystemCodeValuePO();
            systemCodeValuePO_isExist.setTypeCode(reqSystemCodeBO.getTypeCode());
            systemCodeValuePO_isExist.setDicCode(reqSystemCodeBO.getDicCode());
            systemCodeValuePO_isExist = this.systemCodeValueMapper.queryLimitOne(systemCodeValuePO_isExist);
            if (systemCodeValuePO_isExist != null) {
                return RspBO.error((String)"\u8be5\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
            }
        }
        SystemCodeValuePO systemCodeValuePO = new SystemCodeValuePO();
        systemCodeValuePO.setCodeId(reqSystemCodeBO.getCodeId());
        systemCodeValuePO.setDicCode(reqSystemCodeBO.getDicCode());
        systemCodeValuePO.setDicValue(reqSystemCodeBO.getDicValue());
        systemCodeValuePO.setRemark(reqSystemCodeBO.getRemark());
        systemCodeValuePO.setUpdateTime(new Date());
        systemCodeValuePO.setUpdateUserId(Long.parseLong(UserHolder.getUserId()));
        this.systemCodeValueMapper.updateByCodeId(systemCodeValuePO);
        SystemCodeMap.removeSystemCodeValue((String)systemCodeValuePO_old.getTypeCode(), (String)systemCodeValuePO_old.getDicCode());
        SystemCodeValuePO systemCodeValuePO_new = new SystemCodeValuePO();
        systemCodeValuePO_new.setCodeId(reqSystemCodeBO.getCodeId());
        systemCodeValuePO_new = this.systemCodeValueMapper.queryLimitOne(systemCodeValuePO_new);
        SystemCodeValue systemCodeValue = (SystemCodeValue)BeanMapper.map((Object)systemCodeValuePO_new, SystemCodeValue.class);
        SystemCodeMap.getSystemCode((String)systemCodeValuePO_old.getTypeCode()).put(systemCodeValue.getDicCode(), systemCodeValue);
        return RspBO.success(null);
    }

    public RspBO<Boolean> syncH2(SyncReqBO syncReqBO) {
        NodeDataBO nodeDataBO = this.syncH2(syncReqBO, "\u95e8\u6237\u9009\u62e9\u6570\u636e\u540c\u6b65", "");
        this.pubSubMsgHandler.writeRedisNode(nodeDataBO, "SYNC_DATA");
        return RspBO.success((Object)true);
    }

    @Override
    public NodeDataBO syncH2(SyncReqBO syncReqBO, String code, String userId) {
        log.info(code);
        log.info(GsonUtil.fromJson((String)"{\"ability\":[\"abilityBasic\",\"abilityRelation\"],\"app\":[\"app\",\"region\"],\"plugin\":[\"plugin\"],\"systemCode\":[\"systemCode\"],\"exception\":[\"exception\"],\"clusterIds\":[]}\n", SyncReqBO.class));
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(ObjectUtils.isEmpty((Object)UserHolder.getUserId()) ? userId : UserHolder.getUserId()).getTenantId());
        NodeDataBO nodeDataBO = new NodeDataBO();
        nodeDataBO.setClusterIds(syncReqBO.getClusterIds());
        nodeDataBO.setHirerId(tenantId);
        nodeDataBO.setFlag("all");
        ArrayList syncBOS = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(syncReqBO.getAbility())) {
            if (syncReqBO.getAbility().contains(ABILITY_BASIC)) {
                syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.ABILITY.getCode(), SecondLevelEnum.ABILITY_BASIC.getCode(), null));
                syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.ABILITY.getCode(), SecondLevelEnum.ABILITY_EXT.getCode(), null));
                syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.ABILITY.getCode(), SecondLevelEnum.ABILITY_LOGIC.getCode(), null));
                syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.ABILITY.getCode(), SecondLevelEnum.ABILITY_PARAM.getCode(), null));
                syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.ABILITY.getCode(), SecondLevelEnum.ABILITY_WS_EXT.getCode(), null));
            }
            if (syncReqBO.getAbility().contains(ABILITY_RELATION)) {
                syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.ABILITY.getCode(), SecondLevelEnum.ABILITY_RELATION.getCode(), null));
            }
        }
        if (!CollectionUtils.isEmpty(syncReqBO.getApp())) {
            if (syncReqBO.getApp().contains(APP)) {
                syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.APP.getCode(), SecondLevelEnum.APP.getCode(), null));
            }
            if (syncReqBO.getApp().contains(REGION)) {
                syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.APP.getCode(), SecondLevelEnum.APP_REGION.getCode(), null));
                syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.APP.getCode(), SecondLevelEnum.APP_REGION_ADDR.getCode(), null));
            }
        }
        if (!CollectionUtils.isEmpty(syncReqBO.getPlugin()) && syncReqBO.getPlugin().contains(PLUGIN)) {
            syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.PLUGIN.getCode(), SecondLevelEnum.PLUGIN_PLUGIN.getCode(), null));
            syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.PLUGIN.getCode(), SecondLevelEnum.PLUGIN_PLUGIN_EXT.getCode(), null));
        }
        if (!CollectionUtils.isEmpty(syncReqBO.getSystemCode()) && syncReqBO.getSystemCode().contains(SYSTEM_CODE)) {
            syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.SYSTEM_CODE.getCode(), SecondLevelEnum.SYSTEM_CODE.getCode(), null));
        }
        if (!CollectionUtils.isEmpty(syncReqBO.getException()) && syncReqBO.getSystemCode().contains(EXCEPTION)) {
            syncBOS.add(nodeDataBO.newSyncBO(FisrtLevelEnum.EXCEPTION.getCode(), SecondLevelEnum.EXCEPTION.getCode(), null));
        }
        nodeDataBO.setSyncBOs((List)syncBOS);
        return nodeDataBO;
    }

    @Override
    public RspBO<RspPage<RspCodeRspBO>> rspCodeList(RspCodeReqBO rspCodeReqBO) {
        log.debug("SysServiceImpl.rspCodeList:{}", (Object)rspCodeReqBO);
        int pageNo = rspCodeReqBO.getPageNo();
        int pageSize = rspCodeReqBO.getPageSize();
        RspCodePO rspCodePO = (RspCodePO)BeanMapper.map((Object)rspCodeReqBO, RspCodePO.class);
        Page page = PageMethod.startPage((int)pageNo, (int)pageSize, (String)"rsp_code asc");
        List<RspCodePO> rspCodePOList = this.rspCodeMapper.queryByCond(rspCodePO);
        List rspCodeRspBOList = BeanMapper.mapList(rspCodePOList, RspCodeRspBO.class);
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), rspCodeRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    @Transactional
    public RspBO delSystemCodeByCodeId(ReqSystemCodeBO reqSystemCodeBO) {
        ValidBatchUtils.isNotEmpty((Object)reqSystemCodeBO, (String[])new String[]{"codeId"});
        SystemCodeValuePO systemCodeValuePO_old = new SystemCodeValuePO();
        systemCodeValuePO_old.setCodeId(reqSystemCodeBO.getCodeId());
        systemCodeValuePO_old = this.systemCodeValueMapper.queryLimitOne(systemCodeValuePO_old);
        this.systemCodeValueMapper.deleteSystemCodeValueByCodeId(reqSystemCodeBO.getCodeId());
        SystemCodeMap.removeSystemCodeValue((String)systemCodeValuePO_old.getTypeCode(), (String)systemCodeValuePO_old.getDicCode());
        return RspBO.success(null);
    }

    @Override
    public RspBO xml2json(String xml) {
        try {
            return RspBO.success((Object)DataFormatUtil.XmlToJsonReplaceBlank((String)xml));
        }
        catch (Exception e) {
            throw new ZTBusinessException("xml\u751f\u6210\u6811\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    public RspBO refreshSystemCodeMap() {
        SystemCodeMap.removeAll();
        List<SystemCodeTypePO> systemCodeTypePOList = this.systemCodeTypeMapper.findAllSystemCodeTypeWithSystemCodeValue();
        for (SystemCodeTypePO systemCodeTypePO : systemCodeTypePOList) {
            SystemCodeType systemCodeType = (SystemCodeType)BeanMapper.map((Object)systemCodeTypePO, SystemCodeType.class);
            HashMap<String, SystemCodeValue> stringSystemCodeValueMap = new HashMap<String, SystemCodeValue>();
            List<SystemCodeValuePO> systemCodeValueList = systemCodeTypePO.getSystemCodeValuePOList();
            for (SystemCodeValuePO systemCodeValuePO : systemCodeValueList) {
                SystemCodeValue systemCodeValue = (SystemCodeValue)BeanMapper.map((Object)systemCodeValuePO, SystemCodeValue.class);
                stringSystemCodeValueMap.put(systemCodeValue.getDicCode(), systemCodeValue);
            }
            systemCodeType.setSystemCodeValueMap(stringSystemCodeValueMap);
            SystemCodeMap.getSystemCodeMap().put(systemCodeType.getTypeCode(), systemCodeType);
        }
        return RspBO.success((Object)true);
    }

    public RspBO<RspSystemCodeBO> qrySystemCodeByCode(ReqSystemCodeBO reqSystemCodeBO) {
        ValidBatchUtils.isNotEmpty((Object)reqSystemCodeBO, (String[])new String[]{"typeCode", "dicCode"});
        SystemCodeValuePO systemCodeValuePO = new SystemCodeValuePO();
        systemCodeValuePO.setTypeCode(reqSystemCodeBO.getTypeCode());
        systemCodeValuePO.setDicCode(reqSystemCodeBO.getDicCode());
        systemCodeValuePO = this.systemCodeValueMapper.queryLimitOne(systemCodeValuePO);
        RspSystemCodeBO rspSystemCodeBO = null;
        if (systemCodeValuePO != null) {
            rspSystemCodeBO = (RspSystemCodeBO)BeanMapper.map((Object)systemCodeValuePO, RspSystemCodeBO.class);
        }
        return RspBO.success(rspSystemCodeBO);
    }

    private List<SystemCodeValue> getValueList(String type) {
        Map valueMap = SystemCodeMap.getSystemCode((String)type);
        ArrayList list = Lists.newArrayList();
        valueMap.forEach((key, value) -> list.add(value));
        return list;
    }

    private List<OptionRspBO> fomate(List<SystemCodeValue> list) {
        List<OptionRspBO> bos = list.stream().map(tmp -> {
            OptionRspBO bo = new OptionRspBO();
            bo.setLabel(tmp.getDicValue());
            bo.setValue(tmp.getDicCode());
            return bo;
        }).collect(Collectors.toList());
        return bos;
    }
}

