/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtil {
    private static final Logger log = LoggerFactory.getLogger(SchemaUtil.class);
    private static final String SCHEMA_KEY = "$schema";
    private static final String SCHEMA_TYPE = "type";
    private static final String SCHEMA_PROPERTIES = "properties";
    private static final String SCHEMA_DESCRIPTION = "description";
    private static final String SCHEMA_ITEMS = "items";
    private static final String SCHEMA_PATH_SEPARATOR = "/";
    private static final String SCHEMA_OBJECT = "object";
    private static final String SCHEMA_ARRAY = "array";
    private static final String SCHEMA_STRING = "string";
    private static final String SCHEMA_NUMBER = "number";
    private static final String SCHEMA_BOOLEAN = "boolean";
    private static final String SCHEMA_ROOT = "root";
    private static final String SCHEMA_4 = "http://json-schema.org/draft-04/schema#";
    private static JsonMapper jsonMapper = new JsonMapper();

    public static String json2Schema(String json) throws JsonProcessingException {
        LinkedHashMap nodes = new LinkedHashMap();
        Map map = (Map)jsonMapper.readValue(json, Map.class);
        SchemaUtil.parseObject(nodes, SCHEMA_ROOT, map, true);
        Map schema = (Map)nodes.get(SCHEMA_ROOT);
        return jsonMapper.writeValueAsString((Object)schema);
    }

    private static void parseObject(Map map, Object k, Object v, Boolean flag) {
        LinkedHashMap<String, Object> nodes = new LinkedHashMap<String, Object>();
        LinkedHashMap node = new LinkedHashMap();
        ((Map)v).forEach((x, y) -> {
            if (y instanceof Map) {
                SchemaUtil.parseObject(node, x, y, false);
            } else if (y instanceof List) {
                SchemaUtil.paresArray(node, x, y);
            } else {
                SchemaUtil.parseBase(node, x, y);
            }
        });
        if (flag.booleanValue()) {
            nodes.put(SCHEMA_KEY, SCHEMA_4);
        }
        nodes.put(SCHEMA_TYPE, SCHEMA_OBJECT);
        nodes.put(SCHEMA_PROPERTIES, node);
        map.put(k, nodes);
    }

    private static void paresArray(Map map, Object k, Object v) {
        LinkedHashMap<String, String> nodes = new LinkedHashMap<String, String>();
        LinkedHashMap node = new LinkedHashMap();
        ArrayList<Object> obj = new ArrayList<Object>();
        ((List)v).forEach(l -> {
            if (l instanceof Map) {
                SchemaUtil.parseObject(node, k, l, false);
                obj.add(node.get(k));
            } else if (l instanceof List) {
                SchemaUtil.paresArray(node, k, l);
            } else {
                SchemaUtil.parseBase(node, k, l);
            }
        });
        SchemaUtil.mergeArray(k, node, obj);
        nodes.put(SCHEMA_TYPE, SCHEMA_ARRAY);
        nodes.put(SCHEMA_ITEMS, (String)node.get(k));
        map.put(k, nodes);
    }

    private static void mergeArray(Object k, Map node, ArrayList<Object> obj) {
        if (obj.size() > 1) {
            LinkedHashMap nodeObj = new LinkedHashMap();
            LinkedHashMap<String, Object> nodeObjs = new LinkedHashMap<String, Object>();
            obj.forEach(a -> {
                Map maps = (Map)a;
                Map map1 = (Map)maps.get(SCHEMA_PROPERTIES);
                map1.forEach((m, n) -> nodeObj.put(m, n));
            });
            nodeObjs.put(SCHEMA_TYPE, SCHEMA_OBJECT);
            nodeObjs.put(SCHEMA_PROPERTIES, nodeObj);
            node.put(k, nodeObjs);
        }
    }

    private static void parseBase(Map map, Object k, Object v) {
        LinkedHashMap<String, String> node = new LinkedHashMap<String, String>();
        if (v instanceof Integer) {
            node.put(SCHEMA_TYPE, SCHEMA_NUMBER);
        } else if (v instanceof Boolean) {
            node.put(SCHEMA_TYPE, SCHEMA_BOOLEAN);
        } else {
            node.put(SCHEMA_TYPE, SCHEMA_STRING);
        }
        map.put(k, node);
    }
}

