/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.api;

import com.ohaotian.abilityadmin.mapper.PluginMapper;
import com.ohaotian.abilityadmin.mapper.SyncDataMapper;
import com.ohaotian.abilityadmin.model.po.PluginPO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityPluginBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncPluginBO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.SyncDataReqBO;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PluginAPIImpl
implements PluginAPI {
    @Resource
    PluginMapper pluginMapper;
    @Resource
    private AuthorityService authorityService;
    @Resource
    private SyncDataMapper syncDataMapper;

    public PluginRspBO getPluginInfo(Long pluginId) {
        PluginPO pluginPO = new PluginPO();
        pluginPO.setPluginId(pluginId);
        pluginPO = this.pluginMapper.queryLimitOne(pluginPO);
        PluginRspBO pluginRspBO = (PluginRspBO)BeanMapper.map((Object)pluginPO, PluginRspBO.class);
        if (!StringUtils.isEmpty((Object)pluginRspBO.getCreateUserId())) {
            pluginRspBO.setCreateUserName(this.authorityService.getUserInfoByUserId(pluginRspBO.getCreateUserId().toString()).getName());
        }
        if (!StringUtils.isEmpty((Object)pluginRspBO.getUpdateUserId())) {
            pluginRspBO.setUpdateUserName(this.authorityService.getUserInfoByUserId(pluginRspBO.getCreateUserId().toString()).getName());
        }
        return pluginRspBO;
    }

    public List<Long> getPluginIds(SyncDataReqBO syncDataBO) {
        List<SyncPluginBO> pluginBOList = this.syncDataMapper.queryPlugin(syncDataBO);
        return pluginBOList.stream().map(SyncPluginBO::getPluginId).collect(Collectors.toList());
    }

    public List<Long> getAbilityPluginDeployIds(Long clusterId, Long hirerId, Long abilityId, Long pluginId) {
        List<SyncAbilityPluginBO> abilityPluginBOList = this.syncDataMapper.queryAbilityPluginDeploy(clusterId, hirerId, abilityId, pluginId);
        return abilityPluginBOList.stream().map(SyncAbilityPluginBO::getAbilityPluginId).collect(Collectors.toList());
    }

    public PluginRspBO getPluginInfoByAbilityPluginDeployId(Long abilityPluginDeployId) {
        PluginPO pluginPO = this.pluginMapper.getPluginInfoByAbilityPluginDeployId(abilityPluginDeployId);
        return (PluginRspBO)BeanMapper.map((Object)pluginPO, PluginRspBO.class);
    }

    public List<PluginRspBO> qryPluginIdByPluginType(String pluginType) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long hirerId = Long.valueOf(authorityUserInfoBO.getTenantId());
        PluginPO pluginPO = new PluginPO();
        pluginPO.setPluginType(pluginType);
        pluginPO.setHirerId(hirerId);
        List<PluginPO> pluginPOList = this.pluginMapper.queryByCondition(pluginPO);
        List boList = BeanMapper.mapList(pluginPOList, PluginRspBO.class);
        return boList;
    }
}

