/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.ohaotian.abilityadmin.ability.model.bo.AbilityProvideDeployWithExtCustomAndRegionBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityClusterReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityClusterRspBO;
import com.ohaotian.abilityadmin.ability.service.AbilityClusterService;
import com.ohaotian.abilityadmin.mapper.AbilityAppMapper;
import com.ohaotian.abilityadmin.mapper.AbilityExtCustomMapper;
import com.ohaotian.abilityadmin.mapper.AbilityExtDefaultMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityModifyMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.RateLimiterAbilityDefaultMapper;
import com.ohaotian.abilityadmin.mapper.RateLimiterAbilityMapper;
import com.ohaotian.abilityadmin.model.po.AbilityAppPO;
import com.ohaotian.abilityadmin.model.po.AbilityExtCustomPO;
import com.ohaotian.abilityadmin.model.po.AbilityExtDefaultPO;
import com.ohaotian.abilityadmin.model.po.AbilityModifyPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.RateLimiterAbilityDefaultPO;
import com.ohaotian.abilityadmin.model.po.RateLimiterAbilityPO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.enums.AbilityOperateTypeEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AbilityClusterServiceImpl
implements AbilityClusterService {
    private static Logger logger = LogManager.getLogger(AbilityClusterServiceImpl.class);
    @Resource
    AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    AbilityExtDefaultMapper abilityExtDefaultMapper;
    @Resource
    AbilityExtCustomMapper abilityExtCustomMapper;
    @Resource
    AbilityModifyMapper abilityModifyMapper;
    @Resource
    AbilityAppMapper abilityAppMapper;
    @Resource
    private AbilityMapper abilityMapper;
    @Resource
    private ClusterMapper clusterMapper;
    @Resource
    private RateLimiterAbilityDefaultMapper rateLimiterAbilityDefaultMapper;
    @Resource
    private RateLimiterAbilityMapper rateLimiterAbilityMapper;

    @Override
    public List<QryAbilityClusterRspBO> queryAbilityClusterList(Long abilityId) {
        ArrayList<QryAbilityClusterRspBO> qryAbilityClusterRspBOList = new ArrayList<QryAbilityClusterRspBO>();
        AbilityExtDefaultPO abilityExtDefaultPO = null;
        List<AbilityProvideDeployWithExtCustomAndRegionBO> abilityProvideDeployPOList = this.abilityProvideDeployMapper.queryAbilityProvideDeployWithAbilityExtCustomPOByAbilityId(abilityId);
        for (AbilityProvideDeployWithExtCustomAndRegionBO abilityProvideDeployPO : abilityProvideDeployPOList) {
            QryAbilityClusterRspBO qryAbilityClusterRspBO = new QryAbilityClusterRspBO();
            qryAbilityClusterRspBO.setClusterId(abilityProvideDeployPO.getClusterId());
            qryAbilityClusterRspBO.setProvideDeployId(abilityProvideDeployPO.getProvideDeployId());
            ClusterPO clusterPO = this.clusterMapper.queryByClusterId(abilityProvideDeployPO.getClusterId());
            qryAbilityClusterRspBO.setClusterName(clusterPO.getClusterName());
            qryAbilityClusterRspBO.setFullName(qryAbilityClusterRspBO.getClusterName() + "_" + abilityProvideDeployPO.getRegionPO().getRegionName());
            if (abilityProvideDeployPO.getAbilityExtCustomPO() != null) {
                qryAbilityClusterRspBO.setOvertime(abilityProvideDeployPO.getAbilityExtCustomPO().getOvertime());
                qryAbilityClusterRspBO.setRetryTime(abilityProvideDeployPO.getAbilityExtCustomPO().getRetryTime());
            } else {
                if (abilityExtDefaultPO == null) {
                    abilityExtDefaultPO = new AbilityExtDefaultPO();
                    abilityExtDefaultPO.setAbilityId(abilityId);
                    abilityExtDefaultPO = this.abilityExtDefaultMapper.queryLimitOne(abilityExtDefaultPO);
                }
                qryAbilityClusterRspBO.setOvertime(abilityExtDefaultPO.getOvertime());
                qryAbilityClusterRspBO.setRetryTime(abilityExtDefaultPO.getRetryTime());
            }
            if (abilityProvideDeployPO.getRateLimiterAbilityPO() != null) {
                qryAbilityClusterRspBO.setCapacity(abilityProvideDeployPO.getRateLimiterAbilityPO().getCapacity());
                qryAbilityClusterRspBO.setDailyCapacity(abilityProvideDeployPO.getRateLimiterAbilityPO().getDailyCapacity());
                qryAbilityClusterRspBO.setRate(abilityProvideDeployPO.getRateLimiterAbilityPO().getRate());
                qryAbilityClusterRspBO.setSingleMaxRate(abilityProvideDeployPO.getRateLimiterAbilityPO().getSingleMaxRate());
                qryAbilityClusterRspBO.setSingleMaxCount(abilityProvideDeployPO.getRateLimiterAbilityPO().getSingleMaxCount());
                qryAbilityClusterRspBO.setSingleDailyMaxCount(abilityProvideDeployPO.getRateLimiterAbilityPO().getSingleDailyMaxCount());
            } else {
                RateLimiterAbilityDefaultPO rateLimiterAbilityDefaultPO = new RateLimiterAbilityDefaultPO();
                rateLimiterAbilityDefaultPO.setAbilityId(abilityId);
                RateLimiterAbilityDefaultPO rateLimiterAbilityDefaultPO1 = this.rateLimiterAbilityDefaultMapper.queryLimitOne(rateLimiterAbilityDefaultPO);
                if (!Objects.isNull(rateLimiterAbilityDefaultPO1)) {
                    qryAbilityClusterRspBO.setCapacity(rateLimiterAbilityDefaultPO1.getCapacity());
                    qryAbilityClusterRspBO.setDailyCapacity(rateLimiterAbilityDefaultPO1.getDailyCapacity());
                    qryAbilityClusterRspBO.setRate(rateLimiterAbilityDefaultPO1.getRate());
                    qryAbilityClusterRspBO.setSingleMaxRate(rateLimiterAbilityDefaultPO1.getSingleMaxRate());
                    qryAbilityClusterRspBO.setSingleMaxCount(rateLimiterAbilityDefaultPO1.getSingleMaxCount());
                    qryAbilityClusterRspBO.setSingleDailyMaxCount(rateLimiterAbilityDefaultPO1.getSingleDailyMaxCount());
                }
            }
            qryAbilityClusterRspBOList.add(qryAbilityClusterRspBO);
        }
        return qryAbilityClusterRspBOList;
    }

    @Override
    @Transactional
    public void setAbilityExtCustom(QryAbilityClusterReqBO qryAbilityClusterReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityExtCustomPO query = new AbilityExtCustomPO();
        query.setProvideDeployId(qryAbilityClusterReqBO.getProvideDeployId());
        AbilityExtCustomPO abilityExtCustomPO = this.abilityExtCustomMapper.queryLimitOne(query);
        Date date = new Date();
        query.setOvertime(qryAbilityClusterReqBO.getOvertime());
        query.setRetryTime(qryAbilityClusterReqBO.getRetryTime());
        if (abilityExtCustomPO == null) {
            query.setDeployUserId(userId);
            query.setDeployTime(date);
            this.abilityExtCustomMapper.insertSelective(query);
        } else {
            query.setAbilityExtCustomId(abilityExtCustomPO.getAbilityExtCustomId());
            query.setUpdateUserId(userId);
            query.setUpdateTime(date);
            this.abilityExtCustomMapper.updateAbilityExtCustomByAbilityExtCustomId(query);
        }
        RateLimiterAbilityPO rateLimiterAbilityPO = new RateLimiterAbilityPO();
        rateLimiterAbilityPO.setAbilityId(qryAbilityClusterReqBO.getAbilityId());
        rateLimiterAbilityPO.setClusterId(qryAbilityClusterReqBO.getClusterId());
        RateLimiterAbilityPO rateLimiterAbilityPO1 = this.rateLimiterAbilityMapper.queryLimitOne(rateLimiterAbilityPO);
        rateLimiterAbilityPO.setCapacity(qryAbilityClusterReqBO.getCapacity());
        rateLimiterAbilityPO.setDailyCapacity(qryAbilityClusterReqBO.getDailyCapacity());
        rateLimiterAbilityPO.setRate(qryAbilityClusterReqBO.getRate());
        rateLimiterAbilityPO.setSingleMaxRate(qryAbilityClusterReqBO.getSingleMaxRate());
        rateLimiterAbilityPO.setSingleMaxCount(qryAbilityClusterReqBO.getSingleMaxCount());
        rateLimiterAbilityPO.setSingleDailyMaxCount(qryAbilityClusterReqBO.getSingleDailyMaxCount());
        rateLimiterAbilityPO.setAbilityId(qryAbilityClusterReqBO.getAbilityId());
        rateLimiterAbilityPO.setClusterId(qryAbilityClusterReqBO.getClusterId());
        if (Objects.isNull(rateLimiterAbilityPO1)) {
            rateLimiterAbilityPO.setCreateTime(date);
            rateLimiterAbilityPO.setCreateUserId(userId);
            this.rateLimiterAbilityMapper.insertSelective(rateLimiterAbilityPO);
        } else {
            rateLimiterAbilityPO.setRateLimiterAbilityId(rateLimiterAbilityPO1.getRateLimiterAbilityId());
            rateLimiterAbilityPO.setUpdateUserId(userId);
            rateLimiterAbilityPO.setUpdateTime(date);
            this.rateLimiterAbilityMapper.updateRateLimiterAbilityByRateLimiterAbilityDefaultId(rateLimiterAbilityPO);
        }
        AbilityAppPO abilityAppPO = this.abilityAppMapper.findByDeployId(qryAbilityClusterReqBO.getProvideDeployId());
        AbilityPO abilityPO = (AbilityPO)BeanMapper.map((Object)abilityAppPO, AbilityPO.class);
        AbilityPO abilityPO1 = this.abilityMapper.queryLimitOne(abilityPO);
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityPO1.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.ABILITY_CLUSTER_UPDATE.getValue());
        abilityModifyPO.setModifyRecord(qryAbilityClusterReqBO.getModifyRecord());
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(date);
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    public void setAbilityExtDefault(QryAbilityClusterReqBO qryAbilityClusterReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        RateLimiterAbilityPO rateLimiterAbilityPO = (RateLimiterAbilityPO)BeanMapper.map((Object)qryAbilityClusterReqBO, RateLimiterAbilityPO.class);
        this.rateLimiterAbilityMapper.deleteRateLimiterAbilityByRateLimiter(rateLimiterAbilityPO);
        this.abilityExtCustomMapper.deleteAbilityExtCustomByProvideDeployId(qryAbilityClusterReqBO.getProvideDeployId());
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(qryAbilityClusterReqBO.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.UPDATE.getValue());
        abilityModifyPO.setModifyRecord("\u6062\u590d\u9ed8\u8ba4\u96c6\u7fa4\u6269\u5c55\u4fe1\u606f");
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(new Date());
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }
}

