/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterFormatReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterFormatRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterTemplateReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilityParameterTemplateRspBO;
import com.ohaotian.abilityadmin.ability.service.AbilityParameterService;
import com.ohaotian.abilityadmin.component.deploy.AbilitySvcComponent;
import com.ohaotian.abilityadmin.mapper.AbilityExtMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityModifyMapper;
import com.ohaotian.abilityadmin.mapper.AbilityParamMapper;
import com.ohaotian.abilityadmin.mapper.AbilityWsExtMapper;
import com.ohaotian.abilityadmin.model.po.AbilityExtPO;
import com.ohaotian.abilityadmin.model.po.AbilityModifyPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityParamPO;
import com.ohaotian.abilityadmin.model.po.AbilityWsExtPO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.enums.AbilityOperateTypeEnum;
import com.ohaotian.portalcommon.model.bo.OptionGenerRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.JaxbUtil;
import com.ohaotian.portalcommon.util.ObjectUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import com.ohaotian.portalcommon.util.json.JSONUtil;
import com.ohaotian.portalcommon.util.xml.XMLUtil;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class AbilityParameterServiceImpl
implements AbilityParameterService {
    @Resource
    AbilityMapper abilityMapper;
    @Resource
    AbilityParamMapper abilityParamMapper;
    @Resource
    AbilitySvcComponent abilitySvcComponent;
    @Resource
    AbilityExtMapper abilityExtMapper;
    @Resource
    AbilityModifyMapper abilityModifyMapper;
    @Resource
    AbilityWsExtMapper abilityWsExtMapper;

    @Override
    public QryAbilityParameterRspBO abilityParameter(QryAbilityParameterReqBO qryAbilityParameterReqBO) {
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(qryAbilityParameterReqBO.getAbilityId());
        AbilityParamPO abilityParamRsp = this.abilityParamMapper.queryLimitOne(abilityParamPO);
        QryAbilityParameterRspBO qryAbilityParameterRspBO = (QryAbilityParameterRspBO)BeanMapper.map((Object)abilityParamRsp, QryAbilityParameterRspBO.class);
        qryAbilityParameterRspBO.setReqRootNodeName("xml");
        qryAbilityParameterRspBO.setRspRootNodeName("xml");
        AbilityWsExtPO abilityWsExtPO = this.abilityWsExtMapper.queryByAbilityId(qryAbilityParameterReqBO.getAbilityId());
        if (abilityWsExtPO != null) {
            qryAbilityParameterRspBO.setWsdl(abilityWsExtPO.getAbilityWsdl());
        }
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(qryAbilityParameterReqBO.getAbilityId());
        List<String> inputProtocaList = Arrays.asList(abilityPO.getInputProtocal().split(","));
        qryAbilityParameterRspBO.setInputProtocaList(inputProtocaList);
        return qryAbilityParameterRspBO;
    }

    @Override
    @Transactional
    public void modReqParameter(QryAbilityParameterReqBO qryAbilityParameterReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityParamPO abilityParamReq = (AbilityParamPO)BeanMapper.map((Object)qryAbilityParameterReqBO, AbilityParamPO.class);
        AbilityParamPO abilityParam = new AbilityParamPO();
        abilityParam.setAbilityId(abilityParamReq.getAbilityId());
        AbilityParamPO abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParam);
        abilityParamReq.setRspJsonschema(abilityParamPO.getRspJsonschema());
        this.reCompile(abilityParamReq);
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityParamReq.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.ABILITY_REQXSD_UPDATE.getValue());
        abilityModifyPO.setModifyRecord("");
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(new Date());
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    @Transactional
    public void modRspParameter(QryAbilityParameterReqBO qryAbilityParameterReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AbilityParamPO abilityParamRsp = (AbilityParamPO)BeanMapper.map((Object)qryAbilityParameterReqBO, AbilityParamPO.class);
        AbilityParamPO abilityParam = new AbilityParamPO();
        abilityParam.setAbilityId(abilityParamRsp.getAbilityId());
        AbilityParamPO abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParam);
        abilityParamRsp.setReqJsonschema(abilityParamPO.getReqJsonschema());
        this.reCompile(abilityParamRsp);
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityParamRsp.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.ABILITY_RSPXSD_UPDATE.getValue());
        abilityModifyPO.setModifyRecord("");
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(new Date());
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    @Transactional
    public void modWsdlParameter(QryAbilityParameterReqBO qryAbilityParameterReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        ValidBatchUtils.isNotEmpty((Object)qryAbilityParameterReqBO, (String[])new String[]{"wsdl", "abilityId"});
        AbilityParamPO abilityParamRsp = (AbilityParamPO)BeanMapper.map((Object)qryAbilityParameterReqBO, AbilityParamPO.class);
        AbilityParamPO abilityParam = new AbilityParamPO();
        abilityParam.setAbilityId(abilityParamRsp.getAbilityId());
        AbilityParamPO abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParam);
        abilityParamRsp.setReqJsonschema(abilityParamPO.getReqJsonschema());
        AbilityWsExtPO abilityWsExtPO = new AbilityWsExtPO();
        abilityWsExtPO.setAbilityWsdl(qryAbilityParameterReqBO.getWsdl());
        abilityWsExtPO.setAbilityId(qryAbilityParameterReqBO.getAbilityId());
        this.abilityWsExtMapper.updateAbilityWsExtByAbilityId(abilityWsExtPO);
        this.reCompileWs(abilityParamRsp, abilityWsExtPO);
        AbilityModifyPO abilityModifyPO = new AbilityModifyPO();
        abilityModifyPO.setAbilityId(abilityParamRsp.getAbilityId());
        abilityModifyPO.setOperType(AbilityOperateTypeEnum.ABILITY_RSPXSD_UPDATE.getValue());
        abilityModifyPO.setModifyRecord("\u4fee\u6539ws\u80fd\u529bwsdl");
        abilityModifyPO.setOperId(userId);
        abilityModifyPO.setOperTime(new Date());
        this.abilityModifyMapper.insertSelective(abilityModifyPO);
    }

    @Override
    public QryAbilityParameterTemplateRspBO parameterTemplate(QryAbilityParameterTemplateReqBO qryAbilityParameterTemplateReqBO) {
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(qryAbilityParameterTemplateReqBO.getAbilityId());
        abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParamPO);
        if (abilityParamPO == null) {
            return null;
        }
        QryAbilityParameterTemplateRspBO qryAbilityParameterTemplateRspBO = new QryAbilityParameterTemplateRspBO();
        qryAbilityParameterTemplateRspBO.setAbilityId(abilityParamPO.getAbilityId());
        if (qryAbilityParameterTemplateReqBO.getParamType() == 0) {
            qryAbilityParameterTemplateRspBO.setReqTemplate(abilityParamPO.getReqJsonTemplate());
            qryAbilityParameterTemplateRspBO.setRspTemplate(abilityParamPO.getRspJsonTemplate());
        } else if (qryAbilityParameterTemplateReqBO.getParamType() == 1) {
            qryAbilityParameterTemplateRspBO.setReqTemplate(abilityParamPO.getReqXmlTemplate());
            qryAbilityParameterTemplateRspBO.setRspTemplate(abilityParamPO.getRspXmlTemplate());
        } else if (qryAbilityParameterTemplateReqBO.getParamType() == 2) {
            qryAbilityParameterTemplateRspBO.setReqTemplate(abilityParamPO.getReqWsTemplate());
            qryAbilityParameterTemplateRspBO.setRspTemplate(abilityParamPO.getRspWsTemplate());
        } else {
            qryAbilityParameterTemplateRspBO.setReqTemplate(abilityParamPO.getReqJsonTemplate());
            qryAbilityParameterTemplateRspBO.setRspTemplate(abilityParamPO.getRspJsonTemplate());
        }
        return qryAbilityParameterTemplateRspBO;
    }

    @Override
    public void generateParameterTemplate(Long abilityId, String reqJsonSchema, String rspJsonSchema, String reqXsd, String rspXsd, String reqJarPath, String reqClassName, String rspJarPath, String rspClassName) throws Exception {
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(abilityId);
        abilityParamPO.setReqJsonschema(reqJsonSchema);
        abilityParamPO.setReqXsd(reqXsd);
        abilityParamPO.setRspJsonschema(rspJsonSchema);
        abilityParamPO.setRespXsd(rspXsd);
        URL reqUrl = new File(reqJarPath).toURI().toURL();
        URL rspUrl = new File(rspJarPath).toURI().toURL();
        try (URLClassLoader loader = new URLClassLoader(new URL[]{reqUrl, rspUrl}, Thread.currentThread().getContextClassLoader());){
            Class<?> reqClass = loader.loadClass(reqClassName);
            Class<?> rspClass = loader.loadClass(rspClassName);
            Object repObject = ObjectUtil.getObject(reqClass);
            Object rspObject = ObjectUtil.getObject(rspClass);
            abilityParamPO.setReqJsonTemplate(GsonUtil.toJson((Object)repObject));
            abilityParamPO.setRspJsonTemplate(GsonUtil.toJson((Object)rspObject));
            abilityParamPO.setReqXmlTemplate(JaxbUtil.beanToXml((Object)repObject));
            abilityParamPO.setRspXmlTemplate(JaxbUtil.beanToXml((Object)rspObject));
            this.abilityParamMapper.updateByAbilityId(abilityParamPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.abilityParamMapper.updateByAbilityId(abilityParamPO);
    }

    @Override
    public List<OptionGenerRspBO<String, Integer>> paramType(QryAbilityParameterTemplateReqBO qryAbilityParameterTemplateReqBO) {
        ArrayList paramType = new ArrayList();
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(qryAbilityParameterTemplateReqBO.getAbilityId());
        List<String> inputProtocaList = Arrays.asList(abilityPO.getInputProtocal().split(","));
        inputProtocaList.stream().forEach(in -> {
            OptionGenerRspBO<String, Integer> optionGener = this.getOptionGener((String)in);
            paramType.add(optionGener);
        });
        return paramType.stream().sorted(Comparator.comparing(OptionGenerRspBO::getValue)).collect(Collectors.toList());
    }

    @Override
    public RspBO<QryAbilityParameterFormatRspBO> paramFormat(QryAbilityParameterFormatReqBO qryAbilityParameterFormatReqBO) {
        if (StringUtils.isEmpty((Object)qryAbilityParameterFormatReqBO.getReqText())) {
            throw new ZTBusinessException("\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)qryAbilityParameterFormatReqBO.getParamType())) {
            throw new ZTBusinessException("\u4f20\u5165\u53c2\u6570\u7c7b\u578b\u4e3a\u7a7a");
        }
        String s = "";
        try {
            switch (qryAbilityParameterFormatReqBO.getParamType()) {
                case 0: {
                    s = JSONUtil.fomateByFastJson((String)qryAbilityParameterFormatReqBO.getReqText());
                    break;
                }
                case 1: {
                    s = XMLUtil.fomateXml((String)qryAbilityParameterFormatReqBO.getReqText());
                    break;
                }
                default: {
                    s = qryAbilityParameterFormatReqBO.getReqText();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u683c\u5f0f\u5316\u5931\u8d25\uff0c\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f>>>" + e.getMessage());
        }
        QryAbilityParameterFormatRspBO qryAbilityParameterFormatRspBO = new QryAbilityParameterFormatRspBO();
        qryAbilityParameterFormatRspBO.setParamType(qryAbilityParameterFormatReqBO.getParamType());
        qryAbilityParameterFormatRspBO.setRspText(s);
        RspBO rspBO = RspBO.success((Object)qryAbilityParameterFormatRspBO);
        return rspBO;
    }

    public OptionGenerRspBO<String, Integer> getOptionGener(String type) {
        OptionGenerRspBO option = new OptionGenerRspBO((Serializable)((Object)"JSON"), (Serializable)Integer.valueOf(0));
        switch (type) {
            case "json": {
                option = new OptionGenerRspBO((Serializable)((Object)"JSON"), (Serializable)Integer.valueOf(0));
                break;
            }
            case "xml": {
                option = new OptionGenerRspBO((Serializable)((Object)"XML"), (Serializable)Integer.valueOf(1));
                break;
            }
            case "ws": {
                option = new OptionGenerRspBO((Serializable)((Object)"WS"), (Serializable)Integer.valueOf(2));
                break;
            }
            default: {
                option = new OptionGenerRspBO((Serializable)((Object)"JSON"), (Serializable)Integer.valueOf(0));
            }
        }
        return option;
    }

    private void reCompile(AbilityParamPO abilityParam) {
        String reqXml = "";
        String rspXml = "";
        try {
            reqXml = this.abilitySvcComponent.jsonSchemaToXsd(abilityParam.getReqJsonschema(), "xml");
            rspXml = this.abilitySvcComponent.jsonSchemaToXsd(abilityParam.getRspJsonschema(), "xml");
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u62a5\u6587\u53c2\u6570\uff01\uff01\uff01");
        }
        AbilityExtPO abilityExtPOReq = new AbilityExtPO();
        abilityExtPOReq.setAbilityId(abilityParam.getAbilityId());
        abilityExtPOReq = this.abilityExtMapper.queryLimitOne(abilityExtPOReq);
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(abilityParam.getAbilityId());
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(abilityParam.getAbilityId());
        AbilityParamPO abilityParamBefore = this.abilityParamMapper.queryLimitOne(abilityParamPO);
        abilityParam.setReqJsonschemaFilename(abilityParamBefore.getReqJsonschemaFilename());
        abilityParam.setRspJsonschemaFilename(abilityParamBefore.getRspJsonschemaFilename());
        abilityParam.setReqXsdFile(abilityParamBefore.getReqXsdFile());
        abilityParam.setReqXsd(reqXml);
        abilityParam.setRespXsdFile(abilityParamBefore.getRespXsdFile());
        abilityParam.setRespXsd(rspXml);
        this.abilitySvcComponent.deployCustomSvc(abilityPO, abilityExtPOReq, abilityParam);
    }

    private void reCompileWs(AbilityParamPO abilityParam, AbilityWsExtPO abilityWsExtPO) {
        AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(abilityParam.getAbilityId());
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(abilityParam.getAbilityId());
        AbilityParamPO abilityParamBefore = this.abilityParamMapper.queryLimitOne(abilityParamPO);
        abilityParam.setReqJsonschemaFilename(abilityParamBefore.getReqJsonschemaFilename());
        abilityParam.setRspJsonschemaFilename(abilityParamBefore.getRspJsonschemaFilename());
        abilityParam.setReqXsdFile(abilityParamBefore.getReqXsdFile());
        abilityParam.setReqXsd(StringUtils.isEmpty((Object)abilityParamBefore.getReqJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityParamBefore.getReqJsonschema(), "xml"));
        abilityParam.setRespXsdFile(abilityParamBefore.getRespXsdFile());
        abilityParam.setRespXsd(StringUtils.isEmpty((Object)abilityParamBefore.getRspJsonschema()) ? null : this.abilitySvcComponent.jsonSchemaToXsd(abilityParamBefore.getRspJsonschema(), "xml"));
        AbilityExtPO abilityExtPO = this.abilityExtMapper.queryByAbilityId(abilityParam.getAbilityId());
        this.abilitySvcComponent.deployCustomSvcFromWsdl(abilityPO, abilityWsExtPO, abilityExtPO);
    }
}

