/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.export.impl;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.google.common.collect.Lists;
import com.ohaotian.abilityadmin.ability.model.bo.export.ExportAbilityReqBO;
import com.ohaotian.abilityadmin.ability.service.export.AbilityExportService;
import com.ohaotian.abilityadmin.mapper.AbilityAppMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AbilityPluginDeployMapper;
import com.ohaotian.abilityadmin.mapper.AbilityPluginMapper;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityadmin.mapper.ExportMapper;
import com.ohaotian.abilityadmin.mapper.PluginTypeMapper;
import com.ohaotian.abilityadmin.model.po.AbilityAppPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityPluginDeployPO;
import com.ohaotian.abilityadmin.model.po.AbilityPluginPO;
import com.ohaotian.abilityadmin.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityadmin.model.po.PluginTypePO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.ExportBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.PluginService;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AbilityExportServiceImpl
implements AbilityExportService {
    @Resource
    AbilityMapper abilityMapper;
    @Resource
    AbilityAppMapper abilityAppMapper;
    @Resource
    AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    AbilityPluginMapper abilityPluginMapper;
    @Resource
    AbilityPluginDeployMapper abilityPluginDeployMapper;
    @Resource
    ExportMapper exportMapper;
    @Resource
    private PluginTypeMapper pluginTypeMapper;
    @Resource
    private PluginService pluginService;
    @Value(value="${ability.table.schema}")
    private String TABLE_SCHEMA;

    @Override
    public void exportAbility(ExportAbilityReqBO exportReqBO, HttpServletResponse response) throws IOException {
        List<AbilityAppPO> provideList;
        ValidBatchUtils.isNotEmpty((Object)exportReqBO, (String[])new String[]{"abilityIds"});
        List<Long> abilityIds = exportReqBO.getAbilityIds();
        int pos = 1;
        if (CollectionUtils.isEmpty(abilityIds)) {
            throw new ZTBusinessException(CodeMsg.APP_ARG_ERROR.getMessage() + ": abilityIds");
        }
        String fileName = new String(("ability-" + new SimpleDateFormat("yyyy-MM-dd").format(new Date())).getBytes(), "UTF-8");
        ServletOutputStream out = response.getOutputStream();
        response.setContentType("multipart/form-data");
        response.setCharacterEncoding("utf-8");
        response.setHeader("File-name", fileName + ".xlsx");
        response.setHeader("File-type", "Stream");
        ExcelWriter writer = new ExcelWriter((OutputStream)out, ExcelTypeEnum.XLSX, true);
        ArrayList exportBOList = Lists.newArrayList();
        ExportBO ability = ExportBO.builder().tableName("ability").columns(Stream.of("hirer_id", "ability_name", "ability_ename", "ability_version", "input_protocal", "output_protocal", "output_trans_protocal", "is_message_check", "ability_type", "remark", "app_code_source", "app_code_path", "ability_id").collect(Collectors.toList())).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(ability);
        ExportBO abilityLogic = ExportBO.builder().tableName("ability_logic").columns(null).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(abilityLogic);
        ExportBO subAbility = ExportBO.builder().tableName("sub_ability").columns(null).ids(abilityIds).ralationColumn("parent_ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(subAbility);
        ExportBO abilityParam = ExportBO.builder().tableName("ability_param").columns(Stream.of("ability_param_id", "ability_id", "req_jsonschema_filename", "req_jsonschema", "rsp_jsonschema_filename", "rsp_jsonschema", "req_xsd", "req_xsd_file", "resp_xsd", "resp_xsd_file").collect(Collectors.toList())).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(abilityParam);
        ExportBO abilityExtColumn = ExportBO.builder().tableName("ability_ext_column").columns(Stream.of("ability_ext_column_id", "ext_one", "ext_two", "ext_three", "ext_four", "ext_five", "ext_six", "ext_seven", "ext_eight", "ext_nine", "ext_ten", "ability_id").collect(Collectors.toList())).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(abilityExtColumn);
        ExportBO abilityExtDefault = ExportBO.builder().tableName("ability_ext_default").columns(null).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(abilityExtDefault);
        ExportBO abilityProvideHsfDefault = ExportBO.builder().tableName("ability_provide_hsf_default").columns(null).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(abilityProvideHsfDefault);
        ExportBO abilityProvideHsfDefaultInput = ExportBO.builder().sheetName("hsf_default_input").tableName("ability_provide_hsf_default_input").columns(null).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(abilityProvideHsfDefaultInput);
        ExportBO abilityProvideDubboDefault = ExportBO.builder().tableName("ability_provide_dubbo_default").columns(null).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(abilityProvideDubboDefault);
        ExportBO abilityProvideDubboDefaultInput = ExportBO.builder().sheetName("dubbo_default_input").tableName("ability_provide_dubbo_default_input").columns(null).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(abilityProvideDubboDefaultInput);
        ExportBO abilityProvideHttpDefault = ExportBO.builder().tableName("ability_provide_http_default").columns(null).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(abilityProvideHttpDefault);
        ExportBO rateLimiterAbilityDefault = ExportBO.builder().tableName("rate_limiter_ability_default").columns(Stream.of("rate_limiter_ability_default_id", "global_limit", "single_limit", "rate", "capacity", "daily_capacity", "single_max_rate", "single_max_count", "single_daily_max_count", "ability_id").collect(Collectors.toList())).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(rateLimiterAbilityDefault);
        ExportBO abilityTrans = ExportBO.builder().tableName("ability_trans").columns(Stream.of("ability_trans_id", "req_trans_type", "rsp_trans_type", "front_logic", "back_logic", "front_schema", "back_schema", "front_template", "back_template", "front_protocal", "back_protocal", "ability_id").collect(Collectors.toList())).ids(abilityIds).ralationColumn("ability_id").position(Integer.valueOf(pos++)).build();
        exportBOList.add(abilityTrans);
        List<AbilityPO> abilityPOList = this.abilityMapper.queryByAbilityIds(abilityIds);
        ArrayList abilityAppPOList = Lists.newArrayList();
        for (AbilityPO abilityPO : abilityPOList) {
            AbilityAppPO tmp = new AbilityAppPO();
            tmp.setAbilityEname(abilityPO.getAbilityEname());
            tmp.setHirerId(abilityPO.getHirerId());
            tmp.setAbilityVersion(abilityPO.getAbilityVersion());
            abilityAppPOList.addAll(this.abilityAppMapper.queryByCond(tmp));
        }
        Map<Integer, List<AbilityAppPO>> map = abilityAppPOList.stream().collect(Collectors.groupingBy(AbilityAppPO::getRelationType));
        ArrayList abilityAppRows = Lists.newArrayList();
        for (AbilityAppPO abilityAppPO : abilityAppPOList) {
            ArrayList objs = Lists.newArrayList();
            objs.add(abilityAppPO.getAbilityAppId());
            objs.add(abilityAppPO.getHirerId());
            objs.add(abilityAppPO.getAbilityEname());
            objs.add(abilityAppPO.getAbilityVersion());
            objs.add(abilityAppPO.getAppCode());
            objs.add(abilityAppPO.getRelationType());
            abilityAppRows.add(objs);
        }
        Sheet sheet = new Sheet(pos++, 3);
        sheet.setSheetName("ability_app");
        sheet.setAutoWidth(Boolean.TRUE);
        ArrayList header = Lists.newArrayList();
        ArrayList strs = Lists.newArrayList();
        strs.add("abilityAppId");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("hirerId");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("abilityEname");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("abilityVersion");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("appCode");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("relationType");
        header.add(strs);
        sheet.setHead((List)header);
        ExportBO abilityApp = ExportBO.builder().sheet(sheet).rows((List)abilityAppRows).build();
        exportBOList.add(abilityApp);
        List<AbilityAppPO> subscribeList = map.get(0);
        if (!CollectionUtils.isEmpty(subscribeList)) {
            List subscribeIds = subscribeList.stream().map(AbilityAppPO::getAbilityAppId).collect(Collectors.toList());
            ExportBO appSubscribeDeploy = ExportBO.builder().tableName("app_subscribe_deploy").columns(Stream.of("subscribe_deploy_id", "ability_app_id", "cluster_id").collect(Collectors.toList())).ids(subscribeIds).ralationColumn("ability_app_id").position(Integer.valueOf(pos++)).build();
            exportBOList.add(appSubscribeDeploy);
        }
        if (!CollectionUtils.isEmpty(provideList = map.get(1))) {
            List<Long> provideIds = provideList.stream().map(AbilityAppPO::getAbilityAppId).collect(Collectors.toList());
            List<AbilityProvideDeployPO> abilityProvideDeployPOList = this.abilityProvideDeployMapper.queryByabilityAppIds(provideIds);
            List list = abilityProvideDeployPOList.stream().map(AbilityProvideDeployPO::getProvideDeployId).collect(Collectors.toList());
            ArrayList provideDeployRows = Lists.newArrayList();
            Iterator iterator = abilityProvideDeployPOList.iterator();
            while (iterator.hasNext()) {
                AbilityProvideDeployPO abilityProvideDeployPO = (AbilityProvideDeployPO)iterator.next();
                ArrayList objs = Lists.newArrayList();
                objs.add(abilityProvideDeployPO.getProvideDeployId());
                objs.add(abilityProvideDeployPO.getAbilityAppId());
                objs.add(abilityProvideDeployPO.getRegionCode());
                objs.add(abilityProvideDeployPO.getClusterId());
                provideDeployRows.add(objs);
            }
            sheet = new Sheet(pos++, 3);
            sheet.setSheetName("ability_provide_deploy");
            sheet.setAutoWidth(Boolean.TRUE);
            header = Lists.newArrayList();
            strs = Lists.newArrayList();
            strs.add("provideDeployId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("abilityAppId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("regionCode");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("clusterId");
            header.add(strs);
            sheet.setHead((List)header);
            ExportBO abilityProvideDeploy = ExportBO.builder().sheet(sheet).rows((List)provideDeployRows).build();
            exportBOList.add(abilityProvideDeploy);
            ExportBO abilityProvideHsfCustom = ExportBO.builder().tableName("ability_provide_hsf_custom").columns(Stream.of("hsf_custom_id", "provide_deploy_id", "group_name", "version", "interface_name", "method_name").collect(Collectors.toList())).ids(list).ralationColumn("provide_deploy_id").position(Integer.valueOf(pos++)).build();
            exportBOList.add(abilityProvideHsfCustom);
            ExportBO abilityProvideHsfCustomInput = ExportBO.builder().sheetName("hsf_custom_input").tableName("ability_provide_hsf_custom_input").columns(Stream.of("hsf_custom_input_id", "provide_deploy_id", "args_name", "args_path", "sort").collect(Collectors.toList())).ids(list).ralationColumn("provide_deploy_id").position(Integer.valueOf(pos++)).build();
            exportBOList.add(abilityProvideHsfCustomInput);
            ExportBO abilityProvideDubboCustom = ExportBO.builder().tableName("ability_provide_dubbo_custom").columns(Stream.of("dubbo_custom_id", "provide_deploy_id", "group_name", "version", "interface_name", "method_name").collect(Collectors.toList())).ids(list).ralationColumn("provide_deploy_id").position(Integer.valueOf(pos++)).build();
            exportBOList.add(abilityProvideDubboCustom);
            ExportBO abilityProvideDubboCustomInput = ExportBO.builder().sheetName("dubbo_custom_input").tableName("ability_provide_dubbo_custom_input").columns(Stream.of("dubbo_custom_input_id", "provide_deploy_id", "args_name", "args_path", "sort").collect(Collectors.toList())).ids(list).ralationColumn("provide_deploy_id").position(Integer.valueOf(pos++)).build();
            exportBOList.add(abilityProvideDubboCustomInput);
            ExportBO abilityProvideHttpCustom = ExportBO.builder().tableName("ability_provide_http_custom").columns(Stream.of("http_custom_id", "provide_deploy_id", "epr_path").collect(Collectors.toList())).ids(list).ralationColumn("provide_deploy_id").position(Integer.valueOf(pos++)).build();
            exportBOList.add(abilityProvideHttpCustom);
        }
        ArrayList abilityPluginPOList = Lists.newArrayList();
        for (AbilityPO abilityPO : abilityPOList) {
            AbilityPluginPO tmp = new AbilityPluginPO();
            tmp.setAbilityEname(abilityPO.getAbilityEname());
            tmp.setHirerId(abilityPO.getHirerId());
            tmp.setAbilityVersion(abilityPO.getAbilityVersion());
            abilityPluginPOList.addAll(this.abilityPluginMapper.queryByCond(tmp));
        }
        if (!CollectionUtils.isEmpty((Collection)abilityPluginPOList)) {
            ExportBO abilityPluginDeploy;
            sheet = new Sheet(pos++, 3);
            sheet.setSheetName("ability_plugin");
            sheet.setAutoWidth(Boolean.TRUE);
            header = Lists.newArrayList();
            strs = Lists.newArrayList();
            strs.add("abilityPluginId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("hirerId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("pluginEname");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("abilityEname");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("abilityVersion");
            header.add(strs);
            sheet.setHead((List)header);
            ArrayList abilityPluginRows = Lists.newArrayList();
            for (AbilityPluginPO abilityPluginPO : abilityPluginPOList) {
                ArrayList objs = Lists.newArrayList();
                objs.add(abilityPluginPO.getAbilityPluginId());
                objs.add(abilityPluginPO.getHirerId());
                objs.add(abilityPluginPO.getPluginEname());
                objs.add(abilityPluginPO.getAbilityEname());
                objs.add(abilityPluginPO.getAbilityVersion());
                abilityPluginRows.add(objs);
            }
            ExportBO exportBO = ExportBO.builder().sheet(sheet).rows((List)abilityPluginRows).build();
            exportBOList.add(exportBO);
            List<Long> abilityPluginIds = abilityPluginPOList.stream().map(AbilityPluginPO::getAbilityPluginId).collect(Collectors.toList());
            List<AbilityPluginDeployPO> abilityPluginDeployPOList = this.abilityPluginDeployMapper.queryByabilityPluginIds(abilityPluginIds);
            sheet = new Sheet(pos++, 3);
            sheet.setSheetName("ability_plugin_deploy");
            sheet.setAutoWidth(Boolean.TRUE);
            header = Lists.newArrayList();
            strs = Lists.newArrayList();
            strs.add("abilityPluginDeployId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("abilityPluginId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("clusterId");
            header.add(strs);
            sheet.setHead((List)header);
            ArrayList abilityPluginDeployRows = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(abilityPluginDeployPOList)) {
                for (AbilityPluginDeployPO abilityPluginDeployPO : abilityPluginDeployPOList) {
                    ArrayList objs = Lists.newArrayList();
                    objs.add(abilityPluginDeployPO.getAbilityPluginDeployId());
                    objs.add(abilityPluginDeployPO.getAbilityPluginId());
                    objs.add(abilityPluginDeployPO.getClusterId());
                    abilityPluginDeployRows.add(objs);
                }
                abilityPluginDeploy = ExportBO.builder().sheet(sheet).rows((List)abilityPluginDeployRows).build();
                exportBOList.add(abilityPluginDeploy);
                List abilityPluginDeployIds = abilityPluginDeployPOList.stream().map(AbilityPluginDeployPO::getAbilityPluginDeployId).collect(Collectors.toList());
                ArrayList pluginExportBOs = Lists.newArrayList();
                List<PluginTypePO> pluginTypePOList = this.pluginTypeMapper.queryByCond(new PluginTypePO());
                AbilityPluginReqBO abilityPluginReqBO = new AbilityPluginReqBO();
                abilityPluginReqBO.setAbilityPluginDeployIds(abilityPluginDeployIds);
                for (PluginTypePO po : pluginTypePOList) {
                    abilityPluginReqBO.setPluginType(po.getPluginType());
                    RspBO rspBO = this.pluginService.handleGetAbilityPlugin(abilityPluginReqBO, ExtensionPointPositionEnum.EXPORT_POSITION.getCode());
                    if (!"0".equals(rspBO.getCode()) || CollectionUtils.isEmpty((Collection)((Collection)rspBO.getData()))) continue;
                    pluginExportBOs.addAll((Collection)rspBO.getData());
                }
                if (!CollectionUtils.isEmpty((Collection)pluginExportBOs)) {
                    for (ExportBO exportBO2 : pluginExportBOs) {
                        exportBO2.getSheet().setSheetNo(pos);
                        exportBOList.add(exportBO2);
                        ++pos;
                    }
                }
            } else {
                abilityPluginDeploy = ExportBO.builder().sheet(sheet).rows((List)abilityPluginDeployRows).build();
                exportBOList.add(abilityPluginDeploy);
            }
        }
        this.buildSheets(exportBOList);
        this.buildRows(exportBOList);
        for (ExportBO exportBO : exportBOList) {
            writer.write1(exportBO.getRows(), exportBO.getSheet());
        }
        writer.finish();
        out.flush();
    }

    private List<ExportBO> buildSheets(List<ExportBO> exportBOList) {
        if (!CollectionUtils.isEmpty(exportBOList)) {
            for (ExportBO bo : exportBOList) {
                if (bo.getSheet() != null) continue;
                Sheet sheet = new Sheet(bo.getPosition().intValue(), 3);
                sheet.setSheetName(StrUtil.isNullOrEmpty((String)bo.getSheetName()) ? bo.getTableName() : bo.getSheetName());
                sheet.setAutoWidth(Boolean.TRUE);
                ArrayList header = Lists.newArrayList();
                List<String> columns = bo.getColumns();
                if (CollectionUtils.isEmpty((Collection)columns)) {
                    List<String> cols = this.exportMapper.queryColumnByTableName(bo.getTableName(), this.TABLE_SCHEMA);
                    bo.setColumns(cols);
                    columns = cols;
                }
                for (String column : columns) {
                    ArrayList strs = Lists.newArrayList();
                    strs.add(StrUtil.unlineToCamel((String)column));
                    header.add(strs);
                }
                sheet.setHead((List)header);
                bo.setSheet(sheet);
            }
        }
        return exportBOList;
    }

    private List<ExportBO> buildRows(List<ExportBO> exportBOList) {
        if (!CollectionUtils.isEmpty(exportBOList)) {
            for (ExportBO bo : exportBOList) {
                List<Map<String, Object>> maps;
                if (bo.getRows() != null) continue;
                ArrayList rows = Lists.newArrayList();
                if (!CollectionUtils.isEmpty((Collection)bo.getIds()) && !CollectionUtils.isEmpty(maps = this.exportMapper.queryByCond(bo.getColumns(), bo.getTableName(), bo.getRalationColumn(), bo.getIds()))) {
                    for (Map<String, Object> map : maps) {
                        ArrayList list = Lists.newArrayList();
                        for (String column : bo.getColumns()) {
                            list.add(map.get(column));
                        }
                        rows.add(list);
                    }
                }
                bo.setRows((List)rows);
            }
        }
        return exportBOList;
    }
}

