/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.config.pubsub.redis;

import com.ohaotian.abilityadmin.config.pubsub.ChannelNaming;
import com.ohaotian.abilityadmin.config.pubsub.properties.PubSubResProperties;
import com.ohaotian.plugin.cache.CacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PubSubRedisProvider {
    private static final Logger log = LoggerFactory.getLogger(PubSubRedisProvider.class);
    @Autowired
    private PubSubResProperties pubSubResProperties;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${atp.channel.value.size:200}")
    private int channelValueSize;

    public void provideMessage(String channel, String value) {
        if (!channel.equals(ChannelNaming.get(this.pubSubResProperties.getAdmin2web()))) {
            channel = ChannelNaming.get(this.pubSubResProperties.getAdmin2web()) + "_" + channel;
        }
        try {
            this.cacheClient.publish(channel, value);
        }
        catch (Exception e) {
            log.error("publish channel error,{} --- {}", (Object)channel, (Object)e.getMessage());
        }
    }
}

