/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.component.deploy;

import com.google.common.collect.Lists;
import com.ohaotian.abilityadmin.ability.service.AbilityParameterService;
import com.ohaotian.abilityadmin.config.GenerationArguments;
import com.ohaotian.abilityadmin.mapper.AbilityExtMapper;
import com.ohaotian.abilityadmin.model.po.AbilityExtPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AbilityParamPO;
import com.ohaotian.abilityadmin.model.po.AbilityWsExtPO;
import com.ohaotian.abilityadmin.util.DynamicCompilerUtil;
import com.ohaotian.abilityadmin.util.ToolsJarUtil;
import com.ohaotian.abilityadmin.util.jsons2xsd.Config;
import com.ohaotian.abilityadmin.util.jsons2xsd.Jsons2Xsd;
import com.ohaotian.abilityadmin.util.jsons2xsd.XmlUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.util.FileUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.portalcommon.util.ws.WSDLCommand;
import com.ohaotian.portalcommon.util.ws.WSDLParams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Jsonschema2Pojo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Component
public class AbilitySvcComponent {
    private static Logger logger = LogManager.getLogger(AbilitySvcComponent.class);
    @Resource
    AbilityExtMapper abilityExtMapper;
    @Resource
    AbilityParameterService abilityParameterService;
    @Value(value="${deploy.ability.Symbol:_}")
    String symbol = "_";
    private static final String WSDL_COMMA = ".wsdl";
    private static final String JAR_COMMA = ".jar";
    private static final String JAVAPATH = "java";
    private static final String CLASSPATH = "class";

    public boolean deployCustomSvc(AbilityPO abilityPO, AbilityExtPO abilityExtPO, AbilityParamPO abilityParamPO) {
        String abilityName = abilityPO.getAbilityEname().replace(".", "_");
        String abilityVersion = abilityPO.getAbilityVersion().replace(".", "_");
        String abilityXsdDir = Constants.projectPath.ABILITY_XSD_PATH;
        String abilitySourcePath = Constants.projectPath.ABILITY_JAVA_PATH;
        String abilityClassPath = Constants.projectPath.ABILITY_CLASS_PATH;
        String abilityJarPath = Constants.projectPath.ABILITY_JAR_PATH;
        String abilityJsonPath = Constants.projectPath.ABILITY_JSON_PATH;
        StringBuilder sb = new StringBuilder();
        sb.append(abilityName).append("_");
        if (abilityVersion.toUpperCase().indexOf("V") >= 0) {
            sb.append(abilityVersion);
        } else {
            sb.append("v").append(abilityVersion);
        }
        String abilityPath = sb.toString();
        List collect = Lists.newArrayList((Object[])new String[]{abilityXsdDir, abilitySourcePath, abilityClassPath, abilityJarPath, abilityJsonPath}).stream().flatMap(a -> {
            String path = Constants.SEPA + abilityPath;
            String servicePath = a + path + "_" + "abilityId" + abilityPO.getAbilityId();
            FileUtil.mkSeriveDir((String)servicePath);
            FileUtil.delAllFile((String)servicePath);
            String reqPath = servicePath + path + "_" + "req";
            String rspPath = servicePath + path + "_" + "rsp";
            FileUtil.mkSeriveDir((String)reqPath);
            FileUtil.mkSeriveDir((String)rspPath);
            return Lists.newArrayList((Object[])new String[]{servicePath, reqPath, rspPath}).stream();
        }).collect(Collectors.toList());
        String jsonSchemaReq = (String)collect.get(13) + Constants.SEPA + "req";
        String jsonSchemaRsp = (String)collect.get(14) + Constants.SEPA + "rsp";
        try {
            FileUtil.writeFile((String)abilityParamPO.getReqJsonschema(), (String)jsonSchemaReq);
            FileUtil.writeFile((String)abilityParamPO.getRspJsonschema(), (String)jsonSchemaRsp);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a" + e.getMessage());
        }
        String packageNameReq = abilityPath + "_" + "req";
        String packageNameRsp = abilityPath + "_" + "rsp";
        String webJarPath = Constants.projectPath.ABILITY_LIB_PATH;
        try {
            AbilitySvcComponent.jsonSchemaToJava(jsonSchemaReq, (String)collect.get(4), packageNameReq, "Req", "xml");
            AbilitySvcComponent.jsonSchemaToJava(jsonSchemaRsp, (String)collect.get(5), packageNameRsp, "Rsp", "xml");
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u5c06json\u8f6c\u5316java\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        try {
            String xsdReq = (String)collect.get(1) + Constants.SEPA + "req";
            String xsdRsp = (String)collect.get(2) + Constants.SEPA + "rsp";
            FileUtil.writeFile((String)abilityParamPO.getReqXsd(), (String)xsdReq);
            FileUtil.writeFile((String)abilityParamPO.getRespXsd(), (String)xsdRsp);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u5c06xsd\u8f6c\u5316json\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        try {
            this.compilesJava2Class(webJarPath, (String)collect.get(4), (String)collect.get(7));
            this.compilesJava2Class(webJarPath, (String)collect.get(5), (String)collect.get(8));
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u5c06java\u6587\u4ef6\u8f6c\u5316class\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        String reqjarFilrName = abilityPath + "_" + "req" + "." + "jar";
        String rspjarFilrName = abilityPath + "_" + "rsp" + "." + "jar";
        String reqjarPath = (String)collect.get(10) + Constants.SEPA + reqjarFilrName;
        String rspjarPath = (String)collect.get(11) + Constants.SEPA + rspjarFilrName;
        try {
            int i = ToolsJarUtil.execCmdWithoutResult(reqjarPath, "./", (String)collect.get(7));
            if (i != 0) {
                throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u8bf7\u6c42class\u6587\u4ef6\u6253jar\u5305\u5931\u8d25");
            }
            int j = ToolsJarUtil.execCmdWithoutResult(rspjarPath, "./", (String)collect.get(8));
            if (j != 0) {
                throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u8fd4\u56declass\u6587\u4ef6\u6253jar\u5305\u5931\u8d25");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u5c06class\u6587\u4ef6\u6253\u5305\u5f02\u5e38:" + e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
            throw new ZTBusinessException("Interrupted! \u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u5c06class\u6587\u4ef6\u6253\u5305\u5f02\u5e38:" + e.getMessage());
        }
        String reqClassName = packageNameReq + "." + StrUtil.fristToUpCase((String)"req");
        String rspClassName = packageNameRsp + "." + StrUtil.fristToUpCase((String)"rsp");
        try {
            abilityExtPO.setReqJarFilename(reqjarFilrName);
            abilityExtPO.setReqJarContent(this.getJarString(reqjarPath));
            abilityExtPO.setReqClassName(reqClassName);
            abilityExtPO.setRspJarFilename(rspjarFilrName);
            abilityExtPO.setRspJarContent(this.getJarString(rspjarPath));
            abilityExtPO.setRspClassName(rspClassName);
            this.abilityExtMapper.updateAbilityExtByAbilityExtId(abilityExtPO);
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u5c06\u7f16\u8bd1\u6587\u4ef6\u5165\u5e93\u5931\u8d25:" + e.getMessage());
        }
        logger.debug("\u8bf7\u6c42json\u8def\u5f84\uff1a{}", (Object)jsonSchemaReq);
        logger.debug("\u8fd4\u56dejson\u8def\u5f84\uff1a{}", (Object)jsonSchemaRsp);
        try {
            this.abilityParameterService.generateParameterTemplate(abilityPO.getAbilityId(), abilityParamPO.getReqJsonschema(), abilityParamPO.getRspJsonschema(), abilityParamPO.getReqXsd(), abilityParamPO.getRespXsd(), reqjarPath, abilityExtPO.getReqClassName(), rspjarPath, abilityExtPO.getRspClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u751f\u6210\u53c2\u6570\u6a21\u7248\u5f02\u5e38:" + e.getMessage());
        }
        return true;
    }

    public boolean deployCustomSvcFromWsdl(AbilityPO abilityPO, AbilityWsExtPO abilityWsExtPO, AbilityExtPO abilityExtPO) {
        String abilityPath;
        String abilityName = abilityPO.getAbilityEname().replace(".", "_");
        String abilityVersion = abilityPO.getAbilityVersion().replace(".", "_");
        Long abilityId = abilityPO.getAbilityId();
        String abilityWSDir = Constants.projectPath.ABILITY_WS_PATH;
        StringBuilder sb = new StringBuilder();
        sb.append(abilityWSDir).append(Constants.SEPA).append(abilityName).append("_");
        if (abilityVersion.toUpperCase().indexOf("V") >= 0) {
            sb.append(abilityVersion);
        } else {
            sb.append("v").append(abilityVersion);
        }
        String wsdlPath = abilityPath = sb.toString();
        String javaPath = wsdlPath + Constants.SEPA + JAVAPATH;
        String classPath = wsdlPath + Constants.SEPA + CLASSPATH;
        String packgeName = abilityName + "_" + abilityVersion;
        String wsdlFile = wsdlPath + Constants.SEPA + abilityId + WSDL_COMMA;
        String jarFile = abilityId + JAR_COMMA;
        String jarPath = javaPath + Constants.SEPA + abilityId + JAR_COMMA;
        FileUtil.mkSeriveDir((String)abilityPath);
        FileUtil.mkSeriveDir((String)wsdlPath);
        FileUtil.delAllFile((String)wsdlPath);
        FileUtil.writeFile((String)abilityWsExtPO.getAbilityWsdl(), (String)wsdlFile);
        WSDLParams build = WSDLParams.builder().javaPath(javaPath).classPath(classPath).jarPath(jarFile).packgeName(packgeName).wsdlUrl(wsdlFile).build();
        try {
            WSDLCommand.wsdl2java((WSDLParams)build);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u7f16\u8bd1wsdl\u751f\u6210jar\u5931\u8d25:" + e.getMessage());
        }
        String reqClassName = packgeName + ".";
        try {
            abilityExtPO.setReqJarFilename(jarFile);
            abilityExtPO.setReqJarContent(this.getJarString(jarPath));
            abilityExtPO.setReqClassName(reqClassName);
            this.abilityExtMapper.updateAbilityExtByAbilityExtId(abilityExtPO);
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new ZTBusinessException("\u80fd\u529b\u5f02\u5e38[" + abilityPath + "]\uff1a\uff0c\u5c06\u7f16\u8bd1\u6587\u4ef6\u5165\u5e93\u5931\u8d25:" + e.getMessage());
        }
        return true;
    }

    public static Schema readXMLSchema(String xsdSchema, String filePath) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        InputStream[] inputStreams = new InputStream[]{new ByteArrayInputStream(xsdSchema.getBytes("UTF-8"))};
        Source[] sources = new Source[inputStreams.length];
        for (int i = 0; i < inputStreams.length; ++i) {
            sources[i] = new StreamSource(inputStreams[i]);
        }
        Schema schema = factory.newSchema(sources);
        Files.write(Paths.get(filePath, new String[0]), xsdSchema.getBytes("UTF-8"), new OpenOption[0]);
        return schema;
    }

    public void compilesXsd2Json(String outPath, String xsdPath) throws Exception {
        URL schema = new URL("file:///" + xsdPath);
        String[] arguments = new String[]{"-xmlschema", schema.toExternalForm(), "-d", outPath, "-Xjsonix-compact", "-Xjsonix-generateJsonSchema"};
        logger.error("Jsonix\u5df2\u88ab\u79fb\u9664\uff0c\u5b58\u5728\u95ee\u9898\u9700\u8981\u89e3\u51b3\uff01");
    }

    public void compilesJava2Class(String webJarPath, String sourcePath, String classPath) throws IOException {
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        boolean compilerResult = DynamicCompilerUtil.compiler("UTF-8", DynamicCompilerUtil.getCompilerJarFiles(webJarPath), sourcePath, Constants.SYSTEM_PATH, classPath, diagnostics);
        if (compilerResult) {
            logger.info("\u7f16\u8bd1\u6210\u529f");
        } else {
            logger.error("\u7f16\u8bd1\u5931\u8d25");
            Iterator<Diagnostic<JavaFileObject>> iterator = diagnostics.getDiagnostics().iterator();
            if (iterator.hasNext()) {
                Diagnostic<JavaFileObject> diagnostic = iterator.next();
                throw new ZTBusinessException(diagnostic.getMessage(null));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJarString(String jarPath) {
        String baseJar = null;
        File file = new File(jarPath);
        try (FileInputStream inputFile = new FileInputStream(file);){
            byte[] buffer = new byte[(int)file.length()];
            inputFile.read(buffer);
            inputFile.close();
            String string = baseJar = Base64Utils.encodeToString((byte[])buffer);
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return baseJar;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baseJar;
    }

    public static void jsonSchemaToJava(String jsonSchemaPath, String javaPath, String packageName, String fileName, String xmlRootElement) {
        try {
            GenerationArguments arguments = new GenerationArguments();
            ArrayList<URL> sourceList = new ArrayList<URL>();
            sourceList.add(new File(jsonSchemaPath).toURI().toURL());
            arguments.setSourcePaths(sourceList);
            arguments.setTargetDirectory(new File(javaPath));
            arguments.setAnnotationStyle(AnnotationStyle.JAXB);
            arguments.setTargetPackage(packageName);
            arguments.setXmlRootElement(xmlRootElement);
            arguments.setFileName(fileName);
            Jsonschema2Pojo.generate(arguments);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String jsonSchemaToXsd(String jsonSchema, String xmlRootElement) {
        try {
            Config cfg = new Config.Builder().createRootElement(true).targetNamespace("http://www.w3.org/2001/XMLSchema").nsAlias("xsd").name(xmlRootElement).validateXsdSchema(true).build();
            Document doc = Jsons2Xsd.convert(jsonSchema, cfg);
            return XmlUtil.asXmlString(doc.getDocumentElement());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

