/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.util;

import com.alibaba.fastjson.JSON;
import com.ohaotian.abilityadmin.util.CopyDirectoryUtil;
import com.ohaotian.portalcommon.constant.Constants;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DynamicCompilerUtil {
    private static Logger logger = LogManager.getLogger(DynamicCompilerUtil.class);

    public static boolean isnull(String str) {
        if (null == str) {
            return false;
        }
        if ("".equals(str)) {
            return false;
        }
        return !"null".equals(str);
    }

    public static boolean compiler(String encoding, String jars, String filePath, String sourceDir, String targetDir, DiagnosticCollector<JavaFileObject> diagnostics) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);){
            if (!(DynamicCompilerUtil.isnull(filePath) || DynamicCompilerUtil.isnull(sourceDir) || DynamicCompilerUtil.isnull(targetDir))) {
                boolean bl = false;
                return bl;
            }
            File sourceFile = new File(filePath);
            ArrayList<File> sourceFileList = new ArrayList<File>();
            DynamicCompilerUtil.getSourceFiles(sourceFile, sourceFileList, targetDir);
            if (sourceFileList.size() == 0) {
                logger.info(filePath + "\u76ee\u5f55\u4e0b\u67e5\u627e\u4e0d\u5230\u4efb\u4f55java\u6587\u4ef6");
                boolean bl = false;
                return bl;
            }
            logger.info("\u83b7\u53d6\u6587\u4ef6" + JSON.toJSONString(sourceFileList));
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(sourceFileList);
            logger.info(sourceDir);
            logger.info(targetDir);
            List<String> options = Arrays.asList("-encoding", encoding, "-cp", jars, "-target", "1.8", "-d", targetDir, "-sourcepath", sourceDir);
            logger.info(options.toString());
            JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
            boolean bl = compilationTask.call();
            return bl;
        }
    }

    private static void getSourceFiles(File sourceFile, List<File> sourceFileList, final String targetDir) {
        if (sourceFile.exists() && sourceFileList != null) {
            if (sourceFile.isDirectory()) {
                File[] childrenFiles;
                for (File childFile : childrenFiles = sourceFile.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (pathname.isDirectory()) {
                            try {
                                CopyDirectoryUtil.copyDirectiory(pathname.getPath(), targetDir + pathname.getPath().substring(pathname.getPath().indexOf("src") + 3, pathname.getPath().length()));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            return true;
                        }
                        String name = pathname.getName();
                        if (name.endsWith(".java")) {
                            return true;
                        }
                        try {
                            CopyDirectoryUtil.copyFile(pathname, new File(targetDir + pathname.getPath().substring(pathname.getPath().indexOf("src") + 3, pathname.getPath().length())));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                })) {
                    DynamicCompilerUtil.getSourceFiles(childFile, sourceFileList, targetDir);
                }
            } else {
                sourceFileList.add(sourceFile);
            }
        }
    }

    public static String getCompilerJarFiles(String jarPath) {
        String[] list = new File(jarPath).list();
        String comm = ":";
        if (DynamicCompilerUtil.isWindows()) {
            comm = ";";
        }
        return Arrays.asList(list).stream().filter(a -> a.endsWith(".jar")).map(a -> {
            a = jarPath + Constants.SEPA + a;
            return a;
        }).collect(Collectors.joining(comm));
    }

    public static void putBootJar(String libPath) {
        block5: {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            logger.info("\u83b7\u53d6\u5bb9\u5668\u8d44\u6e90\u89e3\u6790\u5668");
            try {
                Resource[] resources;
                for (Resource resource : resources = resolver.getResources("/lib/*.jar")) {
                    InputStream stream = resource.getInputStream();
                    if (logger.isInfoEnabled()) {
                        logger.info("\u8bfb\u53d6\u7684\u6587\u4ef6\u6d41  [" + stream + "]");
                    }
                    String targetFilePath = libPath + Constants.SEPA + resource.getFilename();
                    if (logger.isInfoEnabled()) {
                        logger.info("\u653e\u7f6e\u4f4d\u7f6e  [" + targetFilePath + "]");
                    }
                    File ttfFile = new File(targetFilePath);
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)ttfFile);
                }
            }
            catch (IOException e) {
                if (!logger.isWarnEnabled()) break block5;
                logger.warn("\u8bfb\u53d6\u6587\u4ef6\u6d41\u5931\u8d25\uff0c\u5199\u5165\u672c\u5730\u5e93\u5931\u8d25\uff01 " + e);
            }
        }
    }

    public static boolean isWindows() {
        return System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1;
    }
}

