/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.enums;

import com.ohaotian.abilitycommon.util.StrUtil;

public enum ContentType {
    FORM_URLENCODED("application/x-www-form-urlencoded"),
    MULTIPART("multipart/form-data"),
    JSON("application/json"),
    XML("application/xml"),
    TEXT_XML("text/xml"),
    TEXT_XML_UTF_8("text/xml;charset=UTF-8");

    private String value;

    private ContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static boolean isDefault(String contentType) {
        return null == contentType || ContentType.isFormUrlEncoed(contentType);
    }

    public static boolean isFormUrlEncoed(String contentType) {
        return FORM_URLENCODED.toString().equals(contentType);
    }

    public static ContentType get(String body) {
        ContentType contentType = null;
        if (!StrUtil.isNullOrEmpty(body)) {
            char firstChar = body.charAt(0);
            switch (firstChar) {
                case '[': 
                case '{': {
                    contentType = JSON;
                    break;
                }
                case '<': {
                    contentType = XML;
                    break;
                }
            }
        }
        return contentType;
    }
}

