/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.js;

import java.util.Arrays;
import java.util.List;
import jdk.nashorn.api.scripting.ClassFilter;
import org.apache.commons.lang3.StringUtils;

public class ScriptClassFilter
implements ClassFilter {
    private final List<String> securityClasses = Arrays.asList("java.lang.String", "java.lang.StringBuffer", "java.lang.StringBuilder", "java.lang.Long", "java.lang.Double");
    private final List<String> securityPackages = Arrays.asList("java.util", "java.time", "java.math");
    private final List<String> dangerousClasses = Arrays.asList("java.io.File", "java.io.RandomAccessFile", "java.io.FileInputStream", "java.io.FileOutputStream", "java.lang.Class", "java.lang.ClassLoader", "java.lang.Runtime", "java.lang.System", "java.lang.Thread", "java.lang.ThreadGroup", "java.lang.ProcessBuilder");
    private final List<String> dangerousPackages = Arrays.asList("java.io", "java.net", "java.security", "java.text.spi", "java.util.zip", "java.util.logging", "java.util.spi", "java.util.jar", "java.lang.reflect");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean exposeToScripts(String s) {
        if (this.securityClasses.stream().anyMatch(s1 -> StringUtils.equals((CharSequence)s, (CharSequence)s1))) {
            return true;
        }
        if (this.dangerousClasses.stream().anyMatch(s1 -> StringUtils.equals((CharSequence)s, (CharSequence)s1))) {
            return false;
        }
        if (!this.securityPackages.stream().anyMatch(s::startsWith)) return false;
        if (!this.dangerousPackages.stream().noneMatch(s::startsWith)) return false;
        return true;
    }
}

