/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.reflect.TypeToken;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class GsonUtil {
    private static final Gson GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").setLongSerializationPolicy(LongSerializationPolicy.STRING).disableHtmlEscaping().create();

    public static String toJson(Object object) {
        return GSON.toJson(object);
    }

    public static <T> T fromJson(String json, Class<T> tClass) {
        return (T)GSON.fromJson(json, tClass);
    }

    public static <T> List<T> fromList(String string, Class<T[]> cls) {
        Object[] array = (Object[])GSON.fromJson(string, cls);
        return Arrays.asList(array);
    }

    public static String toGetParam(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return "";
        }
        Map<String, String> map = GsonUtil.toStringMap(json);
        StringBuilder stringBuilder = new StringBuilder();
        map.forEach((k, v) -> stringBuilder.append((String)k).append("=").append((String)v).append("&"));
        String r = stringBuilder.toString();
        return r.substring(0, r.lastIndexOf("&"));
    }

    public static Map<String, String> toStringMap(String json) {
        return (Map)GSON.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
    }

    public static List<Map> toListMap(String json) {
        return (List)GSON.fromJson(json, new TypeToken<List<Map>>(){}.getType());
    }

    public static Map<String, Object> toObjectMap(String json) {
        TypeToken<Map<String, Object>> typeToken = new TypeToken<Map<String, Object>>(){};
        Gson gson = new GsonBuilder().serializeNulls().registerTypeHierarchyAdapter(typeToken.getRawType(), new MapDeserializer()).create();
        return (Map)gson.fromJson(json, typeToken.getType());
    }

    public static void main(String[] args) {
        String jsonStr = "{\n    \"abilityId\": \"11111\",\n    \"abilityName\": \"\u80fd\u529b\u4e2d\u6587\u540d\",\n    \"abilityEname\": \"abilityEname\"\n}";
        String jsonArrayStr = "[{\n    \"abilityId\": \"11111\",\n    \"abilityName\": \"\u80fd\u529b\u4e2d\u6587\u540d\",\n    \"abilityEname\": \"abilityEname\"\n}]";
        EsbAbility esbAbility = GsonUtil.fromJson(jsonStr, EsbAbility.class);
        System.out.println(esbAbility);
        List list = GsonUtil.fromList(jsonArrayStr, EsbAbility[].class);
        System.out.println(list);
    }

    private static class MapDeserializer<T, U>
    implements JsonDeserializer<Map<T, U>> {
        private MapDeserializer() {
        }

        public Map<T, U> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            Set jsonEntrySet = jsonObject.entrySet();
            LinkedHashMap deserializedMap = new LinkedHashMap();
            for (Map.Entry entry : jsonEntrySet) {
                Object value = context.deserialize((JsonElement)entry.getValue(), (Type)this.getType((JsonElement)entry.getValue()));
                deserializedMap.put(entry.getKey(), value);
            }
            return deserializedMap;
        }

        public Class getType(JsonElement element) {
            if (element.isJsonPrimitive()) {
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                if (primitive.isString()) {
                    return String.class;
                }
                if (primitive.isNumber()) {
                    String numStr = primitive.getAsString();
                    if (numStr.contains(".") || numStr.contains("e") || numStr.contains("E")) {
                        return Double.class;
                    }
                    return Long.class;
                }
                if (primitive.isBoolean()) {
                    return Boolean.class;
                }
            }
            return element.getClass();
        }
    }
}

