/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.json.JSONNull;
import net.sf.json.xml.XMLSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JsonXmlUtil {
    public static final Log log = LogFactory.getLog(JsonXmlUtil.class);

    public static Map readJson2Map(String json) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map maps = (Map)objectMapper.readValue(json, Map.class);
        return maps;
    }

    public static String xml2JSON(String xml, Boolean isRemoveAttribute, Boolean islowercase) {
        return new XMLSerializer().read(xml).toString();
    }

    public static Map xml2Map(String xml, Boolean toUpper) {
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        Document doc = null;
        try {
            doc = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
        }
        catch (DocumentException e) {
            throw new AbilityException("\u5c06xml\u8f6c\u6362\u6210json\u51fa\u9519", (Throwable)e);
        }
        Map map = new HashMap();
        if (doc == null) {
            return map;
        }
        org.dom4j.Element root = doc.getRootElement();
        Map<String, Object> rootMap = new HashMap<String, Object>();
        if (root.elementIterator().hasNext()) {
            map = (Map)JsonXmlUtil.xml2map(doc.getRootElement());
            String rootName = root.getName();
            rootMap = new HashMap();
            rootMap.put(rootName, map);
            if (toUpper != null && !toUpper.booleanValue()) {
                rootMap = JsonXmlUtil.map2Lowercase(rootMap);
            } else if (toUpper != null && toUpper.booleanValue()) {
                rootMap = JsonXmlUtil.map2Uppercase(rootMap);
            }
            return rootMap;
        }
        String rootName = root.getName();
        String value = root.getText();
        rootMap.put(rootName, value);
        if (!toUpper.booleanValue()) {
            rootMap = JsonXmlUtil.map2Lowercase(rootMap);
        } else if (toUpper.booleanValue()) {
            rootMap = JsonXmlUtil.map2Uppercase(rootMap);
        }
        return rootMap;
    }

    public static Map map2Lowercase(Map<String, Object> map) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().toLowerCase();
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                m.put(key.toLowerCase(), JsonXmlUtil.map2Lowercase((Map)obj));
            }
            if (obj instanceof List) {
                ArrayList list = new ArrayList();
                if (((List)obj).size() > 0) {
                    int i;
                    if (((List)obj).get(0) instanceof Map) {
                        for (i = 0; i < ((List)obj).size(); ++i) {
                            list.add(JsonXmlUtil.map2Lowercase((Map)((List)obj).get(i)));
                        }
                        m.put(key.toLowerCase(), list);
                    } else {
                        for (i = 0; i < ((List)obj).size(); ++i) {
                            list.add(((List)obj).get(i));
                        }
                        m.put(key.toLowerCase(), list);
                    }
                } else {
                    m.put(key.toLowerCase(), list);
                }
            }
            if (!(obj instanceof String)) continue;
            m.put(key.toLowerCase(), obj);
        }
        return m;
    }

    public static Map map2Uppercase(Map<String, Object> map) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().toLowerCase();
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                m.put(key.toUpperCase(), JsonXmlUtil.map2Uppercase((HashMap)obj));
            }
            if (obj instanceof List) {
                int j = ((List)obj).size();
                ArrayList<Map> list = new ArrayList<Map>();
                StringBuilder ArrayString = new StringBuilder();
                for (int i = 0; i < ((List)obj).size(); ++i) {
                    list.add(JsonXmlUtil.map2Uppercase((Map)((List)obj).get(i)));
                }
                m.put(key.toUpperCase(), list);
            }
            if (!(obj instanceof String)) continue;
            m.put(key.toUpperCase(), obj);
        }
        return m;
    }

    private static Object xml2map(org.dom4j.Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List elements = element.elements();
        if (elements.size() == 0) {
            map.put(element.getName(), element.getText());
            if (!element.isRootElement()) {
                return element.getText();
            }
        } else if (elements.size() == 1) {
            map.put(((org.dom4j.Element)elements.get(0)).getName(), JsonXmlUtil.xml2map((org.dom4j.Element)elements.get(0)));
        } else if (elements.size() > 1) {
            HashMap<String, org.dom4j.Element> tempMap = new HashMap<String, org.dom4j.Element>();
            for (org.dom4j.Element ele : elements) {
                tempMap.put(ele.getName(), ele);
            }
            Set entries = tempMap.entrySet();
            for (Map.Entry entry : entries) {
                Namespace namespace = ((org.dom4j.Element)entry.getValue()).getNamespace();
                List elements2 = element.elements(new QName((String)entry.getKey(), namespace));
                if (elements2.size() > 1) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (org.dom4j.Element ele : elements2) {
                        list.add(JsonXmlUtil.xml2map(ele));
                    }
                    map.put((String)entry.getKey(), list);
                    continue;
                }
                map.put((String)entry.getKey(), JsonXmlUtil.xml2map((org.dom4j.Element)elements2.get(0)));
            }
        }
        return map;
    }

    public static byte[] callMapToXML(Map map) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        JsonXmlUtil.mapToXML(map, sb);
        return sb.toString().getBytes("UTF-8");
    }

    private static void mapToXML(Map map, StringBuffer sb) {
        Set set = map.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Object value = map.get(key);
            if (null == value) {
                value = "";
            }
            if (value instanceof ArrayList) {
                ArrayList list = (ArrayList)map.get(key);
                if (list.size() == 0) {
                    sb.append("<" + key + ">");
                    sb.append("</" + key + ">");
                    continue;
                }
                if (list.get(0) instanceof Map) {
                    for (int i = 0; i < list.size(); ++i) {
                        sb.append("<" + key + ">");
                        HashMap hm = (HashMap)list.get(i);
                        JsonXmlUtil.mapToXML(hm, sb);
                        sb.append("</" + key + ">");
                    }
                    continue;
                }
                list.stream().forEach(k -> {
                    sb.append("<" + key + ">");
                    sb.append(k + "");
                    sb.append("</" + key + ">");
                });
                continue;
            }
            if (value instanceof HashMap) {
                sb.append("<" + key + ">");
                JsonXmlUtil.mapToXML((HashMap)value, sb);
                sb.append("</" + key + ">");
                continue;
            }
            sb.append("<" + key + ">" + value + "</" + key + ">");
        }
    }

    public static void get4Node(NodeList books, List list) {
        if (books instanceof Element) {
            for (int i = 0; i < books.getLength(); ++i) {
                if (!(books.item(i) instanceof Element)) continue;
                list.add(books.item(i).getNodeName());
                JsonXmlUtil.get4Node(books.item(i).getChildNodes(), list);
            }
        }
    }

    public static LinkedHashMap reloadMap(Object map, List list) {
        LinkedHashMap m = new LinkedHashMap();
        for (int i = 0; i < list.size(); ++i) {
            Object o;
            if (!(map instanceof Map) || (o = ((Map)(map = (Map)map)).get(list.get(i))) == null) continue;
            if (o instanceof Map) {
                LinkedHashMap m2 = JsonXmlUtil.reloadMap(o, list);
                m.put(list.get(i), m2);
                continue;
            }
            if (o instanceof List) {
                LinkedList<LinkedHashMap> li = new LinkedList<LinkedHashMap>();
                for (int k = 0; k < ((List)o).size(); ++k) {
                    LinkedHashMap m2 = JsonXmlUtil.reloadMap(((List)o).get(k), list);
                    li.add(m2);
                }
                m.put(list.get(i), li);
                continue;
            }
            m.put(list.get(i), o.toString());
        }
        return m;
    }

    public static org.w3c.dom.Document parse(Document doc) throws Exception {
        if (doc == null) {
            return null;
        }
        StringReader reader = new StringReader(doc.toString());
        InputSource source = new InputSource(reader);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(source);
    }

    public static LinkedHashMap parse(String json, org.w3c.dom.Document doc) throws ParserConfigurationException, SAXException, IOException {
        LinkedHashMap<String, LinkedHashMap> m = new LinkedHashMap<String, LinkedHashMap>();
        LinkedList list = new LinkedList();
        Element root = doc.getDocumentElement();
        if (root instanceof Element && root.getChildNodes() != null) {
            Map map = JsonXmlUtil.readJson2Map(json);
            Object value = map.get(root.getNodeName());
            JsonXmlUtil.get4Node(root.getChildNodes(), list);
            JsonXmlUtil.reloadMap(value, list);
            m.put(root.getNodeName(), JsonXmlUtil.reloadMap(value, list));
        }
        return m;
    }

    public static LinkedHashMap parse(String json, String protocolXML) throws ParserConfigurationException, SAXException, IOException {
        LinkedHashMap<String, LinkedHashMap> m = new LinkedHashMap<String, LinkedHashMap>();
        LinkedList list = new LinkedList();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        org.w3c.dom.Document doc = builder.parse(new InputSource(new StringReader(protocolXML)));
        Element root = doc.getDocumentElement();
        if (root instanceof Element && root.getChildNodes() != null) {
            Map map = JsonXmlUtil.readJson2Map(json);
            Object value = map.get(root.getNodeName());
            JsonXmlUtil.get4Node(root.getChildNodes(), list);
            JsonXmlUtil.reloadMap(value, list);
            m.put(root.getNodeName(), JsonXmlUtil.reloadMap(value, list));
        }
        return m;
    }

    public static Map map2CamelCase(Map<String, Object> map) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = StringUtils.camelCaseName(entry.getKey());
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                m.put(key, JsonXmlUtil.map2CamelCase((HashMap)obj));
                continue;
            }
            if (obj instanceof List) {
                int j = ((List)obj).size();
                ArrayList list = new ArrayList();
                StringBuilder ArrayString = new StringBuilder();
                for (int i = 0; i < ((List)obj).size(); ++i) {
                    if (((List)obj).get(i) instanceof String) {
                        list.add(((List)obj).get(i));
                        continue;
                    }
                    list.add(JsonXmlUtil.map2CamelCase((Map)((List)obj).get(i)));
                }
                m.put(key, list);
                continue;
            }
            if (obj instanceof String) {
                m.put(key, obj);
                continue;
            }
            m.put(key, obj);
        }
        return m;
    }

    public static Map map2UnderscoreWithAllValue(Map<String, Object> map) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = StringUtils.underscoreName(entry.getKey());
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                m.put(key, JsonXmlUtil.map2UnderscoreWithAllValue((HashMap)obj));
                continue;
            }
            if (obj instanceof List) {
                int j = ((List)obj).size();
                ArrayList<Map> list = new ArrayList<Map>();
                StringBuilder ArrayString = new StringBuilder();
                for (int i = 0; i < ((List)obj).size(); ++i) {
                    list.add(JsonXmlUtil.map2UnderscoreWithAllValue((Map)((List)obj).get(i)));
                }
                m.put(key, list);
                continue;
            }
            if (obj == null || "".equals(obj)) {
                m.put(key, "");
                continue;
            }
            m.put(key, String.valueOf(obj));
        }
        return m;
    }

    public static Map map2Underscore(Map<String, Object> map) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = StringUtils.underscoreName(entry.getKey());
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                m.put(key, JsonXmlUtil.map2Underscore((HashMap)obj));
                continue;
            }
            if (obj instanceof List) {
                int j = ((List)obj).size();
                ArrayList list = new ArrayList();
                StringBuilder ArrayString = new StringBuilder();
                for (int i = 0; i < ((List)obj).size(); ++i) {
                    if (((List)obj).get(i) instanceof String) {
                        list.add(((List)obj).get(i));
                        continue;
                    }
                    list.add(JsonXmlUtil.map2Underscore((Map)((List)obj).get(i)));
                }
                m.put(key, list);
                continue;
            }
            if (obj == null || "".equals(obj) || obj instanceof JSONNull) {
                m.put(key, "");
                continue;
            }
            m.put(key, String.valueOf(obj));
        }
        return m;
    }

    public static String json2SortedXml(String json, Document templateDoc) {
        StringBuffer sb = new StringBuffer();
        try {
            JsonXmlUtil.mapToXML(JsonXmlUtil.parse(json, templateDoc.asXML()), sb);
        }
        catch (ParserConfigurationException e) {
            throw new AbilityException("\u5c06json\u8f6c\u6362\u6210\u6709\u5e8fxml\u51fa\u9519", (Throwable)e);
        }
        catch (SAXException e) {
            throw new AbilityException("\u5c06json\u8f6c\u6362\u6210\u6709\u5e8fxml\u51fa\u9519", (Throwable)e);
        }
        catch (IOException e) {
            throw new AbilityException("\u5c06json\u8f6c\u6362\u6210\u6709\u5e8fxml\u51fa\u9519", (Throwable)e);
        }
        catch (Exception e) {
            throw new AbilityException("\u5c06json\u8f6c\u6362\u6210\u6709\u5e8fxml\u51fa\u9519", (Throwable)e);
        }
        return sb.toString();
    }

    public static <T> String mapToJson(Map<String, T> map) {
        Gson gson = new Gson();
        String jsonStr = gson.toJson(map);
        return jsonStr;
    }

    public static Map xml2Map(String xml) {
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        Document doc = null;
        try {
            doc = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")));
        }
        catch (DocumentException e) {
            throw new AbilityException("\u5c06xml\u8f6c\u6362\u6210json\u51fa\u9519", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new AbilityException("\u5c06xml\u8f6c\u6362\u6210json\u51fa\u9519", (Throwable)e);
        }
        Map map = new HashMap();
        if (doc == null) {
            return map;
        }
        org.dom4j.Element root = doc.getRootElement();
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        if (root.elementIterator().hasNext()) {
            map = (Map)JsonXmlUtil.xml2map(doc.getRootElement());
            String rootName = root.getName();
            rootMap = new HashMap();
            rootMap.put(rootName, map);
            return rootMap;
        }
        String rootName = root.getName();
        String value = root.getText();
        rootMap.put(rootName, value);
        return rootMap;
    }
}

