/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.atp.base.gemini.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.atp.base.gemini.model.AbilityGeminiSendMsgReqBo;
import com.ohaotian.atp.base.gemini.model.GeminiSendAbilityReqBO;
import com.ohaotian.atp.base.gemini.service.AbilityGeminiService;
import com.ohaotian.atp.base.util.GetFileContentUtil;
import com.ohaotian.atp.base.util.HttpBaseUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class AbilityGeminiServiceImpl
implements AbilityGeminiService {
    private static final Logger log = LoggerFactory.getLogger(AbilityGeminiServiceImpl.class);
    @Value(value="${geminiSendUrl:}")
    private String geminiSendUrl;
    @Value(value="${ability.gemini.taskCode:ability_token_refresh_notice}")
    private String taskCode;
    @Value(value="${ability.gemini.pluginNotice:false}")
    private Boolean pluginNotice;
    @Value(value="${ability.gemini.abilityNotice:false}")
    private Boolean abilityNotice;
    @Value(value="${ability.gemini.abilityNotice.names:}")
    private String abilityNoticeNames;
    @Value(value="classpath:info/version.txt")
    private Resource projectVersion;
    @Value(value="classpath:info/time.txt")
    private Resource packageTime;

    @Override
    public JSONObject sendMessage(AbilityGeminiSendMsgReqBo reqBo) {
        JSONObject rspBo = new JSONObject();
        if (StringUtils.isBlank((CharSequence)this.geminiSendUrl)) {
            rspBo.put("code", (Object)1);
            rspBo.put("messages", (Object)"\u672a\u914d\u7f6e\u901a\u77e5\u4e2d\u5fc3\u5730\u5740\uff01");
            return rspBo;
        }
        try {
            List<String> names;
            GeminiSendAbilityReqBO geminiSendAbilityReqBO = new GeminiSendAbilityReqBO();
            geminiSendAbilityReqBO.setSendId("666666");
            geminiSendAbilityReqBO.setSendName("\u80fd\u529b\u5e73\u53f0");
            geminiSendAbilityReqBO.setTaskCode(this.taskCode);
            String total = null;
            if (Boolean.TRUE.equals(this.pluginNotice) && StringUtils.isNotBlank((CharSequence)reqBo.getPluginName())) {
                total = reqBo.getPluginName() + " \u9274\u6743\u83b7\u53d6 ";
            }
            if (Boolean.TRUE.equals(this.abilityNotice) && StringUtils.isNotBlank((CharSequence)reqBo.getAbilityEname()) && StringUtils.isNotBlank((CharSequence)this.abilityNoticeNames) && (names = Arrays.asList(this.abilityNoticeNames.split(","))).contains(reqBo.getAbilityEname())) {
                total = reqBo.getAbilityName() + "(" + reqBo.getAbilityEname() + ") \u80fd\u529b\u8c03\u7528 ";
            }
            if (StringUtils.isBlank(total)) {
                rspBo.put("code", (Object)0);
                rspBo.put("messages", (Object)"\u6d88\u606f\u53d1\u9001\u8df3\u8fc7!");
                return rspBo;
            }
            total = total + (reqBo.isStatus() ? "\u6210\u529f." : "\u5931\u8d25!");
            geminiSendAbilityReqBO.setTitle(total);
            JSONObject data = JSON.parseObject((String)"{}");
            data.put("version", (Object)GetFileContentUtil.getFileContent(this.projectVersion));
            data.put("packTime", (Object)GetFileContentUtil.getFileContent(this.packageTime));
            data.put("message", (Object)reqBo.getErrorMsg());
            geminiSendAbilityReqBO.setData(data.toJSONString());
            LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
            headerMap.put("Content-Type", "application/json");
            int statusCode = HttpBaseUtil.doPostJson(this.geminiSendUrl.trim(), JSON.toJSONString((Object)geminiSendAbilityReqBO), (status, rsp) -> status, headerMap);
            if (statusCode != 200) {
                rspBo.put("code", (Object)1);
                rspBo.put("messages", (Object)("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01\u72b6\u6001:" + statusCode));
                return rspBo;
            }
            rspBo.put("code", (Object)0);
            rspBo.put("messages", (Object)"\u6d88\u606f\u53d1\u9001\u6210\u529f\uff01");
            return rspBo;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5f02\u5e38\uff01 ex:" + e.getMessage());
            rspBo.put("code", (Object)0);
            rspBo.put("messages", (Object)("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5f02\u5e38\uff01 ex:" + e.getMessage()));
            return rspBo;
        }
    }
}

