/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl.methods;

import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.model.bo.MethodAttributeBO;
import com.ohaotian.plugin.service.parse.tag.Methods;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.GeneralUtils;
import com.ohaotian.plugin.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.util.Iterator;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="Math")
public class MathMethodsImpl
implements Methods {
    @Autowired
    private Upath upath;

    @Override
    public <M> boolean doMethods(FaceMsgContext<M> faceMsgContext, Iterator iterator, String inPath, BaseMethods method) throws InterfaceException {
        BigDecimal arg1 = null;
        BigDecimal arg2 = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (arg1 == null && next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                arg1 = new BigDecimal(this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString());
                continue;
            }
            if (arg2 == null && next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                arg2 = new BigDecimal(this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString());
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                switch (method) {
                    case Math_add: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), GeneralUtils.getObjectByType(tagAttributes.getType(), arg1.add(arg2)));
                    }
                    case Math_sub: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), GeneralUtils.getObjectByType(tagAttributes.getType(), arg1.subtract(arg2)));
                    }
                    case Math_mul: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), GeneralUtils.getObjectByType(tagAttributes.getType(), arg1.multiply(arg2)));
                    }
                    case Math_div: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), GeneralUtils.getObjectByType(tagAttributes.getType(), arg1.divide(arg2)));
                    }
                    case Math_abs: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), GeneralUtils.getObjectByType(tagAttributes.getType(), arg1.abs()));
                    }
                    case Math_pow: {
                        if (tagAttributes.getType().equals(BaseObjects.OBJECT_DOUBLE.getCode())) {
                            return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), Math.pow(arg1.doubleValue(), arg2.doubleValue()));
                        }
                        throw new InterfaceException("\n\tMath.pow()\u65b9\u6cd5\u6682\u53ea\u652f\u6301Double\u7c7b\u578b,\u4e0d\u652f\u6301" + tagAttributes.getType() + "\u7c7b\u578b");
                    }
                    case Math_sqrt: {
                        if (tagAttributes.getType().equals(BaseObjects.OBJECT_DOUBLE.getCode())) {
                            return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), Math.sqrt(arg1.doubleValue()));
                        }
                        throw new InterfaceException("\n\tMath.sqrt()\u65b9\u6cd5\u6682\u53ea\u652f\u6301Double\u7c7b\u578b,\u4e0d\u652f\u6301" + tagAttributes.getType() + "\u7c7b\u578b");
                    }
                    case Math_random: {
                        if (tagAttributes.getType().equals(BaseObjects.OBJECT_DOUBLE.getCode())) {
                            return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), Math.random());
                        }
                        throw new InterfaceException("\n\tMath.random()\u65b9\u6cd5\u6682\u53ea\u652f\u6301Double\u7c7b\u578b,\u4e0d\u652f\u6301" + tagAttributes.getType() + "\u7c7b\u578b");
                    }
                    case Math_getLongRandom: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), new SnowflakeIdWorker(0L).nextId());
                    }
                }
                throw new InterfaceException("\n\tMath\u4e2d\u6ca1\u6709 " + method.getCode() + " \u65b9\u6cd5\u7684\u89e3\u6790\u65b9\u5f0f");
            }
            throw new InterfaceException("\n\tMath." + method.getCode() + "\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570:" + next.getName());
        }
        throw new InterfaceException("\n\tMath\u65b9\u6cd5\u89e3\u6790\u9519\u8bef: " + method.getCode() + " \u65b9\u6cd5\u6ca1\u6709\u8fdb\u884c\u8d4b\u503c\u64cd\u4f5c!");
    }
}

