/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.util.safety;

import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.util.safety.Algorithm;
import com.ohaotian.plugin.util.safety.Base64;
import com.ohaotian.plugin.util.safety.MD5Util;
import com.ohaotian.plugin.util.safety.Mkey;
import com.ohaotian.plugin.util.safety.constants.SafetyErrorCode;
import com.ohaotian.plugin.util.safety.model.SafetyEncoder;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SecurityUtil {
    private static final byte[] MKey_key = Mkey.getMkeyKey(true);

    public static String cimsDecryptAES(String syncData, String clientSecret) {
        String encSecret = SecurityUtil.preEncDec(clientSecret);
        return SecurityUtil.decryptAES(syncData, encSecret);
    }

    public static String preEncDec(String clientSecret) {
        String encSecret = SecurityUtil.encryptForSave(clientSecret);
        return SecurityUtil.decryptForSave(encSecret);
    }

    public static String encryptForSave(String MKey) {
        if (MKey == null || MKey.isEmpty()) {
            return null;
        }
        MKey = MD5Util.getMD5String(MKey);
        try {
            byte[] encryptedBytes = Algorithm.encryptSMS4PCS5Padding(MKey.getBytes(StandardCharsets.UTF_8), MKey_key);
            return Algorithm.encode(encryptedBytes, SafetyEncoder.Base64);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String decryptForSave(String encrypted) {
        if (encrypted == null || encrypted.isEmpty()) {
            return null;
        }
        try {
            byte[] encryptedByte = Algorithm.decode(encrypted, SafetyEncoder.Base64);
            return new String(Algorithm.decryptSMS4PCS5Padding(encryptedByte, MKey_key), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String encryptAES(String content, String secretKey) {
        SecurityUtil.checkParam(content, secretKey);
        return SecurityUtil.encrypt(content, secretKey);
    }

    public static String decryptAES(String encryptResultStr, String secretKey) {
        SecurityUtil.checkParam(encryptResultStr, secretKey);
        try {
            byte[] decryptFrom = Base64.getDecoder().decode(encryptResultStr);
            byte[] decryptResult = SecurityUtil.decrypt(decryptFrom, secretKey);
            return new String(decryptResult);
        }
        catch (Exception e) {
            throw new InterfaceException(SafetyErrorCode.CONTENT_EMPTY_ERROR.getMsg());
        }
    }

    private static void checkParam(String encryptResultStr, String secretKey) {
        if (SecurityUtil.isBlank(encryptResultStr)) {
            throw new InterfaceException(SafetyErrorCode.CONTENT_EMPTY_ERROR.getMsg());
        }
        if (!secretKey.matches("^[a-z0-9A-Z]+$")) {
            throw new InterfaceException(SafetyErrorCode.SECRET_KEY_ERROR.getMsg());
        }
    }

    private static String encrypt(String content, String secretKey) {
        try {
            byte[] raw = secretKey.getBytes("UTF-8");
            SecretKeySpec keySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, keySpec);
            byte[] bytes = cipher.doFinal(content.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new InterfaceException(SafetyErrorCode.CONTENT_ENCODE_ERROR.getMsg());
        }
    }

    private static byte[] decrypt(byte[] content, String secretKey) {
        try {
            byte[] raw = secretKey.getBytes("UTF-8");
            SecretKeySpec keySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, keySpec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new InterfaceException(SafetyErrorCode.SECRET_DECODE_ERROR.getMsg());
        }
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

