/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl.methods;

import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.model.bo.MethodAttributeBO;
import com.ohaotian.plugin.service.parse.tag.Methods;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.GeneralUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="Invoke")
public class InvokeMethodsImpl
implements Methods {
    @Autowired
    private Upath upath;

    @Override
    public <M> boolean doMethods(FaceMsgContext<M> faceMsgContext, Iterator iterator, String inPath, BaseMethods method) throws InterfaceException {
        String className = null;
        Object obj = null;
        String methodName = null;
        ArrayList<Object> objectList = new ArrayList<Object>();
        Object[] objects = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (method == BaseMethods.Invoke_static_method && className == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                className = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (method == BaseMethods.Invoke_method && obj == null && next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                obj = GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath()));
                continue;
            }
            if (methodName == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                methodName = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                objectList.add(GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath())));
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode())) {
                objects = objectList.stream().toArray();
                switch (method) {
                    case Invoke_method: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), this.invokeMethod(obj, methodName, objects));
                    }
                    case Invoke_static_method: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), this.invokeStaticMethod(className, methodName, objects));
                    }
                }
                throw new InterfaceException("Invoke\u4e2d\u6ca1\u6709" + method.getCode() + "\u65b9\u6cd5");
            }
            throw new InterfaceException(method.getCode() + "\u65b9\u6cd5\u4e2d\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570:\u6807\u7b7e\u4e3a" + next.getName());
        }
        objects = objectList.stream().toArray();
        switch (method) {
            case Invoke_method: {
                this.invokeMethod(obj, methodName, objects);
                return true;
            }
            case Invoke_static_method: {
                this.invokeStaticMethod(className, methodName, objects);
                return true;
            }
        }
        throw new InterfaceException("Invoke\u4e2d\u6ca1\u6709" + method.getCode() + "\u65b9\u6cd5");
    }

    public Object invokeMethod(Object obj, String methodName, Object ... args) {
        try {
            Class<?> clazz = obj.getClass();
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Method method = clazz.getMethod(methodName, argTypes);
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw new InterfaceException(e);
        }
    }

    public Object invokeStaticMethod(String className, String methodName, Object ... args) {
        try {
            Class<?> clazz = Class.forName(className);
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Method method = clazz.getMethod(methodName, argTypes);
            Object instance = clazz.newInstance();
            return method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new InterfaceException(e);
        }
    }
}

