/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.controller;

import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.enums.G3PlusAppendEnum;
import com.ohaotian.plugin.enums.G3PlusCallProtocolEnum;
import com.ohaotian.plugin.mapper.G3PlusHpartyCheckAppendMapper;
import com.ohaotian.plugin.mapper.G3PlusHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginG3PlusHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.PluginG3PlusHpartyCheckReqBO;
import com.ohaotian.plugin.model.bo.rsp.G3PlusAppendRspBO;
import com.ohaotian.plugin.model.bo.rsp.G3PlusCallProtocolRspBO;
import com.ohaotian.plugin.model.bo.rsp.PluginG3PlusHpartyCheckRspBO;
import com.ohaotian.plugin.model.po.G3PlusHpartyCheckAppendPO;
import com.ohaotian.plugin.model.po.G3PlusHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginG3PlusHpartyCheckPO;
import com.ohaotian.plugin.service.AbilityG3PlusHpartyCheckHandler;
import com.ohaotian.plugin.util.CronCheckUtil;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.api.RegionAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.RegionBO;
import com.ohaotian.portalcommon.model.bo.PluginReqBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/g3PlusHPC"})
public class G3PlusHpartyCheckController {
    private static final Logger logger = LogManager.getLogger(G3PlusHpartyCheckController.class);
    @Resource
    PluginAPI pluginAPI;
    @Resource
    AppAPI appAPI;
    @Resource
    RegionAPI regionAPI;
    @Resource
    PluginG3PlusHpartyCheckMapper pluginG3PlusHpartyCheckMapper;
    @Resource
    G3PlusHpartyCheckAppendMapper g3PlusHpartyCheckAppendMapper;
    @Resource
    G3PlusHpartyCheckTokenMapper g3PlusHpartyCheckTokenMapper;
    @Resource
    AbilityG3PlusHpartyCheckHandler abilityG3PlusHpartyCheckHandler;
    @Resource
    private AuthorityService authorityService;
    private static final String INPUT = "\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}";

    @PostMapping(value={"/pluginInfo"})
    @BusiResponseBody
    public RspBO getPluginInfo(@RequestBody PluginReqBO pluginReqBO) {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u901a\u8fc7\u63d2\u4ef6Id\u67e5\u8be2\u63d2\u4ef6\u57fa\u672c\u4fe1\u606f");
        logger.debug(INPUT, (Object)pluginReqBO);
        if (StringUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginReqBO.getPluginId());
        RspBO rspBO = RspBO.success((Object)pluginRspBO);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/pluginExtInfo"})
    @BusiResponseBody
    public RspBO getPluginExtInfo(@RequestBody PluginG3PlusHpartyCheckReqBO pluginG3PlusHpartyCheckReqBO) {
        logger.debug("G3PlusHpartyCheckPlugin-admin: \u67e5\u8be2\u63d2\u4ef6\u6269\u5c55\u4fe1\u606f");
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        logger.debug(INPUT, (Object)pluginG3PlusHpartyCheckReqBO);
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginG3PlusHpartyCheckPO pluginG3PlusHpartyCheckPO = new PluginG3PlusHpartyCheckPO();
        pluginG3PlusHpartyCheckPO.setPluginId(pluginG3PlusHpartyCheckReqBO.getPluginId());
        pluginG3PlusHpartyCheckPO = this.pluginG3PlusHpartyCheckMapper.queryLimitOne(pluginG3PlusHpartyCheckPO);
        PluginG3PlusHpartyCheckRspBO pluginG3PlusHpartyCheckRspBO = (PluginG3PlusHpartyCheckRspBO)BeanMapper.map((Object)pluginG3PlusHpartyCheckPO, PluginG3PlusHpartyCheckRspBO.class);
        AppBO appBO = this.appAPI.queryAppByRegionCode(tenantId, pluginG3PlusHpartyCheckPO.getRegionCode());
        RegionBO regionBO = this.regionAPI.queryRegionByAppIdAndRegionCode(appBO.getAppId(), pluginG3PlusHpartyCheckPO.getRegionCode());
        pluginG3PlusHpartyCheckRspBO.setAppId(appBO.getAppId());
        pluginG3PlusHpartyCheckRspBO.setAppRegionName(appBO.getAppName() + "/" + regionBO.getRegionName());
        String[] appRegion = new String[]{appBO.getAppId().toString(), regionBO.getRegionCode()};
        pluginG3PlusHpartyCheckRspBO.setAppRegion(appRegion);
        List<G3PlusHpartyCheckAppendPO> g3PlusHpartyCheckAppendPOS = this.g3PlusHpartyCheckAppendMapper.queryByPluginId(pluginG3PlusHpartyCheckReqBO.getPluginId());
        ArrayList<String> appends = new ArrayList<String>();
        for (G3PlusHpartyCheckAppendPO g3PlusHpartyCheckAppendPO : g3PlusHpartyCheckAppendPOS) {
            appends.add(g3PlusHpartyCheckAppendPO.getAppendContent());
        }
        pluginG3PlusHpartyCheckRspBO.setAppendContents(appends);
        return RspBO.success((Object)pluginG3PlusHpartyCheckRspBO);
    }

    @PostMapping(value={"/modPluginExt"})
    @BusiResponseBody
    public RspBO modPluginExt(@RequestBody PluginG3PlusHpartyCheckReqBO pluginG3PlusHpartyCheckReqBO) {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u4fee\u6539\u63d2\u4ef6\u6269\u5c55\u4fe1\u606f");
        logger.debug(INPUT, (Object)pluginG3PlusHpartyCheckReqBO);
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getPluginHpartyCheckId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (pluginG3PlusHpartyCheckReqBO.getAppRegion() == null || pluginG3PlusHpartyCheckReqBO.getAppRegion().length != 2) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5206\u533a");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u62fc\u88c5\u5185\u5bb9");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getClientSecret())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aef\u79d8\u94a5");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getUserName())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u540d");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getUserPassword())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u5bc6\u7801");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getTokenPath())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atoken\u5237\u65b0\u8def\u5f84");
        }
        boolean isValid = CronCheckUtil.isValidExpression(pluginG3PlusHpartyCheckReqBO.getRefreshInterval());
        if (!isValid) {
            throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5b9a\u65f6\u5237\u65b0\u8868\u8fbe\u5f0f");
        }
        if (pluginG3PlusHpartyCheckReqBO.getAppendContents() == null || pluginG3PlusHpartyCheckReqBO.getAppendContents().size() < 1) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u62fc\u88c5\u5185\u5bb9");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getCallProtocol())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8c03\u7528\u534f\u8bae");
        }
        if (pluginG3PlusHpartyCheckReqBO.getTaskSwitch() == null) {
            throw new ZTBusinessException("\u672a\u5237\u65b0\u4efb\u52a1\u5f00\u5173");
        }
        PluginG3PlusHpartyCheckPO oldPo = new PluginG3PlusHpartyCheckPO();
        oldPo.setPluginId(pluginG3PlusHpartyCheckReqBO.getPluginId());
        oldPo = this.pluginG3PlusHpartyCheckMapper.queryLimitOne(oldPo);
        PluginG3PlusHpartyCheckPO pluginG3PlusHpartyCheckPO = (PluginG3PlusHpartyCheckPO)BeanMapper.map((Object)pluginG3PlusHpartyCheckReqBO, PluginG3PlusHpartyCheckPO.class);
        pluginG3PlusHpartyCheckPO.setRegionCode(pluginG3PlusHpartyCheckReqBO.getAppRegion()[1]);
        this.pluginG3PlusHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginG3PlusHpartyCheckPO);
        PluginG3PlusHpartyCheckPO pluginG3PlusHpartyCheckPO1 = new PluginG3PlusHpartyCheckPO();
        pluginG3PlusHpartyCheckPO1.setPluginHpartyCheckId(pluginG3PlusHpartyCheckPO.getPluginHpartyCheckId());
        pluginG3PlusHpartyCheckPO1 = this.pluginG3PlusHpartyCheckMapper.queryLimitOne(pluginG3PlusHpartyCheckPO1);
        Long pluginId = pluginG3PlusHpartyCheckPO1.getPluginId();
        this.g3PlusHpartyCheckAppendMapper.deleteByPluginId(pluginId);
        List appends = pluginG3PlusHpartyCheckReqBO.getAppendContents();
        ArrayList<G3PlusHpartyCheckAppendPO> g3PlusHpartyCheckAppendPOS = new ArrayList<G3PlusHpartyCheckAppendPO>();
        for (String append : appends) {
            G3PlusHpartyCheckAppendPO g3PlusHpartyCheckAppendPO = new G3PlusHpartyCheckAppendPO();
            g3PlusHpartyCheckAppendPO.setPluginId(pluginId);
            g3PlusHpartyCheckAppendPO.setAppendContent(append);
            g3PlusHpartyCheckAppendPOS.add(g3PlusHpartyCheckAppendPO);
        }
        this.g3PlusHpartyCheckAppendMapper.insertRecords(g3PlusHpartyCheckAppendPOS);
        G3PlusHpartyCheckTokenPO g3PlusHpartyCheckTokenPO = new G3PlusHpartyCheckTokenPO();
        g3PlusHpartyCheckTokenPO.setPluginId(pluginId);
        g3PlusHpartyCheckTokenPO.setClientId(oldPo.getClientId());
        g3PlusHpartyCheckTokenPO.setUserName(oldPo.getUserName());
        g3PlusHpartyCheckTokenPO.setUserPassword(oldPo.getUserPassword());
        g3PlusHpartyCheckTokenPO.setTokenPath(oldPo.getTokenPath());
        g3PlusHpartyCheckTokenPO.setClientSecret(oldPo.getClientSecret());
        G3PlusHpartyCheckTokenPO oldTokenPO = this.g3PlusHpartyCheckTokenMapper.queryLimitOne(g3PlusHpartyCheckTokenPO);
        g3PlusHpartyCheckTokenPO = (G3PlusHpartyCheckTokenPO)BeanMapper.map((Object)pluginG3PlusHpartyCheckReqBO, G3PlusHpartyCheckTokenPO.class);
        g3PlusHpartyCheckTokenPO.setHpartyCheckTokenId(oldTokenPO.getHpartyCheckTokenId());
        this.g3PlusHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(g3PlusHpartyCheckTokenPO);
        this.abilityG3PlusHpartyCheckHandler.dealTask(pluginG3PlusHpartyCheckReqBO);
        RspBO rspBO = RspBO.success(null);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"allCallProtocol"})
    @BusiResponseBody
    public RspBO allCallProtocol() {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u8f93\u5165\u683c\u5f0f\u53c2\u6570\uff0cG3Plus\u8981\u6c42\u662fjson");
        ArrayList<G3PlusCallProtocolRspBO> g3PlusCallProtocolRspBOS = new ArrayList<G3PlusCallProtocolRspBO>();
        G3PlusCallProtocolRspBO g3PlusCallProtocolRspBO_json = new G3PlusCallProtocolRspBO("json", G3PlusCallProtocolEnum.JSON.getCode());
        g3PlusCallProtocolRspBOS.add(g3PlusCallProtocolRspBO_json);
        return RspBO.success(g3PlusCallProtocolRspBOS);
    }

    @PostMapping(value={"allAppend"})
    @BusiResponseBody
    public RspBO allAppend() {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u6dfb\u52a0\u7c7b\u578b");
        ArrayList<G3PlusAppendRspBO> g3PlusAppendRspBOS = new ArrayList<G3PlusAppendRspBO>();
        G3PlusAppendRspBO g3PlusAppendRspBO_token = new G3PlusAppendRspBO("token", G3PlusAppendEnum.TOKEN.getCode());
        G3PlusAppendRspBO g3PlusAppendRspBO_type = new G3PlusAppendRspBO("\u56fa\u5b9a\u503c", G3PlusAppendEnum.TYPE.getCode());
        G3PlusAppendRspBO g3PlusAppendRspBO_appkey = new G3PlusAppendRspBO("clientId", G3PlusAppendEnum.APPKEY.getCode());
        g3PlusAppendRspBOS.add(g3PlusAppendRspBO_token);
        g3PlusAppendRspBOS.add(g3PlusAppendRspBO_type);
        g3PlusAppendRspBOS.add(g3PlusAppendRspBO_appkey);
        return RspBO.success(g3PlusAppendRspBOS);
    }

    @PostMapping(value={"execute"})
    @BusiResponseBody
    public RspBO execute(@RequestBody PluginG3PlusHpartyCheckReqBO pluginG3PlusHpartyCheckReqBO) {
        logger.debug("G3PlusHpartyCheckPlugin--admin: execute!!!");
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getPluginHpartyCheckId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (pluginG3PlusHpartyCheckReqBO.getAppRegion() == null || pluginG3PlusHpartyCheckReqBO.getAppRegion().length != 2) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5206\u533a");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u62fc\u88c5\u5185\u5bb9");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getClientSecret())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aef\u79d8\u94a5");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getUserName())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u540d");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getUserPassword())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u5bc6\u7801");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getTokenPath())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atoken\u5237\u65b0\u8def\u5f84");
        }
        boolean isValid = CronCheckUtil.isValidExpression(pluginG3PlusHpartyCheckReqBO.getRefreshInterval());
        if (!isValid) {
            throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5b9a\u65f6\u5237\u65b0\u8868\u8fbe\u5f0f");
        }
        if (pluginG3PlusHpartyCheckReqBO.getAppendContents() == null || pluginG3PlusHpartyCheckReqBO.getAppendContents().size() < 1) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u62fc\u88c5\u5185\u5bb9");
        }
        if (StringUtils.isEmpty((Object)pluginG3PlusHpartyCheckReqBO.getCallProtocol())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8c03\u7528\u534f\u8bae");
        }
        if (pluginG3PlusHpartyCheckReqBO.getTaskSwitch() == null) {
            throw new ZTBusinessException("\u672a\u5237\u65b0\u4efb\u52a1\u5f00\u5173");
        }
        this.abilityG3PlusHpartyCheckHandler.execute(pluginG3PlusHpartyCheckReqBO);
        return RspBO.success((Object)Boolean.TRUE);
    }
}

