/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.menu;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ohaotian.authority.menu.bo.AddMenuCatalogReqBO;
import com.ohaotian.authority.menu.bo.AddSublevelMenuReqBO;
import com.ohaotian.authority.menu.bo.ChangeMenuOrderReqBO;
import com.ohaotian.authority.menu.bo.ChangeMenuStatusReqBO;
import com.ohaotian.authority.menu.bo.DeleteMenuReqBO;
import com.ohaotian.authority.menu.bo.SelMenuTreeToManagerReqBO;
import com.ohaotian.authority.menu.bo.SelectDetailByMenuIdReqBO;
import com.ohaotian.authority.menu.bo.SelectMenuByPIdReqBO;
import com.ohaotian.authority.menu.bo.SelectMenuCatalogReqBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeReqBO;
import com.ohaotian.authority.menu.bo.UpdateByMenuIdReqBO;
import com.ohaotian.authority.menu.service.AddMenuCatalogBusiService;
import com.ohaotian.authority.menu.service.AddSublevelMenuBusiService;
import com.ohaotian.authority.menu.service.ChangeMenuOrderDownBusiService;
import com.ohaotian.authority.menu.service.ChangeMenuOrderUpBusiService;
import com.ohaotian.authority.menu.service.ChangeMenuStatusBusiService;
import com.ohaotian.authority.menu.service.DeleteMenuBusiService;
import com.ohaotian.authority.menu.service.SelMenuTreeToManagerBusiService;
import com.ohaotian.authority.menu.service.SelectAllMenuTreeBusiService;
import com.ohaotian.authority.menu.service.SelectDetailByMenuIdBusiService;
import com.ohaotian.authority.menu.service.SelectMenuByPIdBusiService;
import com.ohaotian.authority.menu.service.SelectMenuCatalogBusiService;
import com.ohaotian.authority.menu.service.SelectMgrMenuTreeBusiService;
import com.ohaotian.authority.menu.service.UpdateByMenuIdBusiService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/menu"}, method={RequestMethod.GET, RequestMethod.POST})
public class MenuController {
    @Reference(version="1.0.0", group="authority")
    private SelectMenuCatalogBusiService selectMenuCatalogBusiService;
    @Reference(version="1.0.0", group="authority")
    private AddMenuCatalogBusiService addMenuCatalogBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectDetailByMenuIdBusiService selectDetailByMenuIdBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectMenuByPIdBusiService selectMenuByPIdBusiService;
    @Reference(version="1.0.0", group="authority")
    private AddSublevelMenuBusiService addSublevelMenuBusiService;
    @Reference(version="1.0.0", group="authority")
    private UpdateByMenuIdBusiService updateByMenuIdBusiService;
    @Reference(version="1.0.0", group="authority")
    private ChangeMenuStatusBusiService changeMenuStatusBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectAllMenuTreeBusiService selectAllMenuTreeBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectMgrMenuTreeBusiService selectMgrMenuTreeBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelMenuTreeToManagerBusiService selMenuTreeToManagerBusiService;
    @Reference(version="1.0.0", group="authority")
    private DeleteMenuBusiService deleteMenuBusiService;
    @Reference(version="1.0.0", group="authority")
    private ChangeMenuOrderUpBusiService changeMenuOrderUpBusiService;
    @Reference(version="1.0.0", group="authority")
    private ChangeMenuOrderDownBusiService changeMenuOrderDownBusiService;

    @RequestMapping(value={"/selectCatalog"})
    @BusiResponseBody
    public Object selectCatalog(SelectMenuCatalogReqBO selectMenuCatalogReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectMenuCatalogBusiService.selectMenuCatalog(selectMenuCatalogReqBO);
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3");
    }

    @RequestMapping(value={"/addCatalog"})
    @BusiResponseBody
    public Object addCatalog(AddMenuCatalogReqBO addMenuCatalogReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            addMenuCatalogReqBO.setMenuId(Long.valueOf(l));
            this.addMenuCatalogBusiService.addMenuCatalog(addMenuCatalogReqBO);
            return null;
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/selectByMenuId"})
    @BusiResponseBody
    public Object selectByMenuId(SelectDetailByMenuIdReqBO selectDetailByMenuIdReqBO) {
        return this.selectDetailByMenuIdBusiService.selectDetailByMenuId(selectDetailByMenuIdReqBO);
    }

    @RequestMapping(value={"/selectByPId"})
    @BusiResponseBody
    public Object selectByPId(SelectMenuByPIdReqBO selectMenuByPIdReqBO) {
        return this.selectMenuByPIdBusiService.selectMenuByPId(selectMenuByPIdReqBO);
    }

    @RequestMapping(value={"/addSublevelMenu"})
    @BusiResponseBody
    public Object addSublevelMenu(AddSublevelMenuReqBO addSublevelMenuReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            addSublevelMenuReqBO.setMenuId(Long.valueOf(l));
            this.addSublevelMenuBusiService.addSublevelMenu(addSublevelMenuReqBO);
            return null;
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    public Object update(UpdateByMenuIdReqBO updateByMenuIdReqBO) {
        this.updateByMenuIdBusiService.updateByMenuId(updateByMenuIdReqBO);
        return null;
    }

    @RequestMapping(value={"/changeStatus"})
    @BusiResponseBody
    public Object changeStatus(ChangeMenuStatusReqBO changeMenuStatusReqBO) {
        this.changeMenuStatusBusiService.changeMenuStatus(changeMenuStatusReqBO);
        return null;
    }

    @RequestMapping(value={"/selMenusByUser"})
    @BusiResponseBody
    public Object selectMenusByUser(SelectMenuTreeReqBO userMenusReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectAllMenuTreeBusiService.selectAllMenuTree(userMenusReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            userMenusReqBO.setRoleIdentity("auth:tenant:manage");
            return this.selectMgrMenuTreeBusiService.selectMgrMenuTree(userMenusReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            userMenusReqBO.setRoleIdentity("auth:overall:manage");
            return this.selectMgrMenuTreeBusiService.selectMgrMenuTree(userMenusReqBO);
        }
        throw new ZTBusinessException("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
    }

    @RequestMapping(value={"/selMenusToManager"})
    @BusiResponseBody
    public Object selMenusToManager(SelMenuTreeToManagerReqBO selMenuTreeToManagerReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selMenuTreeToManagerBusiService.selMenuTreeToManager(selMenuTreeToManagerReqBO);
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    public Object delete(DeleteMenuReqBO deleteMenuReqBO) {
        this.deleteMenuBusiService.deleteMenu(deleteMenuReqBO);
        return null;
    }

    @RequestMapping(value={"/up"})
    @BusiResponseBody
    public Object upOrder(ChangeMenuOrderReqBO changeMenuOrderReqBO) {
        this.changeMenuOrderUpBusiService.changeMenuOrderUp(changeMenuOrderReqBO);
        return null;
    }

    @RequestMapping(value={"/down"})
    @BusiResponseBody
    public Object downOrder(ChangeMenuOrderReqBO changeMenuOrderReqBO) {
        this.changeMenuOrderDownBusiService.changeMenuOrderDown(changeMenuOrderReqBO);
        return null;
    }
}

