/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.station;

import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.role.bo.HasUserListBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.UserBO;
import com.ohaotian.authority.station.bo.ChangeStatusByStationIdReqBO;
import com.ohaotian.authority.station.bo.DeleteByStationIdReqBO;
import com.ohaotian.authority.station.bo.RestartByStationIdReqBO;
import com.ohaotian.authority.station.bo.SaveStationReqBO;
import com.ohaotian.authority.station.bo.SelectStationAlreadyAndNorUserReqBO;
import com.ohaotian.authority.station.bo.SelectStationByIdReqBO;
import com.ohaotian.authority.station.bo.SelectStationPageReqBO;
import com.ohaotian.authority.station.bo.StationForUserAuthReqBO;
import com.ohaotian.authority.station.bo.UpdateStationByIdReqBO;
import com.ohaotian.authority.station.service.ChangeStatusByStationIdBusiService;
import com.ohaotian.authority.station.service.DeleteByStationIdBusiService;
import com.ohaotian.authority.station.service.RestartByStationIdBusiService;
import com.ohaotian.authority.station.service.SaveStationAuthorityService;
import com.ohaotian.authority.station.service.SaveStationBusiService;
import com.ohaotian.authority.station.service.SelectAllUserByStationIdService;
import com.ohaotian.authority.station.service.SelectAlreadyUserByStationIdService;
import com.ohaotian.authority.station.service.SelectStationByIdBusiService;
import com.ohaotian.authority.station.service.SelectStationsPageBusiByTowAdminService;
import com.ohaotian.authority.station.service.SelectStationsPageBusiService;
import com.ohaotian.authority.station.service.UpdateStationByIdBusiService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.ListUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/station"}, method={RequestMethod.GET, RequestMethod.POST})
public class StationController {
    private Logger logger = LoggerFactory.getLogger(StationController.class);
    @Reference(version="1.0.0", group="authority")
    private SelectStationsPageBusiService selectStationsPageBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectStationByIdBusiService selectStationByIdBusiService;
    @Reference(version="1.0.0", group="authority")
    private SaveStationBusiService saveStationBusiService;
    @Reference(version="1.0.0", group="authority")
    private UpdateStationByIdBusiService updateStationByIdBusiService;
    @Reference(version="1.0.0", group="authority")
    private ChangeStatusByStationIdBusiService changeStatusByStationIdBusiService;
    @Reference(version="1.0.0", group="authority")
    private DeleteByStationIdBusiService deleteByStationIdBusiService;
    @Reference(version="1.0.0", group="authority")
    private RestartByStationIdBusiService restartByStationIdBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectStationsPageBusiByTowAdminService selectStationsPageBusiByTowAdminService;
    @Reference(version="1.0.0", group="authority")
    private SelectAllUserByStationIdService selectAllUserByStationIdService;
    @Reference(version="1.0.0", group="authority")
    private SelectAlreadyUserByStationIdService selectAlreadyUserByStationIdService;
    @Reference(version="1.0.0", group="authority")
    private SaveStationAuthorityService saveStationAuthorityService;

    @RequestMapping(value={"/selectStationPage"})
    @BusiResponseBody
    public Object selectStationPage(SelectStationPageReqBO reqPageBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectStationsPageBusiService.selectstationPage(reqPageBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectStationsPageBusiByTowAdminService.selectStationPageByTwoAdmin(reqPageBO);
        }
        return null;
    }

    @RequestMapping(value={"/selectById"})
    @BusiResponseBody
    public Object selectById(SelectStationByIdReqBO selectStationByIdReqBO) {
        return this.selectStationByIdBusiService.selectStationById(selectStationByIdReqBO);
    }

    @RequestMapping(value={"/save"})
    @BusiResponseBody
    public Object save(SaveStationReqBO saveStationReqBO) {
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        saveStationReqBO.setStationId(Long.valueOf(l));
        this.saveStationBusiService.saveStation(saveStationReqBO);
        return null;
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    public Object update(UpdateStationByIdReqBO updateStationByIdReqBO) {
        this.updateStationByIdBusiService.updateStationById(updateStationByIdReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteByStationId"})
    @BusiResponseBody
    public Object deleteByStationId(String stationIds) {
        List longList = JSON.parseArray((String)stationIds, Long.class);
        ChangeStatusByStationIdReqBO changeStatusByStationIdReqBO = new ChangeStatusByStationIdReqBO();
        changeStatusByStationIdReqBO.setStationIds(longList);
        changeStatusByStationIdReqBO.setStatus(Integer.valueOf(1));
        this.changeStatusByStationIdBusiService.changeStatusByStationId(changeStatusByStationIdReqBO);
        return null;
    }

    @RequestMapping(value={"/phydeleteByStationId"})
    @BusiResponseBody
    public Object phydeleteByStationId(String stationIds) {
        List longList = JSON.parseArray((String)stationIds, Long.class);
        DeleteByStationIdReqBO deleteByStationIdReqBO = new DeleteByStationIdReqBO();
        deleteByStationIdReqBO.setStationIds(longList);
        this.deleteByStationIdBusiService.deleteByStationId(deleteByStationIdReqBO);
        return null;
    }

    @PostMapping(value={"/restartStation"})
    @BusiResponseBody
    public Object restartRole(RestartByStationIdReqBO restartByStationIdReqBO) {
        this.restartByStationIdBusiService.restartByStationId(restartByStationIdReqBO);
        return null;
    }

    @RequestMapping(value={"/listReOpenByStationId"})
    @BusiResponseBody
    public Object listReOpenByStationId(String stationIds) {
        List longList = JSON.parseArray((String)stationIds, Long.class);
        ChangeStatusByStationIdReqBO changeStatusByStationIdReqBO = new ChangeStatusByStationIdReqBO();
        changeStatusByStationIdReqBO.setStationIds(longList);
        changeStatusByStationIdReqBO.setStatus(Integer.valueOf(0));
        this.changeStatusByStationIdBusiService.changeStatusByStationId(changeStatusByStationIdReqBO);
        return null;
    }

    @RequestMapping(value={"/distributeUser"})
    @BusiResponseBody
    public Object distributeUser(SelectStationAlreadyAndNorUserReqBO reqBO) {
        if (reqBO.getOrgId() == null || reqBO.getStationId() == null) {
            throw new ZTBusinessException("\u673a\u6784Id\u6216\u5c97\u4f4dId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HasUserListBO allUserListBO = this.selectAllUserByStationIdService.selectAllUserByStationId(reqBO);
        List user = allUserListBO.getAllUser();
        List allUser = ListUtils.copyListProperties((List)user, UserBO.class);
        HasUserListBO alreadyuserListBO = this.selectAlreadyUserByStationIdService.selectAlreadyUser(reqBO);
        List alreadyUser = alreadyuserListBO.getAllUser();
        allUser.removeAll(alreadyUser);
        user.removeAll(allUser);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(user);
        orgDistributeRspBO.setNotGrantRoles(allUser);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/stationAuth"})
    @BusiResponseBody
    public Object savestationAuth(StationForUserAuthReqBO reqBO) {
        this.saveStationAuthorityService.saveStationConfig(reqBO);
        return null;
    }
}

