/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.user;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.manager.bo.UpdateManagerOrgReqBO;
import com.ohaotian.authority.manager.service.UpdateManagerOrgService;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesRspBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesRspBO;
import com.ohaotian.authority.role.bo.SelectUserRolesReqBO;
import com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService;
import com.ohaotian.authority.role.service.SelectUserRolesBusiService;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.AddUserReqBO;
import com.ohaotian.authority.user.bo.ChangePwdReqBO;
import com.ohaotian.authority.user.bo.DeleteUserReqBO;
import com.ohaotian.authority.user.bo.LoginNameBO;
import com.ohaotian.authority.user.bo.SaveUserRolesAuthReqBO;
import com.ohaotian.authority.user.bo.SelectSearchByUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.StoreInfoReqBO;
import com.ohaotian.authority.user.bo.UpdateUserBOReq;
import com.ohaotian.authority.user.bo.UserAuthReqBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.bo.UserParentIdOrgReqBO;
import com.ohaotian.authority.user.service.AddManageUserService;
import com.ohaotian.authority.user.service.ChangePwdByUserIdService;
import com.ohaotian.authority.user.service.DeleteUserService;
import com.ohaotian.authority.user.service.ReopenUserStatusByUserIdService;
import com.ohaotian.authority.user.service.ResetPasswordService;
import com.ohaotian.authority.user.service.SaveUserAuthService;
import com.ohaotian.authority.user.service.SelectSearchByUserInfoService;
import com.ohaotian.authority.user.service.SelectUserAlreadyAuthRolesService;
import com.ohaotian.authority.user.service.SelectUserByLoginNameService;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.authority.user.service.SelectUserNameServer;
import com.ohaotian.authority.user.service.SelectUserStaionByUserIdService;
import com.ohaotian.authority.user.service.StopUserStatusByUserIdService;
import com.ohaotian.authority.user.service.StoreUserService;
import com.ohaotian.authority.user.service.UpdateUserService;
import com.ohaotian.authority.user.service.UserParentIdOrgService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspMapInfoBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/user"}, method={RequestMethod.GET, RequestMethod.POST})
public class UserController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private SelectSearchByUserInfoService selectSearchByUserInfoService;
    @Autowired
    private SelectUserDetailService selectUserDetailService;
    @Autowired
    private UpdateUserService updateUserService;
    @Autowired
    private StopUserStatusByUserIdService stopUserStatusByUserIdService;
    @Autowired
    private ReopenUserStatusByUserIdService reopenUserStatusByUserIdService;
    @Autowired
    private ResetPasswordService resetPasswordService;
    @Autowired
    private AddManageUserService addManageUserService;
    @Autowired
    private UserParentIdOrgService userParentIdOrgService;
    @Autowired
    private SelectUserOperateRolesBusiService selectUserOperateRolesBusiService;
    @Autowired
    private SelectUserAlreadyAuthRolesService selectUserAlreadyAuthRolesService;
    @Autowired
    private SaveUserAuthService saveUserAuthService;
    @Autowired
    private SelectUserRolesBusiService selectUserRolesBusiService;
    @Autowired
    private UpdateManagerOrgService updateManagerOrgService;
    @Autowired
    private SelectUserNameServer selectUserNameServer;
    @Autowired
    private DeleteUserService deleteUserService;
    @Autowired
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @Autowired
    private SelectTenantByIdService selectTenantByIdService;
    @Autowired
    private ChangePwdByUserIdService changePwdByUserIdService;
    @Autowired
    private SelectUserByLoginNameService selectUserByLoginNameService;
    @Autowired
    private SelectUserStaionByUserIdService selectUserStaionByUserIdService;
    @Autowired
    private StoreUserService storeUserService;

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object selectSearchByUserInfoService(SelectSearchByUserInfoReqBO selectSearchByUserInfoReqBO) {
        LinkedList<String> typeList = new LinkedList<String>();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            typeList.add("auth:overall:manage");
            typeList.add("auth:tenant:manage");
            typeList.add("auth:default:manage");
            typeList.add("auth:org:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
        } else if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            typeList.add("auth:tenant:manage");
            typeList.add("auth:default:manage");
            typeList.add("auth:org:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
        } else if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            typeList.add("auth:org:manage");
            typeList.add("auth:default:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
        } else if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            typeList.add("auth:default:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
        }
        return this.selectSearchByUserInfoService.SelectSearchByUserInfoService(selectSearchByUserInfoReqBO);
    }

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object select(UserIdBO userIdBO) {
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        return selectUserInfoRspBO;
    }

    @RequestMapping(value={"/getUserInfo"})
    @BusiResponseBody
    public Object getUserInfo() {
        RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
        HashMap<String, String> resMap = new HashMap<String, String>();
        UserInfo user = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(user.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO != null) {
            resMap.put("loginName", selectUserInfoRspBO.getLoginName());
            resMap.put("name", selectUserInfoRspBO.getName());
            resMap.put("cellPhone", selectUserInfoRspBO.getCellPhone());
            resMap.put("email", selectUserInfoRspBO.getEmail());
        }
        if (user.getOrgId() != null) {
            OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
            organisationIdReqBO.setOrganisationId(user.getOrgId());
            RspOrganisationBO organisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
            if (organisationBO != null) {
                resMap.put("orgName", organisationBO.getTitle());
            }
        } else {
            resMap.put("orgName", "");
        }
        if (user.getTenantId() != null) {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(user.getTenantId());
            TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            if (tenantRspBO != null) {
                resMap.put("tenantName", tenantRspBO.getTenantName());
            }
        } else {
            resMap.put("tenantName", "");
        }
        rspMapInfoBO.setData(resMap);
        return rspMapInfoBO;
    }

    @RequestMapping(value={"/commit"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object updateUserByUserId(UpdateUserBOReq updateUserBOReq) {
        this.updateUserService.updateUserByUserId(updateUserBOReq);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u505c\u7528")
    public Object stop(UserIdBO userIdBO) {
        this.stopUserStatusByUserIdService.stopUserStatusByUserId(userIdBO);
        return null;
    }

    @RequestMapping(value={"/reopen"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u542f\u7528")
    public Object reopen(UserIdBO userIdBO) {
        this.reopenUserStatusByUserIdService.reopenUserStatusByUserId(userIdBO);
        return null;
    }

    @RequestMapping(value={"/reset"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u91cd\u7f6e\u5bc6\u7801")
    public Object reset(String userId) {
        List userIds = JSON.parseArray((String)userId, Long.class);
        this.resetPasswordService.resetPasswordByUserId(userIds);
        return null;
    }

    @RequestMapping(value={"/add/commit"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u65b0\u589e")
    public Object commit(AddUserReqBO addUserReqBO) {
        if ("auth:overall:manage".equals(addUserReqBO.getType())) {
            addUserReqBO.setOrgIdReq(null);
            addUserReqBO.setTenantIdReq(null);
        } else if ("auth:tenant:manage".equals(addUserReqBO.getType())) {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(addUserReqBO.getTenantIdReq());
            TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            if (tenantRspBO != null) {
                addUserReqBO.setmOrgId(tenantRspBO.getOrgRootId());
            }
        } else if ("auth:org:manage".equals(addUserReqBO.getType())) {
            addUserReqBO.setmOrgId(addUserReqBO.getOrgIdReq());
        }
        this.addManageUserService.insertUser(addUserReqBO);
        return null;
    }

    @RequestMapping(value={"/add/commit/select"})
    @BusiResponseBody
    public Object selectUserName(LoginNameBO loginNameBO) {
        return this.selectUserNameServer.selectUserNameByLoginName(loginNameBO);
    }

    @PostMapping(value={"/add/tree"})
    @BusiResponseBody
    public Object tree(UserParentIdOrgReqBO userParentIdOrgReqBO) {
        return this.userParentIdOrgService.selectUserParentIdOrg(userParentIdOrgReqBO);
    }

    @RequestMapping(value={"/authUser"})
    @BusiResponseBody
    public Object authUser(UserAuthReqBO userAuthReqBO) {
        SelectUserOperateRolesReqBO operateRolesReqBO = new SelectUserOperateRolesReqBO();
        operateRolesReqBO.setPrarmUserId(userAuthReqBO.getPrarmUserId());
        SelectUserOperateRolesRspBO selectUserOperateRolesRspBO = this.selectUserOperateRolesBusiService.selectUserOperateRoles(operateRolesReqBO);
        List userOperateRoles = selectUserOperateRolesRspBO.getUserOperateRoles();
        SelectOrgAlreadyRolesRspBO selectOrgAlreadyRolesRspBO = this.selectUserAlreadyAuthRolesService.selectOrgAlreadyRoles(userAuthReqBO);
        List hasGrantRoles = selectOrgAlreadyRolesRspBO.getHasGrantRoles();
        userOperateRoles.removeAll(hasGrantRoles);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasGrantRoles);
        orgDistributeRspBO.setNotGrantRoles(userOperateRoles);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/authUserCommit"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u6388\u6743")
    public Object authUserCommit(SaveUserRolesAuthReqBO saveUserRolesAuthReqBO) {
        if (StringUtils.isEmpty((Object)saveUserRolesAuthReqBO.getJson())) {
            throw new ZTBusinessException("\u8bf7\u4ece\u65b0\u9009\u62e9");
        }
        if (saveUserRolesAuthReqBO.getUserId() == null) {
            throw new ZTBusinessException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.saveUserAuthService.saveUserAuthService(saveUserRolesAuthReqBO);
        return null;
    }

    @RequestMapping(value={"/selectUserRoles"})
    @BusiResponseBody
    public Object selectUserRoles(SelectUserRolesReqBO userRolesReqBO) {
        return this.selectUserRolesBusiService.selectUserRoles(userRolesReqBO);
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    public Object updateManagerService(UpdateManagerOrgReqBO updateManagerOrgReqBO) {
        this.updateManagerOrgService.updateManager(updateManagerOrgReqBO);
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteUser(DeleteUserReqBO deleteUserReqBO) {
        try {
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(deleteUserReqBO.getUserId());
            SelectUserInfoRspBO rspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664", (Throwable)e);
        }
        this.deleteUserService.deleteUserByUserId(deleteUserReqBO);
        return null;
    }

    @RequestMapping(value={"/changeUserPwd"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u4fee\u6539\u5bc6\u7801")
    public Object changeUserPwd(ChangePwdReqBO changePwdReqBO) {
        this.changePwdByUserIdService.changePasswordByUserId(changePwdReqBO);
        return null;
    }

    @RequestMapping(value={"/checkLoginName"})
    @BusiResponseBody
    public Object checkLoginName(@RequestParam String username, @RequestParam String password) {
        return this.selectUserByLoginNameService.selectUserByLoginNameService(username, password);
    }

    @RequestMapping(value={"/deviceCheckLoginName"})
    @BusiResponseBody
    public Object deviceCheckLoginName(@RequestParam String username, @RequestParam String password) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)username) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)password)) {
            return null;
        }
        SelectUserByLoginNameRspBO loginNameRspBO = this.selectUserByLoginNameService.selectUserByLoginNameService(username, password);
        if (null == loginNameRspBO || null == loginNameRspBO.getUserId()) {
            logger.debug("\u7528\u6237\u540d\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25");
            return null;
        }
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(loginNameRspBO.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        logger.debug("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)selectUserInfoRspBO);
        return selectUserInfoRspBO;
    }

    @RequestMapping(value={"/selectUserStation"})
    @BusiResponseBody
    public Object selectUserStation(UserIdBO userId) {
        return this.selectUserStaionByUserIdService.selectUserStation(userId);
    }

    @RequestMapping(value={"/selectUserInfo"})
    @BusiResponseBody
    public Object selectUserInfo() {
        UserInfo user = SecurityHelper.getCurrentUser();
        StoreInfoReqBO storeInfoReqBO = new StoreInfoReqBO();
        storeInfoReqBO.setUserId(user.getUserId());
        return this.storeUserService.qryStoreInfoByUserId(storeInfoReqBO);
    }
}

