/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.external;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.authority.external.bo.ExportCommAuthorityBO;
import com.ohaotian.authority.external.bo.ExportDefinedAuthorityBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/expComm"}, method={RequestMethod.GET, RequestMethod.POST})
public class ExportCommController {
    private static final Logger logger = LoggerFactory.getLogger(ExportCommController.class);
    @Autowired
    private SelectUserDetailService selectUserDetailService;

    @RequestMapping(value={"/expExcel"})
    @BusiResponseBody
    public Object expExcel(ExportCommAuthorityBO reqBO) {
        JSONObject resultData;
        logger.debug("exportEx\u8fdb\u5165\u5bfc\u51facontroller------------------------");
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        logger.debug("exportEx\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u51fa\u53c2------------------------" + selectUserInfoRspBO.toString());
        if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getProvinceCode())) {
            reqBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
        }
        if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getCityCode())) {
            reqBO.setmCity(selectUserInfoRspBO.getCityCode());
        }
        if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getDistrictCode())) {
            reqBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
        }
        if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getField2())) {
            reqBO.setmShopId(selectUserInfoRspBO.getField2());
        }
        reqBO.setmOrgId(selectUserInfoRspBO.getmOrgId().toString());
        reqBO.setmUserLevel(selectUserInfoRspBO.getUserLevel());
        logger.debug("exportEx\u6cdb\u5316\u8c03\u7528\u5165\u53c2------------------------" + reqBO.toString());
        JSONObject json = (JSONObject)JSON.toJSON((Object)reqBO);
        try {
            InvokeInfo invokeInfo = new InvokeInfo("com.tydic.newretail.report.ability.ExportCommAbilityService", "exportComm", "com.tydic.newretail.report.ability.bo.ExportCommAbilityReqBO");
            invokeInfo.setRegisterType("2");
            logger.debug("exportEx\u51c6\u5907\u6cdb\u5316\u8c03\u7528------------------------");
            resultData = TKGenericServiceUtils.genericServiceInvoke((String)json.toJSONString(), null, (InvokeInfo)invokeInfo);
            logger.debug("exportEx\u6cdb\u5316\u8c03\u7528\u51fa\u53c2------------------------" + resultData.toString());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8868\u5934\u5931\u8d25\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u67e5\u8be2\u8868\u5934\u5931\u8d25\uff01");
        }
        return resultData;
    }

    @RequestMapping(value={"/qryExp"})
    @BusiResponseBody
    public Object qryExp(ExportDefinedAuthorityBO reqBO) {
        JSONObject resultData;
        logger.debug("qryExport\u8fdb\u5165\u67e5\u8be2\u8868\u5934controller\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        try {
            InvokeInfo invokeInfo = new InvokeInfo("com.tydic.newretail.report.ability.ExportCommAbilityService", "qryExportParams", "com.tydic.newretail.report.ability.bo.ExportDefinedBO");
            invokeInfo.setRegisterType("2");
            logger.debug("qryExport\u51c6\u5907\u6cdb\u5316\u8c03\u7528------------------------");
            resultData = TKGenericServiceUtils.genericServiceInvoke((String)JSON.toJSONString((Object)reqBO), null, (InvokeInfo)invokeInfo);
            logger.debug("qryExport\u6cdb\u5316\u8c03\u7528\u51fa\u53c2------------------------" + resultData.toString());
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5931\u8d25qryExportParams\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u5bfc\u51fa\u5931\u8d25qryExportParams\uff01");
        }
        return resultData;
    }
}

