/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.organisation;

import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.organisation.bo.OrgSearchPageReqBO;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.POrdIdBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.bo.SelectAreaStoreTreeReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgTreeReqBO;
import com.ohaotian.authority.organisation.bo.SelectTreePathByOrgId;
import com.ohaotian.authority.organisation.bo.TenanNameRspBO;
import com.ohaotian.authority.organisation.bo.TenantNameListRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBOS;
import com.ohaotian.authority.organisation.service.CreateOrganisationService;
import com.ohaotian.authority.organisation.service.DeleteOrganizationServer;
import com.ohaotian.authority.organisation.service.OrgSearchService;
import com.ohaotian.authority.organisation.service.ReopenOrganisationByOrgId;
import com.ohaotian.authority.organisation.service.SelectAllOrgTreePathService;
import com.ohaotian.authority.organisation.service.SelectAreaStoreTreeService;
import com.ohaotian.authority.organisation.service.SelectOrgRootTreePathService;
import com.ohaotian.authority.organisation.service.SelectOrgTreePathService;
import com.ohaotian.authority.organisation.service.SelectOrgTreeService;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.organisation.service.SelectTenantNameService;
import com.ohaotian.authority.organisation.service.SelectTreePathByOrgIdService;
import com.ohaotian.authority.organisation.service.StopOrganisationByOrgId;
import com.ohaotian.authority.organisation.service.UpdateOrganisationService;
import com.ohaotian.authority.role.bo.SaveOrgGrantRolesReqBO;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesReqBO;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesRspBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeReqBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesRspBO;
import com.ohaotian.authority.role.service.SaveOrgGrantRolesBusiService;
import com.ohaotian.authority.role.service.SelectOrgAlreadyRolesBusiService;
import com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService;
import com.ohaotian.authority.tenant.bo.SelectUserTenantReqBO;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.tenant.service.SelectUserTenantService;
import com.ohaotian.authority.user.bo.SelectUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/org"}, method={RequestMethod.GET, RequestMethod.POST})
public class OrgController {
    private static final Logger logger = LoggerFactory.getLogger(OrgController.class);
    @Autowired
    private CreateOrganisationService createOrganisationService;
    @Autowired
    private UpdateOrganisationService updateOrganisationService;
    @Autowired
    private StopOrganisationByOrgId stopOrganisationByOrgId;
    @Autowired
    private ReopenOrganisationByOrgId reopenOrganisationByOrgId;
    @Autowired
    private OrgSearchService orgSearchService;
    @Autowired
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @Autowired
    private SelectUserOperateRolesBusiService selectUserOperateRolesBusiService;
    @Autowired
    private SelectOrgAlreadyRolesBusiService selectOrgAlreadyRolesBusiService;
    @Autowired
    private SaveOrgGrantRolesBusiService saveOrgGrantRolesBusiService;
    @Autowired
    private SelectOrgTreePathService selectOrgTreePathService;
    @Autowired
    private SelectOrgRootTreePathService selectOrgRootTreePathService;
    @Autowired
    private SelectTreePathByOrgIdService selectTreePathByOrgIdService;
    @Autowired
    private DeleteOrganizationServer deleteOrganizationServer;
    @Autowired
    private SelectTenantNameService selectTenantNameService;
    @Autowired
    private SelectTenantByIdService selectTenantByIdService;
    @Autowired
    private SelectUserTenantService selectUserTenantService;
    @Autowired
    private SelectAllOrgTreePathService selectAllOrgTreePathService;
    @Autowired
    private SelectUserInfoService selectUserInfoService;
    @Autowired
    private SelectAreaStoreTreeService selectAreaStoreTreeService;
    @Autowired
    private SelectOrgTreeService selectOrgTreeService;
    @Autowired
    private SelectUserDetailService selectUserDetailService;

    @RequestMapping(value={"/selectLoginUser"})
    @BusiResponseBody
    public Object selectLoginUser() {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        return selectUserInfoRspBO;
    }

    @RequestMapping(value={"/add"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u65b0\u589e")
    public Object add(OrganisationBO organisationBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO.getUserId() != null && !selectUserInfoRspBO.getUserId().equals("")) {
            organisationBO.setCreatUserId(selectUserInfoRspBO.getUserId());
        }
        this.createOrganisationService.createOrganisation(organisationBO);
        return null;
    }

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object select(OrganisationIdReqBO organisationBO) {
        RspOrganisationBO rspOrganisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationBO);
        return rspOrganisationBO;
    }

    @RequestMapping(value={"/selectTenant"})
    @BusiResponseBody
    public Object selectTenant() {
        logger.info("selectTenant begin");
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            logger.info("selectTenant SYSTEM_ADMIN_CODE:OVERALL_ADMIN_CODE");
            return this.selectTenantNameService.selectTenanNameService();
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            logger.info("selectTenant TENANT_ADMIN_CODE");
            UserInfo currentUser = SecurityHelper.getCurrentUser();
            if (null == currentUser) {
                return null;
            }
            logger.info("TENANT_ADMIN_CODE:currentUser.getUserId()=" + currentUser.getUserId());
            SelectUserInfoReqBO selectUserInfoReqBO = new SelectUserInfoReqBO();
            selectUserInfoReqBO.setUserId(currentUser.getUserId());
            SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserInfoService.selectUserInfo(selectUserInfoReqBO);
            if (null == selectUserInfoRspBO) {
                return null;
            }
            logger.info("TENANT_ADMIN_CODE:selectUserInfoRspBO.getTenantId()=" + selectUserInfoRspBO.getTenantId());
            SelectUserTenantReqBO selectUserTenantReqBO = new SelectUserTenantReqBO();
            selectUserTenantReqBO.setTenantId(selectUserInfoRspBO.getTenantId());
            TenantRspBO tenantRspBO = this.selectUserTenantService.selectUserTenant(selectUserTenantReqBO);
            logger.info("TENANT_ADMIN_CODE:tenantRspBO=" + tenantRspBO);
            if (tenantRspBO != null) {
                logger.info("TENANT_ADMIN_CODE:tenantRspBO.getTenantName()=" + tenantRspBO.getTenantName());
                TenantNameListRspBO rspBO = new TenantNameListRspBO();
                LinkedList<TenanNameRspBO> list = new LinkedList<TenanNameRspBO>();
                TenanNameRspBO tenanNameRspBO = new TenanNameRspBO();
                tenanNameRspBO.setTenantId(tenantRspBO.getTenantId());
                tenanNameRspBO.setTenantName(tenantRspBO.getTenantName());
                tenanNameRspBO.setOrgRootId(tenantRspBO.getOrgRootId());
                list.add(tenanNameRspBO);
                rspBO.setTenanNameRspBOList(list);
                return rspBO;
            }
            return null;
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            logger.info("selectTenant ORG_ADMIN_CODE");
            UserInfo currentUser = SecurityHelper.getCurrentUser();
            if (null == currentUser) {
                return null;
            }
            SelectUserInfoReqBO selectUserInfoReqBO = new SelectUserInfoReqBO();
            selectUserInfoReqBO.setUserId(currentUser.getUserId());
            SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserInfoService.selectUserInfo(selectUserInfoReqBO);
            if (null == selectUserInfoRspBO) {
                return null;
            }
            SelectUserTenantReqBO selectUserTenantReqBO = new SelectUserTenantReqBO();
            selectUserTenantReqBO.setTenantId(selectUserInfoRspBO.getTenantId());
            TenantRspBO tenantRspBO = this.selectUserTenantService.selectUserTenant(selectUserTenantReqBO);
            if (null == tenantRspBO) {
                return null;
            }
            TenantNameListRspBO rspBO = new TenantNameListRspBO();
            LinkedList<TenanNameRspBO> list = new LinkedList<TenanNameRspBO>();
            TenanNameRspBO tenanNameRspBO = new TenanNameRspBO();
            tenanNameRspBO.setTenantId(selectUserInfoRspBO.getTenantId());
            tenanNameRspBO.setOrgRootId(selectUserInfoRspBO.getOrgId());
            tenanNameRspBO.setTenantName(tenantRspBO.getTenantName());
            list.add(tenanNameRspBO);
            rspBO.setTenanNameRspBOList(list);
            return rspBO;
        }
        logger.info("selectTenant authIdentity null");
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteOrg(OrganisationIdReqBO organisationBO) {
        try {
            OrganisationIdReqBO reqBO = new OrganisationIdReqBO();
            reqBO.setOrganisationId(organisationBO.getOrganisationId());
            RspOrganisationBO rspBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u673a\u6784", (Throwable)e);
        }
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO.getUserId() != null && !selectUserInfoRspBO.getUserId().equals("")) {
            organisationBO.setUpdateUserId(selectUserInfoRspBO.getUserId());
        }
        this.deleteOrganizationServer.deleteOrganization(organisationBO);
        return null;
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object update(OrganisationBO organisationBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO.getUserId() != null && !selectUserInfoRspBO.getUserId().equals("")) {
            organisationBO.setUpdateUserId(selectUserInfoRspBO.getUserId());
        }
        try {
            OrganisationIdReqBO reqBO = new OrganisationIdReqBO();
            reqBO.setOrganisationId(organisationBO.getOrganisationId());
            RspOrganisationBO rspBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u673a\u6784", (Throwable)e);
        }
        this.updateOrganisationService.updateOrganisation(organisationBO);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u505c\u7528")
    public Object stop(OrganisationIdReqBO organisationBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO.getUserId() != null && !selectUserInfoRspBO.getUserId().equals("")) {
            organisationBO.setUpdateUserId(selectUserInfoRspBO.getUserId());
        }
        this.stopOrganisationByOrgId.stopOrganisationByOrgId(organisationBO);
        return null;
    }

    @RequestMapping(value={"/reopen"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u542f\u7528")
    public Object reopen(OrganisationIdReqBO organisationBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO.getUserId() != null && !selectUserInfoRspBO.getUserId().equals("")) {
            organisationBO.setUpdateUserId(selectUserInfoRspBO.getUserId());
        }
        this.reopenOrganisationByOrgId.reopenOrganisationByOrgId(organisationBO);
        return null;
    }

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object orgSearch(OrgSearchPageReqBO orgSearchPageReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO != null) {
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getProvinceCode())) {
                orgSearchPageReqBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
            }
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getCityCode())) {
                orgSearchPageReqBO.setmCity(selectUserInfoRspBO.getCityCode());
            }
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getDistrictCode())) {
                orgSearchPageReqBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
            }
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getField2())) {
                orgSearchPageReqBO.setmShopId(selectUserInfoRspBO.getField2());
            }
            orgSearchPageReqBO.setmOrgId(selectUserInfoRspBO.getmOrgId().toString());
            orgSearchPageReqBO.setmUserLevel(selectUserInfoRspBO.getUserLevel());
            return this.orgSearchService.selectSearchOrg(orgSearchPageReqBO);
        }
        throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
    }

    @RequestMapping(value={"/rootPath"})
    @BusiResponseBody
    public Object getRootPath(@RequestParam(required=false) Long tenantId) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            if (tenantId != null && tenantId != 0L) {
                TenantIdBO tenantIdBO = new TenantIdBO();
                tenantIdBO.setTenantId(tenantId);
                TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
                return this.selectOrgRootTreePathService.selectOrgTreePath(tenantRspBO.getOrgRootId());
            }
            POrdIdBO pOrdIdBO = new POrdIdBO();
            pOrdIdBO.setParentId(Long.valueOf(1L));
            return this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        }
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        if (currentUser == null) {
            return null;
        }
        SelectUserInfoReqBO reqBO = new SelectUserInfoReqBO();
        reqBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO userInfoRspBO = this.selectUserInfoService.selectUserInfo(reqBO);
        if (null == userInfoRspBO || null == userInfoRspBO.getmOrgId()) {
            return null;
        }
        return this.selectOrgRootTreePathService.selectOrgTreePath(userInfoRspBO.getmOrgId());
    }

    @RequestMapping(value={"/getOrgByParentId"})
    @BusiResponseBody
    public Object getTreePath(POrdIdBO pOrdIdBO) {
        return this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
    }

    @RequestMapping(value={"/getAllOrgByParentId"})
    @BusiResponseBody
    public Object getAllTreePath(POrdIdBO pOrdIdBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO != null) {
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getProvinceCode())) {
                pOrdIdBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
            }
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getCityCode())) {
                pOrdIdBO.setmCity(selectUserInfoRspBO.getCityCode());
            }
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getDistrictCode())) {
                pOrdIdBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
            }
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getField2())) {
                pOrdIdBO.setmShopId(selectUserInfoRspBO.getField2());
            }
            pOrdIdBO.setmTenantId(selectUserInfoRspBO.getTenantId());
            pOrdIdBO.setmOrgId(selectUserInfoRspBO.getmOrgId().toString());
            pOrdIdBO.setmUserLevel(selectUserInfoRspBO.getUserLevel());
            return this.selectAllOrgTreePathService.selectAllOrgTreePath(pOrdIdBO);
        }
        throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
    }

    @RequestMapping(value={"/qryParent"})
    @BusiResponseBody
    public Object qryParent(SelectTreePathByOrgId selectTreePathByOrgId) {
        return this.selectTreePathByOrgIdService.selectTreePathByOrgIdService(selectTreePathByOrgId);
    }

    @RequestMapping(value={"/alreadyAndNorRoles"})
    @BusiResponseBody
    public Object alreadyAndNorRoles(SelectOrgDistributeReqBO orgDistributeReqBO) {
        SelectUserOperateRolesReqBO map = (SelectUserOperateRolesReqBO)BeanMapper.map((Object)orgDistributeReqBO, SelectUserOperateRolesReqBO.class);
        SelectUserOperateRolesRspBO userOperateRolesRspBO = this.selectUserOperateRolesBusiService.selectUserOperateRoles(map);
        List userOperateRoles = userOperateRolesRspBO.getUserOperateRoles();
        SelectOrgAlreadyRolesReqBO orgAlreadyRolesReqBO = new SelectOrgAlreadyRolesReqBO();
        orgAlreadyRolesReqBO.setOrgTreePath(orgDistributeReqBO.getOrgTreePath());
        SelectOrgAlreadyRolesRspBO selectOrgAlreadyRolesRspBO = this.selectOrgAlreadyRolesBusiService.selectOrgAlreadyRoles(orgAlreadyRolesReqBO);
        List hasGrantRoles = selectOrgAlreadyRolesRspBO.getHasGrantRoles();
        userOperateRoles.removeAll(hasGrantRoles);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasGrantRoles);
        orgDistributeRspBO.setNotGrantRoles(userOperateRoles);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/grantToOrg"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u673a\u6784\u5206\u914d\u89d2\u8272")
    public Object grantToOrg(SaveOrgGrantRolesReqBO saveOrgGrantRolesReqBO) {
        this.saveOrgGrantRolesBusiService.saveOrgGrantRoles(saveOrgGrantRolesReqBO);
        return null;
    }

    @RequestMapping(value={"/tenantRootOrg"})
    @BusiResponseBody
    public Object tenantRootOrg(TenantIdBO tenantIdBO) {
        TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
        OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
        organisationIdReqBO.setOrganisationId(tenantRspBO.getOrgRootId());
        RspOrganisationBO rspOrganisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
        TreePathRspBOS treePathRspBOS = new TreePathRspBOS();
        LinkedList<TreePathRspBO> treePathRspBOList = new LinkedList<TreePathRspBO>();
        TreePathRspBO treePathRspBO = (TreePathRspBO)BeanMapper.map((Object)rspOrganisationBO, TreePathRspBO.class);
        POrdIdBO pOrdIdBO = new POrdIdBO();
        pOrdIdBO.setParentId(tenantRspBO.getOrgRootId());
        TreePathRspBOS treePathRspBOS1 = this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        if (treePathRspBOS1.getTreePathRspBOList() != null && treePathRspBOS1.getTreePathRspBOList().size() > 0) {
            treePathRspBO.setIsParent(Integer.valueOf(0));
        } else {
            treePathRspBO.setIsParent(Integer.valueOf(1));
        }
        treePathRspBOList.add(treePathRspBO);
        treePathRspBOS.setTreePathRspBOList(treePathRspBOList);
        return treePathRspBOS;
    }

    @RequestMapping(value={"/selectAreaStoreTree"})
    @BusiResponseBody
    public Object selectAreaStoreTree(SelectAreaStoreTreeReqBO selectAreaStoreTreeReqBO) {
        return this.selectAreaStoreTreeService.selectAreaStoreTree(selectAreaStoreTreeReqBO);
    }

    @RequestMapping(value={"/selectOrgTree"})
    @BusiResponseBody
    public Object selectOrgTreeService(SelectOrgTreeReqBO selectOrgTreeReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        selectOrgTreeReqBO.setUserLevel(selectUserInfoRspBO.getUserLevel());
        selectOrgTreeReqBO.setTenantId(selectUserInfoRspBO.getTenantId());
        selectOrgTreeReqBO.setOrgId(selectUserInfoRspBO.getOrgId());
        if (selectOrgTreeReqBO.getProvinceCode() == null || "".equals(selectOrgTreeReqBO.getProvinceCode())) {
            selectOrgTreeReqBO.setProvinceCode(selectUserInfoRspBO.getProvinceCode());
        }
        if (selectOrgTreeReqBO.getCityCode() == null || "".equals(selectOrgTreeReqBO.getCityCode())) {
            selectOrgTreeReqBO.setCityCode(selectUserInfoRspBO.getCityCode());
        }
        if (selectOrgTreeReqBO.getDistrictCode() == null || "".equals(selectOrgTreeReqBO.getDistrictCode())) {
            selectOrgTreeReqBO.setDistrictCode(selectUserInfoRspBO.getDistrictCode());
        }
        return this.selectOrgTreeService.selectOrgTree(selectOrgTreeReqBO);
    }
}

