/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.salesman;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.salesman.bo.SalesmanByIdReqBO;
import com.ohaotian.authority.salesman.bo.SalesmanByIdRspBO;
import com.ohaotian.authority.salesman.bo.SalesmanReqBO;
import com.ohaotian.authority.salesman.bo.SearchSalesmanByConditionReqBO;
import com.ohaotian.authority.salesman.bo.SelectSalasmanInfoByUserinfoReqBO;
import com.ohaotian.authority.salesman.service.AddSalesmanService;
import com.ohaotian.authority.salesman.service.DeleteSalesmanService;
import com.ohaotian.authority.salesman.service.ReopenSalesmanService;
import com.ohaotian.authority.salesman.service.SelectAllService;
import com.ohaotian.authority.salesman.service.SelectSalesmanInfoByUserInfoService;
import com.ohaotian.authority.salesman.service.SelectSearchBySalesmanInfoService;
import com.ohaotian.authority.salesman.service.StopSalesmanService;
import com.ohaotian.authority.salesman.service.UpdateSalesmanService;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/salesman"}, method={RequestMethod.GET, RequestMethod.POST})
public class SalesmanController {
    private static final Logger logger = LoggerFactory.getLogger(SalesmanController.class);
    private String rspDesc = "SUCCESS";
    private String addCode = "1";
    private String updateCode = "2";
    private String deleteCode = "3";
    @Autowired
    private AddSalesmanService addSalesmanService;
    @Autowired
    private DeleteSalesmanService deleteSalesmanService;
    @Autowired
    private ReopenSalesmanService reopenSalesmanService;
    @Autowired
    private SelectSearchBySalesmanInfoService selectSearchBySalesmanInfoService;
    @Autowired
    private StopSalesmanService stopSalesmanService;
    @Autowired
    private UpdateSalesmanService updateSalesmanService;
    @Autowired
    private SelectSalesmanInfoByUserInfoService selectSalesmanInfoByUserInfoService;
    @Autowired
    private SelectAllService selectAllService;
    @Autowired
    private SelectUserDetailService selectUserDetailService;

    @RequestMapping(value={"/selectAll"})
    @BusiResponseBody
    public Object selectAll(SearchSalesmanByConditionReqBO searchSalesmanByConditionReqBO) {
        if (searchSalesmanByConditionReqBO.getBelongOrgId() == null || "".equals(searchSalesmanByConditionReqBO.getBelongOrgId())) {
            UserInfo currentUser = SecurityHelper.getCurrentUser();
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(currentUser.getUserId());
            SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        }
        return this.selectAllService.selectAll(searchSalesmanByConditionReqBO);
    }

    @RequestMapping(value={"/selectSalesmanInfoByUserInfo"})
    @BusiResponseBody
    public Object selectSalesmanInfoByUserInfo(SelectSalasmanInfoByUserinfoReqBO selectSalasmanInfoByUserinfoReqBO) {
        return this.selectSalesmanInfoByUserInfoService.selectSalesmanInfoByUserInfo(selectSalasmanInfoByUserinfoReqBO);
    }

    @RequestMapping(value={"/selectSalesmanByCondition"})
    @BusiResponseBody
    public Object selectSalesmanByCondition(SearchSalesmanByConditionReqBO searchSalesmanByConditionReqBO) {
        logger.info("\u6761\u4ef6\u67e5\u8be2\u4e1a\u52a1\u5458controller\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)searchSalesmanByConditionReqBO));
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        searchSalesmanByConditionReqBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
        searchSalesmanByConditionReqBO.setmCity(selectUserInfoRspBO.getCityCode());
        searchSalesmanByConditionReqBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
        searchSalesmanByConditionReqBO.setmShopId(selectUserInfoRspBO.getField2());
        if (null != selectUserInfoRspBO.getmOrgId()) {
            searchSalesmanByConditionReqBO.setmOrgId(selectUserInfoRspBO.getmOrgId().toString());
        }
        searchSalesmanByConditionReqBO.setmUserLevel(selectUserInfoRspBO.getUserLevel());
        return this.selectSearchBySalesmanInfoService.searchByContidion(searchSalesmanByConditionReqBO);
    }

    @RequestMapping(value={"/selectSalesmanById"})
    @BusiResponseBody
    public Object selectSalesmanById(SalesmanByIdReqBO salesmanByIdReqBO) {
        return this.selectSearchBySalesmanInfoService.searchById(salesmanByIdReqBO);
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u4e1a\u52a1\u5458\u7ba1\u7406", operat="\u505c\u7528")
    public Object stopSalesman(SalesmanByIdReqBO salesmanByIdReqBO) {
        return this.stopSalesmanService.stopSalesman(salesmanByIdReqBO);
    }

    @RequestMapping(value={"/reopen"})
    @BusiResponseBody
    @BussinessLog(module="\u4e1a\u52a1\u5458\u7ba1\u7406", operat="\u542f\u7528")
    public Object reopenSalesman(SalesmanByIdReqBO salesmanByIdReqBO) {
        return this.reopenSalesmanService.reopenSalesman(salesmanByIdReqBO);
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u4e1a\u52a1\u5458\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteSalesman(SalesmanByIdReqBO salesmanByIdReqBO) {
        SalesmanByIdRspBO salesmanByIdRspBO = this.deleteSalesmanService.deleteSalesman(salesmanByIdReqBO);
        return salesmanByIdRspBO;
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u4e1a\u52a1\u5458\u7ba1\u7406", operat="\u66f4\u65b0")
    public Object updateSalesman(SalesmanReqBO salesmanReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        salesmanReqBO.setmUserId(selectUserInfoRspBO.getUserId());
        salesmanReqBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
        salesmanReqBO.setmCity(selectUserInfoRspBO.getCityCode());
        salesmanReqBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
        salesmanReqBO.setmShopId(selectUserInfoRspBO.getField2());
        if (null != selectUserInfoRspBO.getmOrgId()) {
            salesmanReqBO.setmOrgId(selectUserInfoRspBO.getmOrgId().toString());
        }
        SalesmanByIdRspBO salesmanByIdRspBO = this.updateSalesmanService.updateSalesman(salesmanReqBO);
        return salesmanByIdRspBO;
    }

    @RequestMapping(value={"/add"})
    @BusiResponseBody
    @BussinessLog(module="\u4e1a\u52a1\u5458\u7ba1\u7406", operat="\u65b0\u589e")
    public Object addSalesman(SalesmanReqBO salesmanReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        salesmanReqBO.setmUserId(selectUserInfoRspBO.getUserId());
        salesmanReqBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
        salesmanReqBO.setmCity(selectUserInfoRspBO.getCityCode());
        salesmanReqBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
        salesmanReqBO.setmShopId(selectUserInfoRspBO.getField2());
        if (null != selectUserInfoRspBO.getmOrgId()) {
            salesmanReqBO.setmOrgId(selectUserInfoRspBO.getmOrgId().toString());
        }
        salesmanReqBO.setmUserLevel(selectUserInfoRspBO.getUserLevel());
        SalesmanByIdRspBO salesmanByIdRspBO = this.addSalesmanService.addSalesman(salesmanReqBO);
        return salesmanByIdRspBO;
    }
}

