/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.utils;

import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
public class AuthorityPropertiesUtils
implements ApplicationListener<ContextRefreshedEvent> {
    private static TreeMap treeMap = new TreeMap();
    private static Properties propertiesFileLoader;

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (contextRefreshedEvent.getApplicationContext().getParent() == null) {
            AuthorityPropertiesUtils.init();
        }
    }

    public static void init() {
        propertiesFileLoader.entrySet().stream().forEach(e -> treeMap.put(e.getKey(), e.getValue()));
    }

    public static String getProperty(String key) {
        if (!treeMap.containsKey(key)) {
            AuthorityPropertiesUtils.init();
        }
        return null == treeMap.get(key) ? null : String.valueOf(treeMap.get(key)).trim();
    }

    public static String getProperty(String key, String defaultValue) {
        String value;
        if (!treeMap.containsKey(key)) {
            AuthorityPropertiesUtils.init();
        }
        return StringUtils.isBlank((CharSequence)(value = AuthorityPropertiesUtils.getProperty(key))) ? defaultValue : value;
    }

    public static Long getLongProperty(String key) {
        String value = AuthorityPropertiesUtils.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    public static Long getLongProperty(String key, Long defaultValue) {
        Long value = AuthorityPropertiesUtils.getLongProperty(key);
        return null == value ? defaultValue : value;
    }

    public static Integer getIntProperty(String key) {
        String value = AuthorityPropertiesUtils.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public static Integer getIntProperty(String key, Integer defaultValue) {
        Integer value = AuthorityPropertiesUtils.getIntProperty(key);
        return null == value ? defaultValue : value;
    }

    public static Boolean getBooleanProperty(String key) {
        String value = AuthorityPropertiesUtils.getProperty(key);
        return StringUtils.isBlank((CharSequence)value) ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public static Boolean getBooleanProperty(String key, Boolean defaultValue) {
        Boolean value = AuthorityPropertiesUtils.getBooleanProperty(key);
        return null == value ? defaultValue : value;
    }

    @Autowired
    public void setProps(Properties propertiesFileLoader) {
        AuthorityPropertiesUtils.propertiesFileLoader = propertiesFileLoader;
    }
}

