/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.user;

import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.ChangePwdWebReqBO;
import com.ohaotian.authority.user.service.ChangePwdByUserIdWebService;
import com.ohaotian.authority.util.SaltUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DigestUtils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP_DEV/1.0.0/com.ohaotian.authority.user.service.ChangePwdByUserIdWebService"})
public class ChangePwdByUserIdWebServiceImpl
implements ChangePwdByUserIdWebService {
    private static final Logger log = LoggerFactory.getLogger(ChangePwdByUserIdWebServiceImpl.class);
    @Autowired
    UserMapper userMapper;

    @Transactional
    @PostMapping(value={"changePasswordByUserId"})
    public void changePasswordByUserId(@RequestBody ChangePwdWebReqBO webReqBO) {
        Long userId = webReqBO.getUserIdReq();
        if (userId == null) {
            userId = webReqBO.getUserId();
        }
        String newEncrypt = DigestUtils.Encrypt((String)webReqBO.getPasswordReq(), (String)"");
        UserPO userPO = this.userMapper.selectUserInfo(userId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userPO.getInitialPassword()}) && userPO.getInitialPassword().equals(webReqBO.getPasswordReq())) {
            throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c");
        }
        String salt = userPO.getSalt();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{salt})) {
            String tempPwd = DigestUtils.Encrypt((String)(newEncrypt + salt), (String)"");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userPO.getPassword()}) && userPO.getPassword().equals(tempPwd)) {
                throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c");
            }
        }
        String newSalt = SaltUtils.getSerialNo(8);
        String newPwd = DigestUtils.Encrypt((String)(newEncrypt + newSalt), (String)"");
        UserPO newUser = new UserPO();
        newUser.setUserId(userId);
        newUser.setSalt(newSalt);
        newUser.setPassword(newPwd);
        Date now = new Date();
        newUser.setEffDate(now);
        this.userMapper.updateByPrimaryKeySelective(newUser);
    }
}

