/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.menu;

import com.ohaotian.authority.dao.OrgMenuMapper;
import com.ohaotian.authority.dao.OrgRoleMenuMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.menu.bo.SaveMenusByOrgTreePathReqBO;
import com.ohaotian.authority.menu.service.SaveMenusByOrgTreePathBusiService;
import com.ohaotian.authority.po.OrgMenuPO;
import com.ohaotian.authority.po.OrgRoleMenuPO;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP_DEV/1.0.0/com.ohaotian.authority.menu.service.SaveMenusByOrgTreePathBusiService"})
public class SaveMenusByOrgTreePathBusiServiceImpl
implements SaveMenusByOrgTreePathBusiService {
    private static final Logger log = LoggerFactory.getLogger(SaveMenusByOrgTreePathBusiServiceImpl.class);
    @Autowired
    private OrgMenuMapper orgMenuMapper;
    @Autowired
    private OrgRoleMenuMapper orgRoleMenuMapper;
    @Autowired
    private RoleMapper roleMapper;

    @PostMapping(value={"save"})
    public void save(@RequestBody SaveMenusByOrgTreePathReqBO reqBO) {
        String orgTreePath = reqBO.getOrgTreePath();
        String configDetail = reqBO.getConfigDetail();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.roleConfig(configDetail);
        Set<Long> adds = stringSetMap.get("add");
        Set<Long> deletes = stringSetMap.get("delete");
        for (Long add : adds) {
            OrgMenuPO orgMenuPO = this.orgMenuMapper.selectInfoByOrgTreePathAndMenu(orgTreePath, add);
            if (orgMenuPO != null) continue;
            OrgMenuPO record = new OrgMenuPO();
            record.setMenuId(add);
            record.setOrgTreePath(orgTreePath);
            this.orgMenuMapper.insert(record);
        }
        for (Long delete : deletes) {
            List<OrgRoleMenuPO> orgRoleMenuPOS;
            this.orgMenuMapper.deleteByOrgTreePathAndMenu(orgTreePath, delete);
            OrgRoleMenuPO orgRoleMenuPO = this.orgRoleMenuMapper.selectByOrgTreePathAndMenuId(orgTreePath, delete);
            if (orgRoleMenuPO != null) {
                this.roleMapper.deleteByAuthIdAndMenuId(orgTreePath, delete);
                this.orgRoleMenuMapper.deleteByAuthId(orgRoleMenuPO.getAuthId());
            }
            if ((orgRoleMenuPOS = this.orgRoleMenuMapper.selectLikeByOrgTreePathAndMenuId(orgTreePath, delete)) == null || orgRoleMenuPOS.size() <= 0) continue;
            this.roleMapper.deleteLikeByAuthIdAndMenuId(orgTreePath, delete);
            for (OrgRoleMenuPO PO : orgRoleMenuPOS) {
                this.orgRoleMenuMapper.deleteByAuthId(PO.getAuthId());
            }
        }
    }
}

