/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.menu;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.MenuMapper;
import com.ohaotian.authority.menu.bo.MenuTreeRspBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeReqBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeRspBO;
import com.ohaotian.authority.menu.service.SelectMgrMenuTreeBusiService;
import com.ohaotian.authority.po.Menu;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.menu.service.SelectMgrMenuTreeBusiService"})
public class SelectMgrMenuTreeBusiServiceImpl
implements SelectMgrMenuTreeBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectMgrMenuTreeBusiServiceImpl.class);
    @Autowired
    private MenuMapper menuMapper;

    @PostMapping(value={"selectMgrMenuTree"})
    public SelectMenuTreeRspBO selectMgrMenuTree(@RequestBody SelectMenuTreeReqBO selectMenuTreeReqBO) {
        if (StringUtils.isBlank((CharSequence)selectMenuTreeReqBO.getRoleIdentity())) {
            throw new ZTBusinessException("\u6743\u9650\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Menu> menus = this.menuMapper.selectMgrMenus(selectMenuTreeReqBO.getRoleIdentity(), selectMenuTreeReqBO.getApplicationCode());
        SelectMenuTreeRspBO selectMenuTreeRspBO = new SelectMenuTreeRspBO();
        List<Long> longs = this.menuMapper.selectRoleMenuIds(selectMenuTreeReqBO.getRoleId());
        if (menus != null && menus.size() > 0) {
            LinkedList<MenuTreeRspBO> menuTree = new LinkedList<MenuTreeRspBO>();
            for (Menu menu : menus) {
                MenuTreeRspBO map = (MenuTreeRspBO)BeanMapper.map((Object)menu, MenuTreeRspBO.class);
                if (longs.contains(menu.getMenuId())) {
                    map.setHasSel(Boolean.valueOf(true));
                    map.setFlag(Boolean.valueOf(true));
                }
                menuTree.add(map);
            }
            List<MenuTreeRspBO> menuTreeRspBOS = this.buildByRecursive(menuTree);
            selectMenuTreeRspBO.setMenuTreeRspBOS(menuTreeRspBOS);
        }
        return selectMenuTreeRspBO;
    }

    private List<MenuTreeRspBO> buildByRecursive(List<MenuTreeRspBO> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<MenuTreeRspBO> trees = new ArrayList<MenuTreeRspBO>();
        for (MenuTreeRspBO treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private MenuTreeRspBO findChildren(MenuTreeRspBO root, List<MenuTreeRspBO> allMenus) {
        for (MenuTreeRspBO it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            if (root.getAuthButtons() == null) {
                root.setAuthButtons(new ArrayList());
            }
            if (Constants.MENU_TYPE_F.equals(it.getType())) {
                root.getAuthButtons().add(it);
                continue;
            }
            root.getChildren().add(this.findChildren(it, allMenus));
        }
        return root;
    }
}

