/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.authority.atom.api.organisation.InsertOrgBatchAtomService;
import com.ohaotian.authority.atom.api.organisation.SelectOrgBatchAtomService;
import com.ohaotian.authority.atom.api.user.SelectUserBatchAtomService;
import com.ohaotian.authority.organisation.bo.OrgBatchExcelURLRspBO;
import com.ohaotian.authority.organisation.bo.OrgBatchImportBO;
import com.ohaotian.authority.organisation.bo.OrgBatchImportFileReqBO;
import com.ohaotian.authority.organisation.bo.OrgBatchImportParseRspBO;
import com.ohaotian.authority.organisation.bo.OrgBatchImportReqBO;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.OrgBatchImportService;
import com.ohaotian.authority.user.bo.AddUserListReqBO;
import com.ohaotian.authority.user.bo.AddUserReqBO;
import com.ohaotian.authority.user.service.AddManageUserService;
import com.ohaotian.authority.util.ExcelParseUtils;
import com.ohaotian.authority.util.HttpConnUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.organisation.service.OrgBatchImportService"})
public class OrgBatchImportServiceImpl
implements OrgBatchImportService {
    private static final Logger log = LoggerFactory.getLogger(OrgBatchImportServiceImpl.class);
    private static final String CREATE_USER_IDENTITY = "\u662f";
    @Resource
    FileClient fileClient;
    @Value(value="${MERCHANT_ESCAPECODE_BYPARENTCODE_URL:}")
    private String MERCHANT_ESCAPECODE_BYPARENTCODE_URL;
    @Value(value="${MERCHANT_BATCHIMOPRT_ADD_URL:}")
    private String MERCHANT_BATCHIMOPRT_ADD_URL;
    @Value(value="${ORGBATCH_EXECEL_URL:}")
    private String ORGBATCH_EXECEL_URL;
    @Value(value="${oss.accessUrl:}")
    private String OSS_ACCESSURL;
    @Autowired
    private SelectUserBatchAtomService selectUserBatchAtomService;
    @Autowired
    private SelectOrgBatchAtomService selectOrgBatchAtomService;
    @Autowired
    private InsertOrgBatchAtomService insertOrgBatchAtomService;
    @Value(value="${MERCHANT_ROLE_CODE:lwt:merchant}")
    private String MERCHANT_ROLE_CODE;
    @Autowired
    private AddManageUserService addManageUserService;

    @PostMapping(value={"parseOrgExcel"})
    public OrgBatchImportParseRspBO parseOrgExcel(@RequestBody OrgBatchImportFileReqBO orgBatchImportFileReqBO) {
        if (null == orgBatchImportFileReqBO || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgBatchImportFileReqBO.getFilePath())) {
            log.error("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a,orgBatchImportFileReqBO");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u4e1a\u52a1\u670d\u52a1_\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        if (null == orgBatchImportFileReqBO.getmOrgPath() || null == orgBatchImportFileReqBO.getmTenantId()) {
            log.error("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u4e1a\u52a1\u670d\u52a1\u7528\u6237\u4fe1\u606f\u6811\u8def\u5f84|\u79df\u6237id\u4e3a\u7a7a");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u4e1a\u52a1\u670d\u52a1_\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        orgBatchImportFileReqBO.setTenantId(orgBatchImportFileReqBO.getmTenantId());
        orgBatchImportFileReqBO.setOrgTreePath(orgBatchImportFileReqBO.getmOrgPath());
        log.info("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u4e1a\u52a1\u670d\u52a1\u5165\u53c2,orgBatchImportFileReqBO{}", (Object)JSON.toJSONString((Object)orgBatchImportFileReqBO));
        log.info("\u5f00\u59cb\u89e3\u6790\u673a\u6784\u6279\u5230\u4fe1\u606f,startTime={}", (Object)System.currentTimeMillis());
        File file = null;
        try {
            file = this.fileClient.downloadToFile(orgBatchImportFileReqBO.getFilePath());
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25,\u6279\u5bfc\u6587\u4ef6\u8def\u5f84path=" + orgBatchImportFileReqBO.getFilePath());
            throw new ZTBusinessException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25,\u6279\u5bfc\u6587\u4ef6\u8def\u5f84");
        }
        String suffix = null;
        try {
            suffix = OrgBatchImportServiceImpl.getSuffix(file.getPath());
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25,TkExcelUtils{}");
            throw new ZTBusinessException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25,\u6279\u5bfc\u6587\u4ef6\u8def\u5f84");
        }
        OrgBatchImportParseRspBO rspBO = this.readXlsx2(file.getPath(), suffix, orgBatchImportFileReqBO);
        log.info("\u5f00\u59cb\u89e3\u6790\u673a\u6784\u6279\u5230\u4fe1\u606f,endTime={}", (Object)System.currentTimeMillis());
        return rspBO;
    }

    public static String getSuffix(String path) {
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        return path.contains(".") ? path.substring(path.lastIndexOf(".") + 1, path.length()) : null;
    }

    private OrgBatchImportParseRspBO readXlsx2(String path, String suffix, OrgBatchImportFileReqBO orgBatchImportFileReqBO) {
        log.info("\u673a\u6784\u6279\u5bfc\uff0cexcel\u9a8c\u8bc1\u5f00\u59cb");
        OrgBatchImportParseRspBO orgRspBO = new OrgBatchImportParseRspBO();
        String orgTreePath = orgBatchImportFileReqBO.getmOrgPath();
        ArrayList<HSSFRow> rows = null;
        if ("xls".equals(suffix)) {
            List<HSSFRow> hssfRows = ExcelParseUtils.readXls(path, 0, 1, 2);
            rows = new ArrayList<HSSFRow>(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List<XSSFRow> xssfRows = ExcelParseUtils.readXlsx(path, 0, 1, 2);
            rows = new ArrayList<XSSFRow>(xssfRows);
        } else {
            log.error("\u673a\u6784\u6279\u5bfc\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
        }
        if (CollectionUtils.isEmpty(rows)) {
            log.error("\u673a\u6784\u6279\u5bfcExcel\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfcExcel\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
        }
        if (rows.size() > 100) {
            log.error("\u673a\u6784\u6279\u5bfc\u8d85\u8fc7100\u6761\u5546\u54c1\u4fe1\u606f\u8bf7\u5206\u6279\u4e0a\u4f20");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u8d85\u8fc7100\u6761\u5546\u54c1\u4fe1\u606f\u8bf7\u5206\u6279\u4e0a\u4f20");
        }
        ArrayList<OrgBatchImportBO> successTempBOs = new ArrayList<OrgBatchImportBO>();
        ArrayList<OrgBatchImportBO> failBOs = new ArrayList<OrgBatchImportBO>();
        HashSet<String> loginNameSet = new HashSet<String>();
        HashSet<String> cellPhoneSet = new HashSet<String>();
        Pattern phoneP = Pattern.compile("1\\d{10}");
        for (Row row : rows) {
            StringBuilder failDesc = new StringBuilder();
            OrgBatchImportBO orgImportBO = new OrgBatchImportBO();
            String title = ExcelParseUtils.changeCellToString(row.getCell(0), false);
            orgImportBO.setTitle(title);
            String parentName = ExcelParseUtils.changeCellToString(row.getCell(1), false);
            orgImportBO.setParentName(parentName);
            Long parentId = null;
            try {
                parentId = Long.parseLong(ExcelParseUtils.changeCellToString(row.getCell(2), false));
                orgImportBO.setParentId(parentId);
            }
            catch (Exception e) {
                failDesc.append("\u4e0a\u7ea7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u662f\u6570\u5b57|");
            }
            String levelName = ExcelParseUtils.changeCellToString(row.getCell(3), false);
            orgImportBO.setLevelName(levelName);
            String merchantCharacterName = ExcelParseUtils.changeCellToString(row.getCell(4), false);
            orgImportBO.setMerchantCharacterName(merchantCharacterName);
            String typeName = ExcelParseUtils.changeCellToString(row.getCell(5), false);
            orgImportBO.setTypeName(typeName);
            String merchantBrand = ExcelParseUtils.changeCellToString(row.getCell(6), false);
            orgImportBO.setMerchantBrand(merchantBrand);
            String merchantIntroduction = ExcelParseUtils.changeCellToString(row.getCell(7), false);
            orgImportBO.setMerchantIntroduction(merchantIntroduction);
            String contactName = ExcelParseUtils.changeCellToString(row.getCell(8), false);
            orgImportBO.setContactName(contactName);
            String contactPhone = ExcelParseUtils.changeCellToString(row.getCell(9), false);
            orgImportBO.setContactPhone(contactPhone);
            String address = ExcelParseUtils.changeCellToString(row.getCell(10), false);
            orgImportBO.setAddress(address);
            String busiTime = ExcelParseUtils.changeCellToString(row.getCell(11), false);
            orgImportBO.setBusiTime(busiTime);
            String isCreateUser = ExcelParseUtils.changeCellToString(row.getCell(12), false);
            orgImportBO.setIsCreateUser(isCreateUser);
            String loginNameReq = ExcelParseUtils.changeCellToString(row.getCell(13), false);
            orgImportBO.setLoginNameReq(loginNameReq);
            String cellPhoneReq = ExcelParseUtils.changeCellToString(row.getCell(14), false);
            orgImportBO.setCellPhoneReq(cellPhoneReq);
            String emailReq = ExcelParseUtils.changeCellToString(row.getCell(15), false);
            orgImportBO.setEmailReq(emailReq);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)title)) {
                failDesc.append("\u5546\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a|");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contactName)) {
                failDesc.append("\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a|");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contactPhone) || !phoneP.matcher(contactPhone).matches()) {
                failDesc.append("\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e|");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)address)) {
                failDesc.append("\u7269\u4e1a\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a|");
            }
            if (!this.checkBusiTime(busiTime)) {
                failDesc.append("\u8425\u4e1a\u65f6\u95f4\u683c\u5f0f\u9519\u8bef|");
            } else {
                String[] split = busiTime.split("-");
                orgImportBO.setOpenTime(split[0] + ":00");
                orgImportBO.setCloseTime(split[1] + ":00");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)isCreateUser)) {
                failDesc.append("\u521b\u5efa\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a|");
                orgImportBO.setLoginNameReq(null);
                orgImportBO.setCellPhoneReq(null);
                orgImportBO.setEmailReq(null);
            } else if (isCreateUser.equals(CREATE_USER_IDENTITY)) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)loginNameReq)) {
                    failDesc.append("\u5546\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a|");
                } else if (loginNameSet.contains(loginNameReq)) {
                    failDesc.append("\u5546\u6237\u8d26\u53f7\u91cd\u590d|");
                } else {
                    loginNameSet.add(loginNameReq);
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cellPhoneReq) || !phoneP.matcher(cellPhoneReq).matches()) {
                    failDesc.append("\u5546\u6237\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e|");
                } else if (cellPhoneSet.contains(cellPhoneReq)) {
                    failDesc.append("\u5546\u6237\u624b\u673a\u53f7\u91cd\u590d|");
                } else {
                    cellPhoneSet.add(cellPhoneReq);
                }
            } else {
                orgImportBO.setLoginNameReq(null);
                orgImportBO.setCellPhoneReq(null);
                orgImportBO.setEmailReq(null);
            }
            orgImportBO.setRowNum(String.valueOf(row.getRowNum() + 1));
            orgImportBO.setDesc(failDesc.toString());
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgImportBO.getDesc())) {
                successTempBOs.add(orgImportBO);
                continue;
            }
            failBOs.add(orgImportBO);
        }
        log.info("\u673a\u6784\u6279\u5bfcExcel\u89e3\u6790\u7b26\u5408\u89c4\u5219\u96c6\u5408,successTempBOs{}", (Object)JSON.toJSONString(successTempBOs));
        ArrayList<OrgBatchImportBO> successBOs = new ArrayList<OrgBatchImportBO>();
        if (CollectionUtils.isNotEmpty(successTempBOs)) {
            this.dbCheck(successTempBOs, successBOs, failBOs, orgTreePath, orgBatchImportFileReqBO.getToken());
        }
        log.info("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u9a8c\u8bc1\u5931\u8d25\u96c6\u5408,failBOs={}", (Object)JSON.toJSONString(failBOs));
        log.info("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u9a8c\u8bc1\u6210\u529f\u96c6\u5408,successBOs={}", (Object)JSON.toJSONString(successBOs));
        orgRspBO.setSuccessBOs(successBOs);
        orgRspBO.setFailuresBOs(failBOs);
        return orgRspBO;
    }

    private void dbCheck(List<OrgBatchImportBO> successTempBOs, List<OrgBatchImportBO> successBOs, List<OrgBatchImportBO> failBOs, String orgTreePath, String token) {
        ArrayList<String> loginNameS = new ArrayList<String>();
        ArrayList<String> cellPhoneS = new ArrayList<String>();
        ArrayList<Long> orgIdS = new ArrayList<Long>();
        for (OrgBatchImportBO orgBatchImportBO : successTempBOs) {
            loginNameS.add(orgBatchImportBO.getLoginNameReq());
            cellPhoneS.add(orgBatchImportBO.getCellPhoneReq());
            if (orgBatchImportBO.getParentId() == null) {
                orgBatchImportBO.setDesc(orgBatchImportBO.getDesc() + "\u4e0a\u7ea7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a|");
                continue;
            }
            orgIdS.add(orgBatchImportBO.getParentId());
        }
        List<String> loginNameSOut = this.selectUserBatchAtomService.selectUserLoginNameBatchByLoginName(loginNameS);
        List<String> cellPhoneSOut = this.selectUserBatchAtomService.selectUserCellPhoneBatchByCellPhone(cellPhoneS);
        Map<Long, OrganisationBO> orgMap = this.selectOrgBatchAtomService.selectOrgBatchByOrgIdS(orgIdS);
        Map<String, String> typeMap = this.queryMerchantEscapeCode("MERCHANT_TYPE", token);
        Map<String, String> levelMap = this.queryMerchantEscapeCode("MERCHANT_LEVEL", token);
        Map<String, String> charcterMap = this.queryMerchantEscapeCode("MERCHANT_MERCHANT_CHARACTER", token);
        for (OrgBatchImportBO orgBatchImportBO : successTempBOs) {
            OrganisationBO organisationBO;
            StringBuilder failDesc = new StringBuilder();
            if (typeMap.containsKey(orgBatchImportBO.getTypeName())) {
                orgBatchImportBO.setType(typeMap.get(orgBatchImportBO.getTypeName()));
            } else {
                failDesc.append("\u5546\u6237\u7c7b\u578b\u4e0d\u5b58\u5728|");
            }
            if (levelMap.containsKey(orgBatchImportBO.getLevelName())) {
                orgBatchImportBO.setLevel(levelMap.get(orgBatchImportBO.getLevelName()));
                if ("\u4f01\u4e1a".equals(orgBatchImportBO.getLevelName())) {
                    if (charcterMap.containsKey(orgBatchImportBO.getMerchantCharacterName())) {
                        orgBatchImportBO.setMerchantCharacter(charcterMap.get(orgBatchImportBO.getMerchantCharacterName()));
                    } else {
                        failDesc.append("\u4f01\u4e1a\u6027\u8d28\u4e0d\u5b58\u5728|");
                    }
                }
            } else {
                failDesc.append("\u5546\u6237\u5927\u7c7b\u4e0d\u5b58\u5728|");
            }
            if (orgBatchImportBO.getIsCreateUser().equals(CREATE_USER_IDENTITY)) {
                if (loginNameSOut.contains(orgBatchImportBO.getLoginNameReq())) {
                    failDesc.append("\u7528\u6237\u540d\u5df2\u5b58\u5728|");
                }
                if (cellPhoneSOut.contains(orgBatchImportBO.getCellPhoneReq())) {
                    failDesc.append("\u624b\u673a\u53f7\u5df2\u5b58\u5728|");
                }
            }
            if ((organisationBO = orgMap.get(orgBatchImportBO.getParentId())) != null) {
                if (!organisationBO.getOrgTreePath().contains(orgTreePath)) {
                    failDesc.append("\u5f53\u524d\u7528\u6237\u6743\u9650\u4e0d\u652f\u6301\u521b\u5efa\u8be5\u673a\u6784|");
                }
                if ("org_type_5".equals(organisationBO.getType())) {
                    failDesc.append("\u4e0a\u7ea7\u673a\u6784\u4e3a\u5546\u6237,\u4e0d\u80fd\u7ee7\u7eed\u521b\u5efa\u5546\u6237|");
                }
                if (!"org_type_3".equals(organisationBO.getType()) && !"org_type_4".equals(organisationBO.getType())) {
                    failDesc.append("\u4e0a\u7ea7\u673a\u6784\u4e0d\u80fd\u521b\u5efa\u5546\u6237,\u8bf7\u91cd\u65b0\u6307\u5b9a|");
                }
            } else {
                failDesc.append("\u4e0a\u7ea7\u673a\u6784\u4e0d\u5b58\u5728|");
            }
            orgBatchImportBO.setDesc(orgBatchImportBO.getDesc() + failDesc.toString());
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgBatchImportBO.getDesc()) || "\u89e3\u6790\u6210\u529f".equals(orgBatchImportBO.getDesc())) {
                orgBatchImportBO.setDesc("\u89e3\u6790\u6210\u529f");
                successBOs.add(orgBatchImportBO);
                continue;
            }
            failBOs.add(orgBatchImportBO);
        }
    }

    private Map<String, String> queryMerchantEscapeCode(String parentCode, String token) {
        log.info("\u673a\u6784\u6279\u5bfc,\u67e5\u8be2\u5546\u6237\u7801\u8868\u5f00\u59cb");
        HashMap<String, String> map = new HashMap<String, String>();
        OrgBatchImportBO merchantBO = new OrgBatchImportBO();
        merchantBO.setParentCode(parentCode);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("auth-token", token);
        String jsonStr = HttpConnUtils.conn(null, JSON.toJSONString((Object)merchantBO), headerMap, this.MERCHANT_ESCAPECODE_BYPARENTCODE_URL, null, null, "application/json");
        JSONObject data = JSON.parseObject((String)String.valueOf(JSON.parseObject((String)jsonStr)));
        log.info("http\u8c03\u7528\u5546\u6237\u5b8c\u6bd5,\u6839\u636eparentCode\u67e5\u8be2\u7801\u8868\u7684\u7ed3\u679c\u4e3adata{}", (Object)data);
        if (!data.get((Object)"respCode").equals("0000")) {
            log.error("\u673a\u6784\u6279\u5bfc,\u67e5\u8be2\u5546\u6237\u7801\u8868\u5931\u8d25:" + data.get((Object)"respDesc").toString());
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u670d\u52a1,\u5546\u6237\u9a8c\u8bc1\u5931\u8d25");
        }
        JSONArray rows = JSONArray.parseArray((String)data.get((Object)"rows").toString());
        for (int i = 0; i < rows.size(); ++i) {
            JSONObject jsonObject = JSON.parseObject((String)rows.get(i).toString());
            map.put(jsonObject.getString("codeTitle"), jsonObject.getString("code"));
        }
        return map;
    }

    private boolean checkBusiTime(String busiTime) {
        boolean flag = false;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)busiTime) || !busiTime.contains("-")) {
            return flag;
        }
        String[] split = busiTime.split("-");
        if (split.length != 2) {
            return flag;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("hh:ss");
            format.parse(split[0]);
            format.parse(split[1]);
            flag = true;
        }
        catch (Exception e) {
            log.info("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff0ctime={}", (Object)busiTime);
        }
        return flag;
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"batchImportInsert"})
    public RspBaseBO batchImportInsert(@RequestBody OrgBatchImportReqBO orgBatchImportReqBO) throws Exception {
        RspBaseBO rspBaseBO = new RspBaseBO();
        if (orgBatchImportReqBO == null) {
            log.error("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2,orgBatchImportReqBO\u4e3a\u7a7a");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1_\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        if (null == orgBatchImportReqBO.getmOrgPath() || null == orgBatchImportReqBO.getmTenantId()) {
            log.error("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u7528\u6237\u4fe1\u606f\u8def\u5f84|\u79df\u6237id\u4e3a\u7a7a");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1_\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        log.info("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2,orgBatchImportReqBO{}", (Object)orgBatchImportReqBO);
        Long tenantId = orgBatchImportReqBO.getmTenantId();
        String orgTreePath = orgBatchImportReqBO.getmOrgPath();
        List orgBatchImportBOList = orgBatchImportReqBO.getLists();
        log.info("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u6821\u9a8c\u96c6\u5408,orgBatchImportBOList{}", (Object)JSON.toJSONString((Object)orgBatchImportBOList));
        ArrayList<OrgBatchImportBO> successBOs = new ArrayList<OrgBatchImportBO>();
        ArrayList<OrgBatchImportBO> failBOs = new ArrayList<OrgBatchImportBO>();
        this.dbCheck(orgBatchImportBOList, successBOs, failBOs, orgTreePath, orgBatchImportReqBO.getToken());
        if (CollectionUtils.isNotEmpty(failBOs)) {
            log.error("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1,\u4fe1\u606f\u6821\u9a8c\u5931\u8d25failBOs{}" + JSON.toJSONString(failBOs));
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1,\u4fe1\u606f\u6821\u9a8c\u5931\u8d25");
        }
        ArrayList<OrganisationBO> addOrgReqBOS = new ArrayList<OrganisationBO>();
        HashMap<String, AddUserReqBO> addUserMap = new HashMap<String, AddUserReqBO>();
        ArrayList<OrgBatchImportBO> orgBatchImportBOS = new ArrayList<OrgBatchImportBO>();
        for (Object orgBatchImportBO : orgBatchImportBOList) {
            OrganisationBO organisationBO = new OrganisationBO();
            organisationBO.setParentId(orgBatchImportBO.getParentId());
            organisationBO.setTitle(orgBatchImportBO.getTitle());
            organisationBO.setTenantId(tenantId);
            organisationBO.setCreatTime(new Date());
            organisationBO.setType("org_type_5");
            organisationBO.setAddress(orgBatchImportBO.getAddress());
            organisationBO.setRemark(orgBatchImportBO.getContactName());
            organisationBO.setTel(orgBatchImportBO.getContactPhone());
            organisationBO.setTypeCode(orgBatchImportBO.getType());
            organisationBO.setLevel(orgBatchImportBO.getLevel());
            organisationBO.setMerchantCharacter(orgBatchImportBO.getMerchantCharacter());
            organisationBO.setMerchantBrand(orgBatchImportBO.getMerchantBrand());
            organisationBO.setMerchantIntroduction(orgBatchImportBO.getMerchantIntroduction());
            organisationBO.setOpenTime(orgBatchImportBO.getOpenTime());
            organisationBO.setCloseTime(orgBatchImportBO.getCloseTime());
            addOrgReqBOS.add(organisationBO);
            if (!orgBatchImportBO.getIsCreateUser().equals(CREATE_USER_IDENTITY)) continue;
            organisationBO.setTempStr(orgBatchImportBO.getLoginNameReq());
            AddUserReqBO addUserReqBO = new AddUserReqBO();
            addUserReqBO.setLoginNameReq(orgBatchImportBO.getLoginNameReq());
            addUserReqBO.setCellPhoneReq(orgBatchImportBO.getCellPhoneReq());
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            addUserReqBO.setAuthUserId(Long.valueOf(l));
            addUserReqBO.setNameReq(orgBatchImportBO.getTitle());
            addUserReqBO.setEmailReq(orgBatchImportBO.getEmailReq());
            addUserReqBO.setType(this.MERCHANT_ROLE_CODE);
            addUserReqBO.setUserId(orgBatchImportReqBO.getmUserId());
            addUserReqBO.setTenantIdReq(tenantId);
            addUserMap.put(addUserReqBO.getLoginNameReq(), addUserReqBO);
        }
        List<OrganisationBO> organisationBOS = this.insertOrgBatchAtomService.insertOrgBatch(addOrgReqBOS);
        for (OrganisationBO organisationBO : organisationBOS) {
            String loginName = organisationBO.getTempStr();
            AddUserReqBO addUserReqBO = (AddUserReqBO)addUserMap.get(loginName);
            if (addUserReqBO != null) {
                addUserReqBO.setOrgIdReq(organisationBO.getOrgId());
            }
            OrgBatchImportBO orgBatchImportBO = new OrgBatchImportBO();
            JSONObject data = JSONObject.parseObject((String)organisationBO.getExtJson());
            orgBatchImportBO.setTitle(organisationBO.getTitle());
            orgBatchImportBO.setMerchantId(organisationBO.getOrgId());
            orgBatchImportBO.setOrgTreePath(organisationBO.getOrgTreePath());
            orgBatchImportBO.setContactName(data.get((Object)"remark").toString());
            orgBatchImportBO.setContactPhone(data.get((Object)"tel").toString());
            orgBatchImportBO.setAddress(data.get((Object)"address").toString());
            orgBatchImportBO.setType(data.get((Object)"typeCode").toString());
            orgBatchImportBO.setLevel(data.get((Object)"level").toString());
            if (null != data.get((Object)"merchantCharacter")) {
                orgBatchImportBO.setMerchantCharacter(data.get((Object)"merchantCharacter").toString());
            }
            orgBatchImportBO.setMerchantBrand(data.get((Object)"merchantBrand").toString());
            orgBatchImportBO.setMerchantIntroduction(data.get((Object)"merchantIntroduction").toString());
            orgBatchImportBO.setOpenTime(data.get((Object)"openTime").toString());
            orgBatchImportBO.setCloseTime(data.get((Object)"closeTime").toString());
            orgBatchImportBOS.add(orgBatchImportBO);
        }
        ArrayList addUserReqBOS = new ArrayList(addUserMap.values());
        if (CollectionUtils.isNotEmpty(addUserReqBOS)) {
            AddUserListReqBO addUserListReqBO = new AddUserListReqBO();
            addUserListReqBO.setAddUserReqBOS(addUserReqBOS);
            this.addManageUserService.insertBatchUser(addUserListReqBO);
        }
        if (CollectionUtils.isNotEmpty(orgBatchImportBOS)) {
            orgBatchImportReqBO.setLists(orgBatchImportBOS);
            log.info("http\u8fde\u63a5\u5546\u6237\u6279\u91cf\u65b0\u589e\u5f00\u59cb\uff0corgBatchImportReqBO{}", (Object)JSON.toJSONString((Object)orgBatchImportReqBO));
            System.out.println(JSON.toJSONString((Object)orgBatchImportReqBO));
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("auth-token", orgBatchImportReqBO.getToken());
            String jsonStr = HttpConnUtils.conn(null, JSON.toJSONString((Object)orgBatchImportReqBO), headerMap, this.MERCHANT_BATCHIMOPRT_ADD_URL, null, null, "application/json");
            JSONObject data = JSON.parseObject((String)String.valueOf(JSON.parseObject((String)jsonStr)));
            log.info("http\u8c03\u7528\u5546\u6237\u5b8c\u6bd5,\u5546\u6237\u6279\u5bfc\u65b0\u589e\u7ed3\u679c\u4e3a:{}", (Object)data);
            String respCode = data.get((Object)"respCode").toString();
            if (!respCode.equals("0000")) {
                String respDesc = data.get((Object)"respDesc").toString();
                log.error("\u5546\u6237\u6279\u91cf\u65b0\u589e\u51fa\u9519\uff1a" + respDesc);
                throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1,\u5546\u6237\u6279\u91cf\u65b0\u589e\u5931\u8d25");
            }
        }
        return rspBaseBO;
    }

    @PostMapping(value={"getOrgBatchExcelURL"})
    public OrgBatchExcelURLRspBO getOrgBatchExcelURL() {
        OrgBatchExcelURLRspBO orgBatchExcelURLRspBO = new OrgBatchExcelURLRspBO();
        orgBatchExcelURLRspBO.setExcelURL(this.OSS_ACCESSURL + this.ORGBATCH_EXECEL_URL);
        return orgBatchExcelURLRspBO;
    }
}

