/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.atom.api.organisation.OrganisationAtomService;
import com.ohaotian.authority.organisation.bo.OrgTreeNameDetailBO;
import com.ohaotian.authority.organisation.bo.OrgTreeQueryDetailReqBO;
import com.ohaotian.authority.organisation.bo.OrgTreeQueryDetailRspBO;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.OrgTreeQueryDetailBuisService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgTreeQueryDetailBuisServiceImpl
implements OrgTreeQueryDetailBuisService {
    private static final Logger log = LoggerFactory.getLogger(OrgTreeQueryDetailBuisServiceImpl.class);
    @Resource
    private OrganisationAtomService organisationAtomService;

    public OrgTreeQueryDetailRspBO orgTreeQueryDetail(OrgTreeQueryDetailReqBO reqBO) {
        if (null == reqBO) {
            log.error("\u901a\u8fc7\u673a\u6784\u6570\u5217\u8868\u67e5\u8be2\u673a\u6784\u8be6\u60c5_\u4e1a\u52a1\u670d\u52a1,\u5165\u53c2OrgTreeQueryDetailReqBO\u4e3a\u7a7a");
            throw new ZTBusinessException("\u901a\u8fc7\u673a\u6784\u6570\u5217\u8868\u67e5\u8be2\u673a\u6784\u8be6\u60c5\u670d\u52a1\u5f02\u5e38");
        }
        if (null == reqBO.getmOrgPath() || null == reqBO.getmTenantId()) {
            log.error("\u901a\u8fc7\u673a\u6784\u6570\u5217\u8868\u67e5\u8be2\u673a\u6784\u8be6\u60c5_\u4e1a\u52a1\u670d\u52a1 \u7528\u6237\u4fe1\u606f\u8def\u5f84|\u79df\u6237id\u4e3a\u7a7a");
            throw new ZTBusinessException("\u673a\u6784\u6570\u5217\u8868\u67e5\u8be2\u673a\u6784\u8be6\u60c5_\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        OrgTreeQueryDetailRspBO rspBO = new OrgTreeQueryDetailRspBO();
        List orgTreePathS = reqBO.getOrgTreePathS();
        if (CollectionUtils.isEmpty((Collection)orgTreePathS)) {
            log.error("\u901a\u8fc7\u673a\u6784\u6570\u5217\u8868\u67e5\u8be2\u673a\u6784\u8be6\u60c5_\u4e1a\u52a1\u670d\u52a1,\u672a\u83b7\u53d6\u5230\u673a\u6784\u6811\u5217\u8868");
            return rspBO;
        }
        HashMap<Long, OrgTreeNameDetailBO> orgIdMap = new HashMap<Long, OrgTreeNameDetailBO>();
        HashSet<String> orgIdSTemp = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)orgTreePathS)) {
            for (String orgTreePath : orgTreePathS) {
                if (StringUtils.isBlank((CharSequence)orgTreePath)) continue;
                String substring = orgTreePath.substring(0, 2);
                if (substring.equals("1-")) {
                    orgTreePath = orgTreePath.substring(2);
                }
                String[] split = orgTreePath.split("-");
                OrgTreeNameDetailBO detailBO = new OrgTreeNameDetailBO();
                detailBO.setParentIdTree(orgTreePath.substring(0, orgTreePath.lastIndexOf("-", orgTreePath.lastIndexOf("-") - 1) + 1));
                orgIdMap.put(Long.parseLong(split[split.length - 1]), detailBO);
                orgIdSTemp.addAll(Arrays.asList(split));
            }
        } else {
            log.error("\u901a\u8fc7\u673a\u6784\u6570\u5217\u8868\u67e5\u8be2\u673a\u6784\u8be6\u60c5_\u4e1a\u52a1\u670d\u52a1,\u673a\u6784\u6811\u5217\u8868\u4e3a\u7a7a");
            throw new ZTBusinessException("\u901a\u8fc7\u673a\u6784\u6570\u5217\u8868\u67e5\u8be2\u673a\u6784\u8be6\u60c5\u670d\u52a1\u5f02\u5e38");
        }
        log.info("\u8981\u67e5\u8be2\u8be6\u60c5\u7684\u673a\u6784id\u5217\u8868,orgIdS={}", orgIdSTemp);
        List orgIdS = JSON.parseArray((String)JSON.toJSONString(orgIdSTemp), Long.class);
        Map<Long, OrganisationBO> boMap = this.organisationAtomService.queryOrgByIdS(orgIdS);
        for (Map.Entry entry : orgIdMap.entrySet()) {
            OrgTreeNameDetailBO value = (OrgTreeNameDetailBO)entry.getValue();
            String parentIdTree = value.getParentIdTree();
            String[] orgIdArr = parentIdTree.split("-");
            LinkedList<OrganisationBO> parentS = new LinkedList<OrganisationBO>();
            StringBuffer stringBuffer = new StringBuffer();
            for (String orgId : orgIdArr) {
                OrganisationBO parentBO = boMap.get(Long.parseLong(orgId));
                if (null == parentBO) continue;
                if ("org_type_3".equals(parentBO.getType()) || "org_type_4".equals(parentBO.getType())) {
                    parentBO.setCreatTime(null);
                    parentBO.setUpdateTime(null);
                    parentS.add(parentBO);
                    stringBuffer.append(parentBO.getTitle() + "-");
                    continue;
                }
                parentIdTree = parentIdTree.replace(orgId + "-", "");
            }
            value.setParentIdTree(parentIdTree);
            value.setParentNameTree(stringBuffer.substring(0, stringBuffer.length() - 1));
            value.setParentS(parentS);
        }
        rspBO.setOrgIdMap(orgIdMap);
        return rspBO;
    }
}

