/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.ApplicationMapper;
import com.ohaotian.authority.dao.StationBusinessMapper;
import com.ohaotian.authority.dao.StationSourceMapper;
import com.ohaotian.authority.dic.bo.SelectDicBypDicValReqBO;
import com.ohaotian.authority.dic.bo.SelectDicBypDicValRspBO;
import com.ohaotian.authority.dic.service.SelectDicBypDicValBusiService;
import com.ohaotian.authority.po.Application;
import com.ohaotian.authority.po.StationBusiness;
import com.ohaotian.authority.po.StationSource;
import com.ohaotian.authority.station.bo.SelectStationSourceByIdReqBO;
import com.ohaotian.authority.station.bo.SelectStationSourceByIdRspBO;
import com.ohaotian.authority.station.service.SelectStationSourceByIdService;
import com.ohaotian.plugin.common.util.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.station.service.SelectStationSourceByIdService"})
public class SelectStationSourceByIdServiceImpl
implements SelectStationSourceByIdService {
    private static final Logger log = LoggerFactory.getLogger(SelectStationSourceByIdServiceImpl.class);
    @Autowired
    StationSourceMapper stationSourceMapper;
    @Autowired
    StationBusinessMapper stationBusinessMapper;
    @Autowired
    ApplicationMapper applicationMapper;
    @Autowired
    SelectDicBypDicValBusiService selectDicBypDicValBusiService;

    @PostMapping(value={"selectStationSourceById"})
    public SelectStationSourceByIdRspBO selectStationSourceById(@RequestBody SelectStationSourceByIdReqBO authId) {
        StationSource stationSource = this.stationSourceMapper.selectStationSourceById(authId.getAuthId());
        SelectStationSourceByIdRspBO rsp = (SelectStationSourceByIdRspBO)BeanMapper.map((Object)stationSource, SelectStationSourceByIdRspBO.class);
        StationBusiness stationBusines = this.stationBusinessMapper.selectByBusiCode(stationSource.getBusiCode());
        Application application = this.applicationMapper.selectByAppCode(stationBusines.getApplicationCode());
        SelectDicBypDicValReqBO selectDicBypDicValReqBO = new SelectDicBypDicValReqBO();
        selectDicBypDicValReqBO.setpDicVal(Constants.DATA_SOURCE_TYPE);
        SelectDicBypDicValRspBO selectDicBypDicValRspBO = this.selectDicBypDicValBusiService.selectDicBypDicVal(selectDicBypDicValReqBO);
        String mapValue = (String)selectDicBypDicValRspBO.getDicMap().get(stationSource.getDataType() + "");
        rsp.setDataTypeName(mapValue);
        rsp.setBusiName(stationBusines.getBusiName());
        rsp.setApplicationName(application.getApplicationName());
        return rsp;
    }
}

