/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.mq.bo.DelRoleSendMsgReqBO;
import com.ohaotian.authority.mq.service.DelRoleSendMsgService;
import com.ohaotian.authority.role.bo.AuthDistributeBO;
import com.ohaotian.authority.role.bo.SelectRoleByIdReqBO;
import com.ohaotian.authority.role.service.SaveDistributeBusiService;
import com.ohaotian.authority.role.service.SelectRoleByIdBusiService;
import com.ohaotian.authority.user.bo.SaveUserAuthReqBO;
import com.ohaotian.authority.user.service.DeleteRoleByUserIdService;
import com.ohaotian.authority.user.service.SaveRoleAuthService;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import com.ohaotian.plugin.db.Sequence;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.user.service.SaveRoleAuthService"})
public class SaveRoleAuthServiceImpl
implements SaveRoleAuthService {
    private static final Logger log = LoggerFactory.getLogger(SaveRoleAuthServiceImpl.class);
    @Autowired
    private DeleteRoleByUserIdService deleteRoleByUserIdService;
    @Autowired
    private SaveDistributeBusiService saveDistributeBusiService;
    @Autowired
    private SelectRoleByIdBusiService selectRoleByIdBusiService;
    @Autowired
    private SelectUserInfoService selectUserInfoService;
    @Autowired
    private DelRoleSendMsgService delRoleSendMsgService;
    @Value(value="${ROLE_DEL_IS_SEND_MSG:0}")
    private String ROLE_DEL_IS_SEND_MSG;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"saveRoleAuthService"})
    public void saveRoleAuthService(@RequestBody SaveUserAuthReqBO saveUserAuthReqBO) {
        Set<Long> delete;
        Long roleId = saveUserAuthReqBO.getRoleId();
        SelectRoleByIdReqBO reqBO = new SelectRoleByIdReqBO();
        reqBO.setRoleId(roleId);
        String json = saveUserAuthReqBO.getJson();
        String orgTreePath = saveUserAuthReqBO.getOrgTreePath();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.otherGrant(json);
        Set<Long> add = stringSetMap.get("add");
        if (add != null && add.size() > 0) {
            add.forEach(e -> {
                AuthDistributeBO authDistributeBO = new AuthDistributeBO();
                Sequence sequence = Sequence.getInstance();
                long l = sequence.nextId();
                authDistributeBO.setAuthId(Long.valueOf(l));
                authDistributeBO.setUserId(e);
                authDistributeBO.setRoleId(roleId);
                authDistributeBO.setDisFlag(Constants.AUTH_USER);
                if ("auth:org:manage".equals(saveUserAuthReqBO.getAuthIdentity())) {
                    authDistributeBO.setManaOrgTreePath(orgTreePath);
                }
                this.saveDistributeBusiService.saveDistribute(authDistributeBO);
            });
        }
        if ((delete = stringSetMap.get("delete")) != null && delete.size() > 0) {
            ArrayList userIds = new ArrayList();
            delete.forEach(e -> {
                AuthDistributeBO authDistributeBO = new AuthDistributeBO();
                authDistributeBO.setUserId(e);
                authDistributeBO.setRoleId(roleId);
                this.deleteRoleByUserIdService.deleteRoleByUserId(authDistributeBO);
                userIds.add(e);
            });
            if (this.ROLE_DEL_IS_SEND_MSG.equals("1")) {
                DelRoleSendMsgReqBO delRoleSendMsgReqBO = new DelRoleSendMsgReqBO();
                delRoleSendMsgReqBO.setRoleId(roleId);
                delRoleSendMsgReqBO.setUserIds(userIds);
                this.delRoleSendMsgService.delRoleSendMsg(delRoleSendMsgReqBO);
            }
        }
    }
}

