/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.Role;
import com.ohaotian.authority.user.bo.SelectLoginUserInfoReqBO;
import com.ohaotian.authority.user.bo.UserInfoBaseBO;
import com.ohaotian.authority.user.service.SelectLoginUserInfoService;
import com.ohaotian.plugin.cache.CacheClient;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.user.service.SelectLoginUserInfoService"})
public class SelectLoginUserInfoServiceImpl
implements SelectLoginUserInfoService {
    private static final Logger log = LoggerFactory.getLogger(SelectLoginUserInfoServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Resource
    private AuthDistributeMapper authDistributeMapper;
    @Resource
    private RoleMapper roleMapper;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    private static final String AUTH_USER = "AUTH_USER";

    @PostMapping(value={"selectLoginUserInfo"})
    public UserInfoBaseBO selectLoginUserInfo(@RequestBody SelectLoginUserInfoReqBO reqBO) {
        UserInfoBaseBO userInfo = null;
        try {
            userInfo = (UserInfoBaseBO)this.cacheClient.get(AUTH_USER + reqBO.getToken());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2redis\u4e2d\u7528\u6237\u4fe1\u606f\u51fa\u9519\uff1a" + e);
        }
        if (null == userInfo) {
            List<Long> orgIds;
            userInfo = this.userMapper.selectUserDetailByUserId(reqBO);
            if (null == userInfo) {
                log.debug("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff01\uff01\uff01");
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)userInfo.getmOrgPath()) && CollectionUtils.isNotEmpty(orgIds = this.organizationMapper.selectOrgIdsByTreePath(userInfo.getmOrgPath()))) {
                userInfo.setmOrgIds(orgIds);
            }
            try {
                this.cacheClient.set(AUTH_USER + reqBO.getToken(), (Object)userInfo, this.expTime);
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u4fe1\u606f\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e);
            }
        }
        List<Long> idList = this.authDistributeMapper.seleRoleIdList(reqBO.getUserId());
        List<Object> collect = new ArrayList();
        if (CollectionUtils.isNotEmpty(idList)) {
            List<Role> roles = this.roleMapper.selectRoleInfoByIdList(idList);
            collect = roles.stream().map(Role::getAuthIdentity).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(collect)) {
            userInfo.setmRole(collect);
        }
        return userInfo;
    }
}

