/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.atom.api.organisation.OrganisationAtomService;
import com.ohaotian.authority.atom.api.user.UserAtomService;
import com.ohaotian.authority.atom.api.user.UserOrgShowAtomService;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.bo.OrganisationBaseBO;
import com.ohaotian.authority.role.bo.UserBO;
import com.ohaotian.authority.user.bo.InsertBatchUserOrgShowReqBO;
import com.ohaotian.authority.user.bo.QueryUserOrgShowRspBO;
import com.ohaotian.authority.user.bo.UserOrgShowBO;
import com.ohaotian.authority.user.service.UserOrgShowBusiService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserOrgShowBusiServiceImpl
implements UserOrgShowBusiService {
    private static final Logger log = LoggerFactory.getLogger(UserOrgShowBusiServiceImpl.class);
    @Resource
    private UserOrgShowAtomService userOrgShowAtomService;
    @Resource
    private OrganisationAtomService organisationAtomService;
    @Resource
    private UserAtomService userAtomService;

    public int insertUserOrgShow(UserOrgShowBO reqBO) {
        if (reqBO == null || reqBO.getmUserId() == null) {
            log.error("\u65b0\u589e\u7528\u6237\u5c55\u793a\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606freqBO={}", (Object)reqBO);
            throw new ZTBusinessException("\u65b0\u589e\u7528\u6237\u5c55\u793a\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        reqBO.setUserId(reqBO.getmUserId());
        Long orgId = reqBO.getOrgId();
        ArrayList<Long> orgIdS = new ArrayList<Long>();
        orgIdS.add(orgId);
        Map<Long, OrganisationBO> map = this.organisationAtomService.queryOrgByIdS(orgIdS);
        if (null == map || map.size() == 0) {
            throw new ZTBusinessException("\u6307\u5b9a\u7684\u673a\u6784\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u786e\u8ba4");
        }
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        reqBO.setAuthId(Long.valueOf(l));
        int result = this.userOrgShowAtomService.insertUserOrgShow(reqBO);
        if (result == 0) {
            log.error("\u65b0\u589e\u7528\u6237\u5c55\u793a\u673a\u6784,sql\u6267\u884c\u672a\u8fd4\u56de\u6b63\u786e\u7ed3\u679c");
            throw new ZTBusinessException("\u65b0\u589e\u7528\u6237\u5c55\u793a\u673a\u6784\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return 0;
    }

    public QueryUserOrgShowRspBO selectUserOrgShow(UserOrgShowBO reqBO) {
        Map<Long, OrganisationBO> organisationBOMap;
        if (reqBO == null || reqBO.getmUserId() == null) {
            log.error("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u8981\u5c55\u793a\u7684\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606freqBO={}", (Object)reqBO);
            throw new ZTBusinessException("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u8981\u5c55\u793a\u7684\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        QueryUserOrgShowRspBO rspBO = new QueryUserOrgShowRspBO();
        reqBO.setUserId(reqBO.getmUserId());
        Long userId = reqBO.getmUserId();
        UserBO userBO = this.userAtomService.selectUserById(userId);
        if (userBO == null) {
            log.error("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u8981\u5c55\u793a\u7684\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606fuserId = {}", (Object)userId);
            throw new ZTBusinessException("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u8981\u5c55\u793a\u7684\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        rspBO.setUserId(reqBO.getUserId());
        List<Long> orgIdS = this.userOrgShowAtomService.selectOrgIdByUserId(userId);
        if (CollectionUtils.isNotEmpty(orgIdS) && (organisationBOMap = this.organisationAtomService.queryOrgByIdS(orgIdS)).size() > 0) {
            ArrayList<OrganisationBaseBO> boS = new ArrayList<OrganisationBaseBO>();
            for (Map.Entry<Long, OrganisationBO> entry : organisationBOMap.entrySet()) {
                OrganisationBaseBO bo = new OrganisationBaseBO();
                BeanUtils.copyProperties((Object)entry.getValue(), (Object)bo);
                boS.add(bo);
            }
            rspBO.setListS(boS);
        }
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertBatchUserOrgShow(InsertBatchUserOrgShowReqBO reqBO) {
        if (reqBO == null || reqBO.getmUserId() == null) {
            log.error("\u6279\u91cf\u65b0\u589e\u7528\u6237\u5c55\u793a\u7684\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606freqBO={}", (Object)reqBO);
            throw new ZTBusinessException("\u65b0\u589e\u7528\u6237\u5c55\u793a\u7684\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        Long userId = reqBO.getmUserId();
        UserBO userBO = this.userAtomService.selectUserById(userId);
        if (userBO == null) {
            log.error("\u6279\u91cf\u65b0\u589e\u7528\u6237\u5c55\u793a\u7684\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606fuserId = {}", (Object)userId);
            throw new ZTBusinessException("\u65b0\u589e\u7528\u6237\u5c55\u793a\u7684\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        ArrayList<Object> orgIdS = reqBO.getOrgIdS();
        if (CollectionUtils.isEmpty((Collection)orgIdS)) {
            log.error("\u6279\u91cf\u65b0\u589e\u7528\u6237\u5c55\u793a\u7684\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u673a\u6784\u4fe1\u606forgIdS = {}", (Object)orgIdS);
            throw new ZTBusinessException("\u65b0\u589e\u7528\u6237\u5c55\u793a\u7684\u673a\u6784,\u672a\u80fd\u83b7\u53d6\u5230\u673a\u6784\u4fe1\u606f");
        }
        Map<Long, OrganisationBO> organisationBOMap = this.organisationAtomService.queryOrgByIdS((List<Long>)orgIdS);
        if (orgIdS.size() != organisationBOMap.size()) {
            log.error("\u6279\u91cf\u65b0\u589e\u7528\u6237\u5c55\u793a\u7684\u673a\u6784,\u6307\u5b9a\u673a\u6784\u9519\u8beforganisationBOMap = {}", organisationBOMap);
            log.error("\u6279\u91cf\u65b0\u589e\u7528\u6237\u5c55\u793a\u7684\u673a\u6784,\u6307\u5b9a\u673a\u6784\u9519\u8beforgIdS = {}", (Object)orgIdS);
            throw new ZTBusinessException("\u65b0\u589e\u7528\u6237\u5c55\u793a\u7684\u673a\u6784,\u6307\u5b9a\u673a\u6784\u9519\u8bef");
        }
        List<Long> dbOrgIdS = this.userOrgShowAtomService.selectOrgIdByUserId(userId);
        ArrayList<Object> tempOrgIdS = new ArrayList<Object>();
        for (Object orgId : orgIdS) {
            if (dbOrgIdS.contains(orgId)) continue;
            tempOrgIdS.add(orgId);
        }
        orgIdS = tempOrgIdS;
        ArrayList<UserOrgShowBO> boS = new ArrayList<UserOrgShowBO>();
        for (Long l : orgIdS) {
            UserOrgShowBO bo = new UserOrgShowBO();
            Sequence sequence = Sequence.getInstance();
            long l2 = sequence.nextId();
            bo.setAuthId(Long.valueOf(l2));
            bo.setUserId(userId);
            bo.setOrgId(l);
            boS.add(bo);
        }
        int result = this.userOrgShowAtomService.insertBatchUserOrgShow(boS);
        if (result != orgIdS.size()) {
            throw new ZTBusinessException("\u65b0\u589e\u7528\u6237\u5c55\u793a\u7684\u673a\u6784,\u6307\u5b9a\u673a\u6784\u9519\u8bef");
        }
        return 0;
    }
}

