/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.util;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelParseUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelParseUtils.class);

    public static List<XSSFRow> readXlsx(String path, int startSheet, int startRow) {
        FileInputStream is = null;
        XSSFWorkbook xssfWorkbook = null;
        ArrayList<XSSFRow> xssfRows = new ArrayList<XSSFRow>();
        try {
            is = new FileInputStream(path);
            xssfWorkbook = new XSSFWorkbook((InputStream)is);
            for (int numSheet = startSheet; numSheet < xssfWorkbook.getNumberOfSheets(); ++numSheet) {
                XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
                if (xssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                    XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                    if (xssfRow == null) continue;
                    xssfRows.add(xssfRow);
                }
            }
        }
        catch (FileNotFoundException var18) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + var18.getLocalizedMessage());
            throw new ZTBusinessException("0015, \u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException var19) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + var19.getMessage());
            throw new ZTBusinessException("9999 " + var19.getMessage());
        }
        finally {
            try {
                if (null != xssfWorkbook) {
                    xssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException var17) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + var17.getMessage());
            }
        }
        return xssfRows;
    }

    public static List<XSSFRow> readXlsx(String path, int startSheet, int endSheet, int startRow) {
        FileInputStream is = null;
        XSSFWorkbook xssfWorkbook = null;
        ArrayList<XSSFRow> xssfRows = new ArrayList<XSSFRow>();
        try {
            is = new FileInputStream(path);
            xssfWorkbook = new XSSFWorkbook((InputStream)is);
            if (endSheet == 0) {
                endSheet = xssfWorkbook.getNumberOfSheets();
            }
            for (int numSheet = startSheet; numSheet < endSheet; ++numSheet) {
                XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
                if (xssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                    XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                    if (xssfRow == null) continue;
                    xssfRows.add(xssfRow);
                }
            }
        }
        catch (FileNotFoundException var19) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + var19.getLocalizedMessage());
            throw new ZTBusinessException("0015\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException var20) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + var20.getMessage());
            throw new ZTBusinessException("9999 " + var20.getMessage());
        }
        finally {
            try {
                if (null != xssfWorkbook) {
                    xssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException var18) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + var18.getMessage());
            }
        }
        return xssfRows;
    }

    public static List<HSSFRow> readXls(String path, int startSheet, int startRow) {
        FileInputStream is = null;
        HSSFWorkbook hssfWorkbook = null;
        ArrayList<HSSFRow> hssfRows = new ArrayList<HSSFRow>();
        try {
            is = new FileInputStream(path);
            hssfWorkbook = new HSSFWorkbook((InputStream)is);
            for (int numSheet = startSheet; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    hssfRows.add(hssfRow);
                }
            }
        }
        catch (FileNotFoundException var18) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + var18.getLocalizedMessage());
            throw new ZTBusinessException("0015\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException var19) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + var19.getMessage());
            throw new ZTBusinessException("9999 " + var19.getMessage());
        }
        finally {
            try {
                if (null != hssfWorkbook) {
                    hssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException var17) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + var17.getMessage());
            }
        }
        return hssfRows;
    }

    public static List<HSSFRow> readXls(String path, int startSheet, int endSheet, int startRow) {
        FileInputStream is = null;
        HSSFWorkbook hssfWorkbook = null;
        ArrayList<HSSFRow> hssfRows = new ArrayList<HSSFRow>();
        try {
            is = new FileInputStream(path);
            hssfWorkbook = new HSSFWorkbook((InputStream)is);
            if (endSheet == 0) {
                endSheet = hssfWorkbook.getNumberOfSheets();
            }
            for (int numSheet = startSheet; numSheet < endSheet; ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    hssfRows.add(hssfRow);
                }
            }
        }
        catch (FileNotFoundException var19) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + var19.getLocalizedMessage());
            throw new ZTBusinessException("0015 \u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException var20) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + var20.getMessage());
            throw new ZTBusinessException("9999 " + var20.getMessage());
        }
        finally {
            try {
                if (null != hssfWorkbook) {
                    hssfWorkbook.close();
                }
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException var18) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + var18.getMessage());
            }
        }
        return hssfRows;
    }

    public static String changeCellToString(Cell cell, Boolean isDecimal) {
        String returnValue = "";
        if (null != cell) {
            switch (cell.getCellType()) {
                case 0: {
                    String whatYourWant;
                    if (isDecimal.booleanValue()) {
                        returnValue = String.valueOf(cell.getNumericCellValue());
                        break;
                    }
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        returnValue = formater.format(date);
                        break;
                    }
                    DecimalFormat df = new DecimalFormat("0");
                    returnValue = whatYourWant = df.format(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    returnValue = cell.getStringCellValue();
                    break;
                }
                case 2: {
                    returnValue = cell.getCellFormula();
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    Boolean booleanValue = cell.getBooleanCellValue();
                    returnValue = booleanValue.toString();
                    break;
                }
                default: {
                    logger.error("\u672a\u77e5\u7c7b\u578b");
                }
            }
        }
        return returnValue;
    }

    public static String getSuffix(String path) {
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        return path.contains(".") ? path.substring(path.lastIndexOf(".") + 1, path.length()) : null;
    }
}

