/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.util;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HttpConnUtils {
    public static final String FORM = "application/x-www-form-urlencoded";
    public static final String JSON = "application/json";

    private static String realConn(String charset, String content, Map<String, String> header, String url, Integer connectTimeout, Integer socketTimeout, String contentType) {
        Map.Entry<String, String> entry2;
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = "UTF-8";
        }
        if (null == connectTimeout) {
            connectTimeout = 30000;
        }
        if (null == socketTimeout) {
            socketTimeout = 30000;
        }
        FilterOutputStream out = null;
        InputStream is = null;
        try {
            int statusCode;
            URL console = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)console.openConnection(Proxy.NO_PROXY);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(socketTimeout);
            conn.setDoOutput(true);
            if (null != header) {
                for (Map.Entry<String, String> entry2 : header.entrySet()) {
                    conn.setRequestProperty(entry2.getKey(), entry2.getValue());
                }
            }
            if (StringUtils.isBlank((CharSequence)contentType)) {
                conn.setRequestProperty("Content-Type", "application/json; charset=" + charset);
            } else {
                conn.setRequestProperty("Content-Type", contentType + "; charset=" + charset);
            }
            conn.connect();
            if (StringUtils.isNotBlank((CharSequence)content)) {
                out = new DataOutputStream(conn.getOutputStream());
                out.write(content.getBytes(charset));
                ((DataOutputStream)out).flush();
            }
            if (200 == (statusCode = conn.getResponseCode())) {
                String rspStr;
                String var16;
                int len;
                is = conn.getInputStream();
                if (null == is) {
                    String string = null;
                    return string;
                }
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    outStream.write(buffer, 0, len);
                }
                String string = var16 = (rspStr = new String(outStream.toByteArray(), charset));
                return string;
            }
            entry2 = null;
        }
        catch (MalformedURLException var34) {
            var34.printStackTrace();
            throw new ZTBusinessException("9999 " + var34.getMessage());
        }
        catch (UnsupportedEncodingException var35) {
            var35.printStackTrace();
            throw new ZTBusinessException("9999 " + var35.getMessage());
        }
        catch (IOException var36) {
            var36.printStackTrace();
            throw new ZTBusinessException("9999 " + var36.getMessage());
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException var33) {
                    var33.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException var32) {
                    var32.printStackTrace();
                }
            }
        }
        return String.valueOf(entry2);
    }

    public static String conn(String charset, String content, Map<String, String> header, String url, Integer connectTimeout, Integer socketTimeout) {
        return HttpConnUtils.realConn(charset, content, header, url, connectTimeout, socketTimeout, null);
    }

    public static String conn(String charset, String content, Map<String, String> header, String url, Integer connectTimeout, Integer socketTimeout, String contentType) {
        return HttpConnUtils.realConn(charset, content, header, url, connectTimeout, socketTimeout, contentType);
    }

    public static String conn(String content, String url, String contentType) {
        return HttpConnUtils.realConn(null, content, null, url, null, null, contentType);
    }
}

