/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.user;

import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.RegIndividualUserWebReqBO;
import com.ohaotian.authority.user.bo.RegIndividualUserWebRspBO;
import com.ohaotian.authority.user.service.RegIndividualUserOAuth2WebService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.user.service.RegIndividualUserOAuth2WebService"})
public class RegIndividualUserOAuth2WebServiceImpl
implements RegIndividualUserOAuth2WebService {
    private static final Logger log = LoggerFactory.getLogger(RegIndividualUserOAuth2WebServiceImpl.class);
    @Autowired
    private UserMapper userMapper;

    @Transactional
    @PostMapping(value={"registerIndividualUser"})
    public RegIndividualUserWebRspBO registerIndividualUser(@RequestBody RegIndividualUserWebReqBO reqBO) {
        Long userIdByExtId = this.userMapper.getUserIdByExtId(reqBO.getRegisterWay(), reqBO.getOauth2Id());
        if (userIdByExtId != null) {
            throw new ZTBusinessException("\u8be5\u4e09\u65b9\u8d26\u53f7\u5df2\u88ab\u7ed1\u5b9a");
        }
        UserPO addUserPO = new UserPO();
        addUserPO.setUserId(reqBO.getUserId());
        addUserPO.setName(reqBO.getName());
        addUserPO.setEmail(reqBO.getEmail());
        addUserPO.setCellPhone(reqBO.getCellPhone());
        addUserPO.setStatus(0);
        addUserPO.setLoginName(reqBO.getLoginName());
        addUserPO.setRegisterType(reqBO.getRegisterType() == null ? "register:personal" : reqBO.getRegisterType());
        if (reqBO.getSource() != null) {
            addUserPO.setSource(reqBO.getSource());
        } else {
            addUserPO.setSource(2);
        }
        addUserPO.setInitialPassword(reqBO.getPassword());
        addUserPO.setDetailSource(reqBO.getDetialSource());
        this.userMapper.insertUser(addUserPO);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", addUserPO.getUserId());
        map.put("extSystemType", reqBO.getRegisterWay());
        map.put("extUserId", reqBO.getOauth2Id());
        map.put("state", 1);
        map.put("defaultStatus", 1);
        this.userMapper.insertConditionExtUser(map);
        RegIndividualUserWebRspBO rspBO = new RegIndividualUserWebRspBO();
        rspBO.setUserId(addUserPO.getUserId());
        return rspBO;
    }
}

