/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.gray;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.dao.GraySwitchMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.gray.bo.GrayConfigPO;
import com.ohaotian.authority.gray.bo.SaveGrayGrantUsersReqBO;
import com.ohaotian.authority.gray.service.SaveGrayGrantUsersService;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@HSFProvider(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=SaveGrayGrantUsersService.class)
public class SaveGrayGrantUsersServiceImpl
implements SaveGrayGrantUsersService {
    private static final Logger log = LoggerFactory.getLogger(SaveGrayGrantUsersServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private GraySwitchMapper graySwitchMapper;

    public void saveGrayGrantUsers(SaveGrayGrantUsersReqBO saveGrayGrantUsersReqBO) {
        switch (saveGrayGrantUsersReqBO.getGrayWay()) {
            case 0: {
                if (saveGrayGrantUsersReqBO.getTenantIdReq() == null) {
                    throw new ZTBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("tenantId", saveGrayGrantUsersReqBO.getTenantIdReq());
                List<SelectUserInfoRspBO> userPOS = this.userMapper.selectByCondition(condition);
                this.saveGrayUsers(saveGrayGrantUsersReqBO.getApplyId(), saveGrayGrantUsersReqBO.getUserId(), userPOS);
                break;
            }
            case 1: {
                if (StringUtils.isEmpty((CharSequence)saveGrayGrantUsersReqBO.getOrgTreePath())) {
                    throw new ZTBusinessException("\u7ec4\u7ec7\u673a\u6784\u6811\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
                }
                HashMap<String, Object> condition1 = new HashMap<String, Object>();
                condition1.put("orgTreePath", saveGrayGrantUsersReqBO.getOrgTreePath());
                List<SelectUserInfoRspBO> userPOS1 = this.userMapper.selectByCondition(condition1);
                this.saveGrayUsers(saveGrayGrantUsersReqBO.getApplyId(), saveGrayGrantUsersReqBO.getUserId(), userPOS1);
                break;
            }
            case 2: {
                if (StringUtils.isEmpty((CharSequence)saveGrayGrantUsersReqBO.getUserIds())) {
                    throw new ZTBusinessException("\u7528\u6237id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List longs = JSON.parseArray((String)saveGrayGrantUsersReqBO.getUserIds(), Long.class);
                if (longs == null || longs.size() <= 0) break;
                for (Long userId : longs) {
                    int i = this.graySwitchMapper.updateGrantUser(saveGrayGrantUsersReqBO.getApplyId(), userId, saveGrayGrantUsersReqBO.getUserId());
                    if (i != 0) continue;
                    GrayConfigPO grayConfigPO = new GrayConfigPO();
                    Sequence sequence = Sequence.getInstance();
                    long authId = sequence.nextId();
                    grayConfigPO.setAuthId(Long.valueOf(authId));
                    grayConfigPO.setApplyId(saveGrayGrantUsersReqBO.getApplyId());
                    grayConfigPO.setUserId(userId);
                    grayConfigPO.setOperator(saveGrayGrantUsersReqBO.getUserId());
                    this.graySwitchMapper.saveGrayGrant(grayConfigPO);
                }
                break;
            }
        }
    }

    public void saveGrayUsers(Long applyId, Long operator, List<SelectUserInfoRspBO> userPOS) {
        if (userPOS != null && userPOS.size() > 0) {
            for (SelectUserInfoRspBO po : userPOS) {
                int i = this.graySwitchMapper.updateGrantUser(applyId, po.getUserId(), operator);
                if (i != 0) continue;
                GrayConfigPO grayConfigPO = new GrayConfigPO();
                Sequence sequence = Sequence.getInstance();
                long authId = sequence.nextId();
                grayConfigPO.setAuthId(Long.valueOf(authId));
                grayConfigPO.setApplyId(applyId);
                grayConfigPO.setUserId(po.getUserId());
                grayConfigPO.setOperator(operator);
                this.graySwitchMapper.saveGrayGrant(grayConfigPO);
            }
        }
    }
}

