/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.menu;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.MenuMapper;
import com.ohaotian.authority.menu.bo.AddSublevelMenuReqBO;
import com.ohaotian.authority.menu.service.AddSublevelMenuBusiService;
import com.ohaotian.authority.po.Menu;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=AddSublevelMenuBusiService.class)
public class AddSublevelMenuBusiServiceImpl
implements AddSublevelMenuBusiService {
    private static final Logger log = LoggerFactory.getLogger(AddSublevelMenuBusiServiceImpl.class);
    @Autowired
    MenuMapper menuMapper;

    @Transactional
    public void addSublevelMenu(AddSublevelMenuReqBO addSublevelMenuReqBO) {
        Menu menu1 = this.menuMapper.selectByMenuCode(addSublevelMenuReqBO.getMenuCode(), addSublevelMenuReqBO.getApplicationCode());
        if (menu1 != null) {
            throw new ZTBusinessException("\u83dc\u5355\u7f16\u7801\u91cd\u590d");
        }
        Menu pMenu = this.menuMapper.selectByPrimaryKey(addSublevelMenuReqBO.getParentId());
        if (pMenu != null) {
            String authIdentity = pMenu.getAuthIdentity() + ":" + addSublevelMenuReqBO.getMenuCode();
            if (Constants.MENU_TYPE_F.equals(addSublevelMenuReqBO.getType())) {
                authIdentity = authIdentity + ":" + addSublevelMenuReqBO.getButtonType();
            }
            String menuTreePath = pMenu.getMenuTreePath() + addSublevelMenuReqBO.getMenuId() + "-";
            Integer deep = pMenu.getDeep() + 1;
            Menu map = (Menu)BeanMapper.map((Object)addSublevelMenuReqBO, Menu.class);
            map.setExtApplicationCode(pMenu.getExtApplicationCode());
            map.setAuthIdentity(authIdentity);
            map.setCreateUserId(addSublevelMenuReqBO.getUserId());
            map.setCreateTime(new Date());
            map.setDeep(deep);
            map.setMenuTreePath(menuTreePath);
            this.menuMapper.addSublevelMenu(map);
        }
    }
}

