/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.StationMapper;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrgTreeNameService;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.station.bo.OrgStationBO;
import com.ohaotian.authority.station.bo.SelectStationPageReqBO;
import com.ohaotian.authority.station.service.SelectStationsPageBusiByOrgService;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=SelectStationsPageBusiByOrgService.class)
public class SelectStationsPageBusiByOrgServiceImpl
implements SelectStationsPageBusiByOrgService {
    private static final Logger log = LoggerFactory.getLogger(SelectStationsPageBusiByOrgServiceImpl.class);
    @Autowired
    StationMapper stationMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private SelectOrgTreeNameService selectOrgTreeNameService;

    public RspPage<OrgStationBO> selectStationsPageBusiByOrg(SelectStationPageReqBO selectStationPageReqBO) {
        Page page = new Page(selectStationPageReqBO.getPageNo(), selectStationPageReqBO.getPageSize());
        List<OrgStationBO> orgStationBOS = this.stationMapper.selectStationPageByOrg(selectStationPageReqBO.getStationName(), selectStationPageReqBO.getOrgTreePaths(), selectStationPageReqBO.getStatus(), selectStationPageReqBO.getTitle(), page);
        ArrayList orgStationBOS2 = new ArrayList();
        orgStationBOS.stream().forEach(p -> {
            if (!orgStationBOS2.contains(p)) {
                orgStationBOS2.add(p);
            }
        });
        orgStationBOS2.forEach(bo -> {
            OrganisationPO organisationPO = this.organizationMapper.selectOrganisationByOrgId(bo.getOrgId());
            if (organisationPO != null) {
                OrganisationBO organisationBO = null;
                organisationBO = (OrganisationBO)BeanMapper.map((Object)organisationPO, OrganisationBO.class);
                String orgTreeName = this.selectOrgTreeNameService.selectOrgTreeName(organisationBO);
                bo.setOrgName(orgTreeName);
            }
        });
        RspPage rsp = new RspPage();
        rsp.setPageNo(selectStationPageReqBO.getPageNo());
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setRows(orgStationBOS2);
        return rsp;
    }
}

