/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.tenant;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.service.DeleteOrganizationServer;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.DeleteTenantByIdService;
import com.ohaotian.authority.user.bo.SelectUserInfoWebBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=DeleteTenantByIdService.class)
public class DeleteTenantByIdServiceImpl
implements DeleteTenantByIdService {
    private static final Logger log = LoggerFactory.getLogger(DeleteTenantByIdServiceImpl.class);
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private DeleteOrganizationServer deleteOrganizationServer;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private UserMapper userMapper;

    @Transactional
    public void deleteTenantById(TenantIdBO tenantId) {
        TenantRspBO tenant = this.tenantMapper.selectTenantById(tenantId.getTenantId());
        OrganisationIdReqBO organisation = new OrganisationIdReqBO();
        organisation.setOrganisationId(tenant.getOrgRootId());
        List<OrganisationPO> organisationPOS = this.organizationMapper.selectAllOrgByPId(organisation.getOrganisationId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", tenant.getOrgRootId());
        List<SelectUserInfoWebBO> selectUserInfoWebBOS = this.userMapper.selectUserWebList(map);
        if (organisationPOS != null && organisationPOS.size() > 0 || selectUserInfoWebBOS != null && selectUserInfoWebBOS.size() > 0) {
            throw new ZTBusinessException("\u8be5\u79df\u6237\u4e0b\u6709\u4e0b\u7ea7\u673a\u6784\u6216\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.deleteOrganizationServer.deleteOrganization(organisation);
        this.tenantMapper.deleteTenantById(tenantId.getTenantId());
    }
}

