/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.ManagerOrgMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.AuthDistribute;
import com.ohaotian.authority.po.ManagerOrg;
import com.ohaotian.authority.po.Role;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.role.bo.AuthDistributeBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.user.bo.SelectUserByCellphoneBO;
import com.ohaotian.authority.user.bo.UpdateUserBOReq;
import com.ohaotian.authority.user.service.UpdateUserService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UpdateUserService.class)
public class UpdateUserServiceImpl
implements UpdateUserService {
    private static final Logger log = LoggerFactory.getLogger(UpdateUserServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private ManagerOrgMapper managerOrgMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;
    @Value(value="${admin.need.switch:false}")
    private Boolean adminNeedSwitch;

    @Transactional(rollbackFor={Exception.class})
    public int updateUserByUserId(UpdateUserBOReq updateUserBOReq) {
        List<SelectUserByCellphoneBO> selectUserByCellphoneBOS;
        UserPO userPO = this.userMapper.selectUserInfo(updateUserBOReq.getUserIdReq());
        if (!updateUserBOReq.getCellPhoneReq().equals(userPO.getCellPhone()) && (selectUserByCellphoneBOS = this.userMapper.selectUserByCellphone(updateUserBOReq.getCellPhoneReq(), "true")) != null && selectUserByCellphoneBOS.size() > 0) {
            throw new ZTBusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a");
        }
        if (!updateUserBOReq.getType().equals(userPO.getType())) {
            TenantRspBO tenantRspBO = this.tenantMapper.selectTenantById(updateUserBOReq.getTenantIdReq());
            LinkedList<Long> orgId = new LinkedList<Long>();
            orgId.add(tenantRspBO.getOrgRootId());
            if (updateUserBOReq.getType().equals("auth:tenant:manage")) {
                UserPO userInfoPO;
                if (this.adminNeedSwitch.booleanValue() && (userInfoPO = this.userMapper.selectTenantManage(updateUserBOReq.getTenantIdReq())) != null) {
                    throw new ZTBusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u79df\u6237\u5df2\u6709\u7ba1\u7406\u5458");
                }
                updateUserBOReq.setmOrgId(tenantRspBO.getOrgRootId());
                this.organizationMapper.updateOrgMuserId(orgId, updateUserBOReq.getUserIdReq());
                ArrayList<ManagerOrg> list = new ArrayList<ManagerOrg>();
                for (Long orgIdOne : orgId) {
                    ManagerOrg managerOrg = new ManagerOrg();
                    managerOrg.setOrgId(orgIdOne);
                    managerOrg.setUserId(updateUserBOReq.getUserIdReq());
                    list.add(managerOrg);
                }
                this.managerOrgMapper.insertBatch(list);
            } else if (userPO.getType().equals("auth:tenant:manage")) {
                updateUserBOReq.setmOrgId(null);
                this.organizationMapper.updateOrgMuserId(orgId, 0L);
                ManagerOrg managerOrg = new ManagerOrg();
                managerOrg.setOrgIds(orgId);
                managerOrg.setUserId(updateUserBOReq.getUserIdReq());
                this.managerOrgMapper.deleteByUserIdOrgIds(managerOrg);
            }
        }
        updateUserBOReq.setUpdateUserId(updateUserBOReq.getUserId());
        updateUserBOReq.setUpdateTime(new Date());
        updateUserBOReq.setLoginNameReq(updateUserBOReq.getLoginNameReq());
        if (userPO != null && !userPO.getType().equals(updateUserBOReq.getType())) {
            updateUserBOReq.setType(updateUserBOReq.getType());
            Role oldRole = this.roleMapper.selectRoleByAuthId(userPO.getType());
            AuthDistributeBO delete = new AuthDistributeBO();
            delete.setUserId(updateUserBOReq.getUserIdReq());
            delete.setRoleId(oldRole.getRoleId());
            this.authDistributeMapper.deleteRoleByUserId(delete);
            Role newRole = this.roleMapper.selectRoleByAuthId(updateUserBOReq.getType());
            AuthDistribute authDistribute = new AuthDistribute();
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            authDistribute.setAuthId(l);
            authDistribute.setRoleId(newRole.getRoleId());
            authDistribute.setUserId(updateUserBOReq.getUserIdReq());
            authDistribute.setDisFlag(1);
            this.authDistributeMapper.insert(authDistribute);
        }
        int result = this.userMapper.updateUserByUserId(updateUserBOReq);
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "modify_" + Constants.MQ_DATA_SEND_TAG_USER + "_" + userPO.getTenantId(), userPO.getUserId() + "");
        this.dataSend.send(proxyMessage);
        return result;
    }
}

