/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.workday;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.SpecialDateMapper;
import com.ohaotian.authority.util.WorkDayUtils;
import com.ohaotian.authority.workday.bo.SelectWorkDayCountWebReqBO;
import com.ohaotian.authority.workday.bo.SelectWorkDaysWebRspBO;
import com.ohaotian.authority.workday.service.SelectWorkDaysWebService;
import com.ohaotian.plugin.common.util.DateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=SelectWorkDaysWebService.class)
public class SelectWorkDaysWebServiceImpl
implements SelectWorkDaysWebService {
    private static final Logger log = LoggerFactory.getLogger(SelectWorkDaysWebServiceImpl.class);
    @Autowired
    private SpecialDateMapper specialDateMapper;

    public SelectWorkDaysWebRspBO selectWorkDays(SelectWorkDayCountWebReqBO reqBO) {
        Date startdate = DateUtils.strToDate((String)reqBO.getStartTime());
        Date enddate = DateUtils.strToDate((String)reqBO.getEndTime());
        List<String> betweenDate = WorkDayUtils.getBetweenDate(reqBO.getStartTime(), reqBO.getEndTime());
        List<String> holiday = this.specialDateMapper.selectDateList(startdate, enddate, 1);
        List<String> weekendsDate = WorkDayUtils.getBetweenWeekendsDate(reqBO.getStartTime(), reqBO.getEndTime());
        List<String> workday = this.specialDateMapper.selectDateList(startdate, enddate, 3);
        HashSet<String> betweenDates = new HashSet<String>(betweenDate);
        HashSet<String> holidays = new HashSet<String>(holiday);
        betweenDates.removeAll(holidays);
        HashSet<String> weekendsDates = new HashSet<String>(weekendsDate);
        betweenDates.removeAll(weekendsDates);
        HashSet<String> workdays = new HashSet<String>(workday);
        betweenDates.addAll(workdays);
        ArrayList<String> list = new ArrayList<String>(betweenDates);
        Collections.sort(list);
        SelectWorkDaysWebRspBO rspBO = new SelectWorkDaysWebRspBO();
        rspBO.setWorkdays(list);
        return rspBO;
    }
}

