/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.StationMapper;
import com.ohaotian.authority.po.Station;
import com.ohaotian.authority.station.bo.SaveStationReqBO;
import com.ohaotian.authority.station.bo.SelectTenantStationsReqBO;
import com.ohaotian.authority.station.bo.StationWebBO;
import com.ohaotian.authority.station.service.SaveStationBusiService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.HanyuPinyinHelper;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV", serviceInterface=SaveStationBusiService.class)
public class SaveStationBusiServiceImpl
implements SaveStationBusiService {
    private static final Logger log = LoggerFactory.getLogger(SaveStationBusiServiceImpl.class);
    @Autowired
    private StationMapper stationMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;

    @Transactional
    public void saveStation(SaveStationReqBO addStationReqBO) {
        Station station = null;
        station = new Station();
        if (addStationReqBO != null) {
            BeanUtils.copyProperties((Object)addStationReqBO, (Object)station);
        }
        station.setOrgId(addStationReqBO.getOrgIdNew());
        station.setTenantId(addStationReqBO.getTenantIdReq());
        station.setCreatUserId(addStationReqBO.getUserId());
        if (addStationReqBO.getTenantIdReq() != null) {
            List<StationWebBO> stationWebBOListByName = this.stationMapper.selectTenantStationsByName(addStationReqBO.getTenantIdReq(), addStationReqBO.getStationName());
            if (stationWebBOListByName != null && stationWebBOListByName.size() > 0) {
                throw new ZTBusinessException("\u5c97\u4f4d\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            }
        } else {
            List<StationWebBO> stationWebBOSByName = this.stationMapper.selectTenantStationsByName(null, addStationReqBO.getStationName());
            if (stationWebBOSByName != null && stationWebBOSByName.size() > 0) {
                throw new ZTBusinessException("\u5c97\u4f4d\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        if (StringUtils.isEmpty((Object)addStationReqBO.getStationCode())) {
            String stationCode = "";
            stationCode = addStationReqBO.getTenantIdReq() != null ? addStationReqBO.getTenantIdReq() + ":" + HanyuPinyinHelper.getPinyinString((String)addStationReqBO.getStationName()) : "overall:" + HanyuPinyinHelper.getPinyinString((String)addStationReqBO.getStationName());
            station.setStationCode(stationCode);
        } else {
            List<StationWebBO> stationWebBOS;
            List<StationWebBO> stationWebBOList;
            SelectTenantStationsReqBO reqBO = new SelectTenantStationsReqBO();
            reqBO.setStationCode(addStationReqBO.getStationCode());
            if (addStationReqBO.getTenantIdReq() != null ? (stationWebBOList = this.stationMapper.selectTenantStations(addStationReqBO.getTenantIdReq(), addStationReqBO.getStationCode(), null)) != null && stationWebBOList.size() > 0 : (stationWebBOS = this.stationMapper.selectTenantStations(null, addStationReqBO.getStationCode(), null)) != null && stationWebBOS.size() > 0) {
                throw new ZTBusinessException("\u5c97\u4f4d\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            }
        }
        this.stationMapper.insert(station);
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, Constants.MQ_DATA_SEND_TAG_STATION, station.getStationId() + "");
        this.dataSend.send(proxyMessage);
    }
}

