/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.util;

import com.ohaotian.plugin.common.util.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class WorkDayUtils {
    public static Long workdayCount(String startDate, String endDate) {
        Date startdate = DateUtils.strToDate((String)startDate);
        Date enddate = DateUtils.strToDate((String)endDate);
        long l = (enddate.getTime() - startdate.getTime()) / 86400000L + 1L;
        return l;
    }

    public static int getWeekends(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return 0;
        }
        int count = 0;
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        if (c1.after(c2)) {
            c2.setTime(d1);
            c1.setTime(d2);
        }
        while (c2.after(c1) || c1.equals(c2)) {
            if (c1.get(7) == 1 || c1.get(7) == 7) {
                System.out.println(c1.getTime());
                ++count;
            }
            c1.set(6, c1.get(6) + 1);
        }
        return count;
    }

    public static int getDayofweek(String date) {
        Calendar cal = Calendar.getInstance();
        if (date.equals("")) {
            cal.setTime(new Date(System.currentTimeMillis()));
        } else {
            cal.setTime(new Date(WorkDayUtils.getDateByStr2(date).getTime()));
        }
        return cal.get(7);
    }

    public static Date getDateByStr2(String dd) {
        Date date;
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sd.parse(dd);
        }
        catch (Exception e) {
            date = null;
            e.printStackTrace();
        }
        return date;
    }

    public static List<String> getBetweenDate(String startTime, String endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> list = new ArrayList<String>();
        try {
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(endTime);
            Calendar calendar = Calendar.getInstance();
            while (startDate.getTime() <= endDate.getTime()) {
                list.add(sdf.format(startDate));
                calendar.setTime(startDate);
                calendar.add(5, 1);
                startDate = calendar.getTime();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<String> getBetweenWeekendsDate(String startTime, String endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> list = new ArrayList<String>();
        try {
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(endTime);
            Calendar calendar = Calendar.getInstance();
            while (startDate.getTime() <= endDate.getTime()) {
                calendar.setTime(startDate);
                if (calendar.get(7) == 1 || calendar.get(7) == 7) {
                    list.add(sdf.format(startDate));
                }
                calendar.add(5, 1);
                startDate = calendar.getTime();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return list;
    }
}

