/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.config;

import com.ohaotian.plugin.security.auth.XHttpSessionSecurityContextRepository;
import com.ohaotian.plugin.security.filter.TokenAuthenticationFilter;
import com.ohaotian.plugin.security.property.FilterStaticConfig;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextRepository;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebSecurityConfig.class);
    @Value(value="${app.server.host.url}")
    private String appUrl;
    @Autowired
    private FilterStaticConfig filterStaticConfig;

    public void configure(WebSecurity web) throws Exception {
        this.filterStaticConfig.getResources().forEach(resource -> {
            try {
                web.ignoring().antMatchers(new String[]{resource});
            }
            catch (Exception e) {
                log.error("\u767d\u540d\u5355\u914d\u7f6e\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        });
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.headers().frameOptions().disable();
        http.csrf().disable();
        http.securityContext().securityContextRepository((SecurityContextRepository)new XHttpSessionSecurityContextRepository());
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/**/users/signup/**", "/**/noauth/**"})).permitAll();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        http.logout().permitAll();
        TokenAuthenticationFilter tokenAuthenticationFilter = (TokenAuthenticationFilter)((Object)this.getApplicationContext().getBean(TokenAuthenticationFilter.class));
        http.addFilterBefore((Filter)tokenAuthenticationFilter, UsernamePasswordAuthenticationFilter.class);
        http.antMatcher("/**");
    }
}

