/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.config;

import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@ConditionalOnProperty(name={"CORS"}, havingValue="true")
public class CorsConfig {
    @Value(value="#{'${allowedHeaders:*}'.split(',')}")
    private List<String> allowedHeaders;
    @Value(value="#{'${allowedOrigins:*}'.split(',')}")
    private List<String> allowedOrigins;

    private CorsConfiguration buildConfig() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        this.allowedOrigins.forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedOrigin(arg_0));
        this.allowedHeaders.forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedHeader(arg_0));
        corsConfiguration.addAllowedMethod(HttpMethod.DELETE);
        corsConfiguration.addAllowedMethod(HttpMethod.POST);
        corsConfiguration.addAllowedMethod(HttpMethod.GET);
        corsConfiguration.addAllowedMethod(HttpMethod.PUT);
        corsConfiguration.addAllowedMethod(HttpMethod.DELETE);
        corsConfiguration.addAllowedMethod(HttpMethod.OPTIONS);
        corsConfiguration.setMaxAge(Long.valueOf(3600L));
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        return corsConfiguration;
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", this.buildConfig());
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

