/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.application.bo.ApplicationBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserRspBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeReqBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeRspBO;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.dic.bo.SelectDicByAllReqBO;
import com.ohaotian.authority.dic.bo.SelectDicBypDicValRspBO;
import com.ohaotian.authority.dic.bo.SelectDicRspBO;
import com.ohaotian.authority.dic.service.SelectDicBypDicValBusiService;
import com.ohaotian.authority.logger.bo.SaveLoginLogReqBO;
import com.ohaotian.authority.logger.service.SaveLoginLogBusiService;
import com.ohaotian.authority.login.bo.LoginExpTimeReqBO;
import com.ohaotian.authority.login.bo.LoginGetPicVfCodeReqBO;
import com.ohaotian.authority.login.bo.LoginGetPicVfCodeRspBO;
import com.ohaotian.authority.login.service.LoginGetPicVfCodeService;
import com.ohaotian.authority.login.service.LoginService;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameReqBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameRspBO;
import com.ohaotian.authority.user.service.SelectUserByLoginNameService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspMapInfoBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.IPUtils;
import com.ohaotian.plugin.security.entity.LoginReqBO;
import com.ohaotian.plugin.security.entity.MenuInfo;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.jwt.Jwt;
import com.ohaotian.plugin.security.service.AutzQueryService;
import com.ohaotian.plugin.security.utils.AesUtil;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import com.ohaotian.plugin.security.utils.UserAgent;
import com.ohaotian.plugin.security.utils.UserAgentUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PermissionsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionsController.class);
    @Autowired
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @Autowired
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @Autowired
    private SelectUserByLoginNameService selectUserByLoginNameService;
    @Autowired
    private SelectTenantByIdService selectTenantByIdService;
    @Autowired
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @Autowired
    private SaveLoginLogBusiService saveLoginLogBusiService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private LoginGetPicVfCodeService loginGetPicVfCodeService;
    @Autowired
    private AutzQueryService autzQueryService;
    @Autowired
    private CacheClient cacheService;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${login.loginNum:3}")
    private Integer loginNum;
    @Value(value="${login.lockTime:86400}")
    private int loginLockTime;
    @Value(value="${login.vfType:1}")
    private int vfType;
    @Value(value="${login.defaultVfCode:true}")
    private Boolean defaultVfFlag;
    @Value(value="${login.defaultVfCode:1111}")
    private String defaultVfCode;
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;
    private static final int OFFSET = 4;
    @Autowired
    private SelectDicBypDicValBusiService selectDicBypDicValBusiService;

    @RequestMapping(value={"/auth/getUserMenus"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserMenus(@RequestParam(required=false) String appCode) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            LOGGER.debug("getUserMenus" + appCode);
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appCode})) {
                Map<String, List<MenuInfo>> menus = user.getMenus();
                SelectByApplicationCodeReqBO selectByApplicationCodeReqBO = new SelectByApplicationCodeReqBO();
                selectByApplicationCodeReqBO.setApplicationCode(appCode);
                SelectByApplicationCodeRspBO application = this.selectByApplicationCodeBusiService.selectByApplicationCode(selectByApplicationCodeReqBO);
                map.put("menus", menus.get(appCode));
                if (application != null) {
                    map.put("appName", application.getApplicationBO().getApplicationName());
                }
            } else {
                SelectApplicationByUserReqBO applicationByUserReqBO = new SelectApplicationByUserReqBO();
                applicationByUserReqBO.setUserId(user.getUserId());
                applicationByUserReqBO.setOrgPath(user.getOrgPath());
                SelectApplicationByUserRspBO applicationByUserRspBO = this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
                List applicationBOS = applicationByUserRspBO.getApplicationBOS();
                if (applicationBOS != null && applicationBOS.size() > 0) {
                    ApplicationBO applicationBO = (ApplicationBO)applicationBOS.get(0);
                    map.put("appName", applicationBO.getApplicationName());
                    map.put("isExt", applicationBO.getIsExt());
                    appCode = applicationBO.getApplicationCode();
                    Map<String, List<MenuInfo>> menus = user.getMenus();
                    map.put("menus", menus.get(appCode));
                }
            }
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/havePerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object havePerms(@RequestParam String[] authority) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (String auth : authority) {
                map.put(auth, user.hasAuthority(auth));
            }
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/getUserPerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserPerms(HttpServletResponse response) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            HashSet permission = new HashSet();
            user.getPermission().forEach(perm -> permission.add(perm.getKey()));
            if (permission != null) {
                Cookie cookie = null;
                try {
                    cookie = new Cookie("permission", URLEncoder.encode(JSON.toJSONString(permission), "utf-8"));
                    cookie.setPath("/");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("\u751f\u6210cookie\u5f02\u5e38", (Throwable)e);
                    e.printStackTrace();
                }
                LOGGER.debug("\u5199\u5165cookie" + JSON.toJSONString((Object)cookie));
                response.addCookie(cookie);
                LOGGER.debug("\u5199\u5165cookie\u7ed3\u675f" + JSON.toJSONString((Object)cookie));
            }
            return permission;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/getUserInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserInfo() {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        LOGGER.debug(JSON.toJSONString((Object)userInfo));
        if (userInfo != null) {
            UserInfo result = new UserInfo();
            BeanUtils.copyProperties((Object)userInfo, (Object)result);
            if (StringUtils.isNotBlank((CharSequence)result.getCellphone()) && result.getCellphone().length() == 11) {
                String start = result.getCellphone().substring(0, 3);
                String end = result.getCellphone().substring(8, 11);
                String temp = "*****";
                result.setCellphone(start + temp + end);
            }
            return result;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f");
    }

    @RequestMapping(value={"/auth/getFullUserInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getFullUserInfo() {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo != null) {
            return userInfo;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/auth/users/signup/login"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object getToken(HttpServletRequest request, HttpServletResponse response, @RequestBody LoginReqBO reqBO) {
        UserInfo userInfo;
        Date date;
        HashMap<String, Object> payload;
        block20: {
            block19: {
                payload = new HashMap<String, Object>();
                date = new Date();
                userInfo = new UserInfo();
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getLoginName()}) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getPassWord()})) break block19;
                Integer num = (Integer)this.cacheService.get("cas" + reqBO.getLoginName());
                if (num != null && num.equals(this.loginNum)) {
                    throw new ZTBusinessException("\u60a8\u5df2\u8fde\u7eed\u8f93\u5165\u9519\u8bef" + this.loginNum + "\u6b21\uff0c\u7981\u6b62\u5f53\u524d\u7528\u6237\u767b\u5f55");
                }
                if (num == null) {
                    num = 0;
                }
                LoginGetPicVfCodeReqBO loginGetPicVfCodeReqBO = new LoginGetPicVfCodeReqBO();
                String sessionId = request.getSession().getId();
                loginGetPicVfCodeReqBO.setIp(sessionId);
                loginGetPicVfCodeReqBO.setVfCode(reqBO.getVfCode());
                if (!(this.vfType != 1 || this.defaultVfCode.equals(reqBO.getVfCode()) && this.defaultVfFlag.booleanValue())) {
                    LoginGetPicVfCodeRspBO loginGetPicVfCodeRspBO = this.loginGetPicVfCodeService.checkVfCode(loginGetPicVfCodeReqBO);
                    if (!"0".equals(loginGetPicVfCodeRspBO.getCode())) {
                        throw new ZTBusinessException(loginGetPicVfCodeRspBO.getMessage());
                    }
                } else if (!(this.vfType != 2 || this.defaultVfCode.equals(reqBO.getVfCode()) && this.defaultVfFlag.booleanValue())) {
                    Integer veriCode = this.autzQueryService.getCurrentIdCaptcha(sessionId);
                    if (Integer.valueOf(reqBO.getVfCode()) >= veriCode + 4) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
                    if (Integer.valueOf(reqBO.getVfCode()) <= veriCode - 4) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
                    String string = this.autzQueryService.putCurrentIpCode(sessionId);
                }
                LOGGER.debug("\u5bc6\u6587:{}", (Object)reqBO.getPassWord());
                LOGGER.debug("\u5bc6\u94a5:{}", (Object)this.ORIGINAL_KEY);
                String pwd = AesUtil.decryptStr(reqBO.getPassWord(), this.ORIGINAL_KEY);
                LOGGER.debug("\u660e\u6587:{}", (Object)pwd);
                reqBO.setPassWord(pwd);
                SelectUserByLoginNameReqBO selectUserByLoginNameReqBO = new SelectUserByLoginNameReqBO();
                selectUserByLoginNameReqBO.setUsername(reqBO.getLoginName());
                selectUserByLoginNameReqBO.setPassword(reqBO.getPassWord());
                selectUserByLoginNameReqBO.setType(null);
                SelectUserByLoginNameRspBO rspUser = this.selectUserByLoginNameService.selectUserByLoginNameService(selectUserByLoginNameReqBO);
                if (rspUser != null) {
                    payload.put("userId", rspUser.getUserId());
                    BeanUtils.copyProperties((Object)rspUser, (Object)userInfo);
                    userInfo.setUsername(rspUser.getLoginName());
                    if (rspUser.getStatus() == 1) {
                        throw new ZTBusinessException("\u7528\u6237\u72b6\u6001\u65e0\u6548\uff0c\u65e0\u6cd5\u767b\u9646\uff01");
                    }
                    Long userId = rspUser.getUserId();
                    if (rspUser.getTenantId() != null) {
                        TenantIdBO tenantIdBO = new TenantIdBO();
                        tenantIdBO.setTenantId(rspUser.getTenantId());
                        TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
                        if (tenantRspBO != null && tenantRspBO.getStatus() != 0) {
                            throw new ZTBusinessException("\u7528\u6237\u6240\u5c5e\u79df\u6237\u65e0\u6548\uff0c\u65e0\u6cd5\u767b\u9646\uff01");
                        }
                    }
                    if (rspUser.getOrgId() != null) {
                        OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
                        organisationIdReqBO.setOrganisationId(rspUser.getOrgId());
                        RspOrganisationBO organisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
                        if (organisationBO != null && organisationBO.getStatus() != 0) {
                            throw new ZTBusinessException("\u7528\u6237\u6240\u5c5e\u673a\u6784\u65e0\u6548\uff0c\u65e0\u6cd5\u767b\u9646\uff01");
                        }
                    }
                    try {
                        SaveLoginLogReqBO loginLogReqBO = new SaveLoginLogReqBO();
                        loginLogReqBO.setLoginName(rspUser.getLoginName());
                        String agent = request.getHeader("user-agent");
                        UserAgent userAgent = UserAgentUtil.getUserAgent(agent);
                        loginLogReqBO.setMacOs(userAgent.getPlatformType());
                        loginLogReqBO.setBrowser(userAgent.getBrowserType());
                        String ip = IPUtils.getIp((HttpServletRequest)request);
                        loginLogReqBO.setHost(ip);
                        loginLogReqBO.setTenantId(rspUser.getTenantId());
                        this.saveLoginLogBusiService.saveLoginLog(loginLogReqBO);
                        loginLogReqBO.setMacInfo("\u767b\u5f55\u6210\u529f");
                    }
                    catch (Exception e) {
                        LOGGER.error("\u8bb0\u5f55\u767b\u5f55\u65e5\u5fd7\u9519\u8bef\u4fe1\u606f", (Throwable)e);
                    }
                    this.cacheService.delete("cas" + reqBO.getLoginName());
                    break block20;
                } else {
                    String errorMessage;
                    num = num + 1;
                    this.cacheService.set("cas" + reqBO.getLoginName(), (Object)num, this.loginLockTime);
                    Integer residualTimes = this.loginNum - num;
                    if (residualTimes > 0) {
                        errorMessage = "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef,\u60a8\u8fd8\u6709" + residualTimes + "\u6b21\u673a\u4f1a\uff01";
                        throw new ZTBusinessException(errorMessage);
                    }
                    errorMessage = "\u60a8\u5df2\u8fde\u7eed\u8f93\u5165\u9519\u8bef" + this.loginNum + "\u6b21\uff0c\u7981\u6b62\u5f53\u524d\u7528\u6237\u767b\u5f55";
                    throw new ZTBusinessException(errorMessage);
                }
            }
            if (reqBO.getUserId() == null) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            if (reqBO.getUserId() == 0L) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            if (!this.defaultVfCode.equals(reqBO.getVfCode()) || !this.defaultVfFlag.booleanValue()) {
                String vfCode = (String)this.cacheService.get("loginVfCode" + reqBO.getUserId());
                if (!vfCode.equals(reqBO.getVfCode())) throw new ZTBusinessException("\u9a8c\u8bc1\u8fc7\u671f\uff0c\u7528\u6237ID\u6388\u6743\u5931\u8d25");
                payload.put("userId", reqBO.getUserId());
                this.cacheService.delete("loginVfCode" + reqBO.getUserId());
            } else {
                payload.put("userId", reqBO.getUserId());
            }
        }
        SaveLoginLogReqBO loginLogReqBO = new SaveLoginLogReqBO();
        loginLogReqBO.setLoginName(reqBO.getLoginName());
        UserAgent userAgent = UserAgentUtil.getUserAgent(request.getHeader("user-agent"));
        loginLogReqBO.setMacOs(userAgent.getPlatformType());
        loginLogReqBO.setBrowser(userAgent.getBrowserType());
        loginLogReqBO.setHost(IPUtils.getIp((HttpServletRequest)request));
        loginLogReqBO.setTenantId(userInfo.getTenantId());
        LOGGER.debug("\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u4fdd\u5b58\u767b\u9646\u65e5\u5fd7\u5165\u53c2\u4e3a" + JSON.toJSONString((Object)loginLogReqBO));
        this.saveLoginLogBusiService.saveLoginLog(loginLogReqBO);
        payload.put("iat", date.getTime());
        String loginSource = null;
        loginSource = !StringUtils.isEmpty((CharSequence)reqBO.getLoginSource()) ? reqBO.getLoginSource() : "defaltSource";
        payload.put("loginSource", loginSource);
        String token = Jwt.createToken(payload);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25");
        }
        LoginExpTimeReqBO abilityReq = new LoginExpTimeReqBO();
        abilityReq.setToken(token);
        abilityReq.setUserId(userInfo.getUserId());
        abilityReq.setLoginSource(loginSource);
        this.loginService.uniqueLogin(abilityReq);
        this.loginService.updateLoginExpTime(abilityReq);
        this.loginService.logIn(abilityReq);
        RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
        HashMap<String, String> resMap = new HashMap<String, String>();
        Cookie cookie = new Cookie("auth-token", token);
        cookie.setPath("/");
        response.addCookie(cookie);
        resMap.put("token", token);
        rspMapInfoBO.setData(resMap);
        return rspMapInfoBO;
    }

    @RequestMapping(value={"/auth/users/signup/getVfcode"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getPicVfCode(HttpServletRequest request, @RequestBody LoginGetPicVfCodeReqBO reqBO) {
        String sessionId = request.getSession().getId();
        reqBO.setIp(sessionId);
        return this.loginGetPicVfCodeService.getPicVfCode(reqBO);
    }

    @RequestMapping(value={"/auth/users/signup/logout"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object logout(HttpServletRequest request, @RequestBody LoginExpTimeReqBO reqBO) {
        String token = request.getHeader("auth-token");
        LoginExpTimeReqBO Req = new LoginExpTimeReqBO();
        Req.setToken(token);
        return this.loginService.logOut(Req);
    }

    @RequestMapping(value={"/auth/refurshDicCache"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object refurshDicCache(@RequestBody SelectDicByAllReqBO selectDicByAllReqBO) {
        String dicMenuCodeRedis = "DIC_MENU_CODE_REDIS_";
        Set keys = this.cacheService.getkeys(dicMenuCodeRedis + "*");
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            keys.forEach(key -> this.cacheService.delete(key));
        }
        SelectDicRspBO selectDicBypDicValRspBO = this.selectDicBypDicValBusiService.selectDicByAll(selectDicByAllReqBO);
        LOGGER.info("\u6743\u9650\u5b57\u5178:{}", (Object)selectDicBypDicValRspBO.getDicMenuMap());
        if (!CollectionUtils.isEmpty((Map)selectDicBypDicValRspBO.getDicMenuMap())) {
            selectDicBypDicValRspBO.getDicMenuMap().forEach((key, value) -> this.cacheService.set(dicMenuCodeRedis + key, value));
        }
        return selectDicBypDicValRspBO;
    }

    @RequestMapping(value={"/auth/delDicCacheSingle"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object delDicCacheSingle(@RequestBody SelectDicByAllReqBO selectDicByAllReqBO) {
        String dicMenuCodeRedis = "DIC_MENU_CODE_REDIS_";
        if (!CollectionUtils.isEmpty((Collection)selectDicByAllReqBO.getDicValues())) {
            selectDicByAllReqBO.getDicValues().forEach(dicValue -> this.cacheService.delete(dicMenuCodeRedis + dicValue));
        }
        SelectDicBypDicValRspBO selectDicBypDicValRspBO = new SelectDicBypDicValRspBO();
        selectDicBypDicValRspBO.setCode("0");
        selectDicBypDicValRspBO.setMessage("\u6210\u529f");
        return selectDicBypDicValRspBO;
    }

    @RequestMapping(value={"/auth/delDicCache"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object delDicCache(@RequestBody SelectDicByAllReqBO selectDicByAllReqBO) {
        Set keys = this.cacheService.getkeys("DIC_MENU_CODE_REDIS_.*");
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            keys.forEach(key -> this.cacheService.delete(key));
        }
        SelectDicBypDicValRspBO rspBO = new SelectDicBypDicValRspBO();
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

