/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.ohaotian.plugin.security.entity.AuthorityInfo;
import com.ohaotian.plugin.security.entity.MenuInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class UserInfo
implements UserDetails {
    private static final long serialVersionUID = -7580618077423166554L;
    @JSONField(serializeUsing=ToStringSerializer.class)
    private Long userId;
    private String name;
    private String username;
    private String password;
    private String userType;
    private String orgPath;
    @JSONField(serializeUsing=ToStringSerializer.class)
    private Long orgId;
    private String orgName;
    private String orgType;
    private String institutionalCode;
    private String cellphone;
    @JSONField(serializeUsing=ToStringSerializer.class)
    private Long tenantId;
    private String tenantName;
    private List<String> stationCode;
    @JSONField(serializeUsing=ToStringSerializer.class)
    private Long resTenantIdIn;
    private String tenementId;
    private String resTenantNameIn;
    private Set<MenuInfo> unstructuredMunes = new HashSet<MenuInfo>();
    private boolean isAccountNonExpired = true;
    private boolean isAccountNonLocked = true;
    private boolean isCredentialsNonExpired = true;
    private boolean isEnabled = true;
    private Set<AuthorityInfo> permission = new HashSet<AuthorityInfo>();
    private Map<String, List<MenuInfo>> menus = new HashMap<String, List<MenuInfo>>();
    private List<MenuInfo> unMenus = new LinkedList<MenuInfo>();
    private List<String> menuCodeList;
    private static final ThreadLocal<AuthorityInfo> AUTHORITY_CONTEXT = new ThreadLocal<AuthorityInfo>(){

        @Override
        protected AuthorityInfo initialValue() {
            return new AuthorityInfo();
        }
    };

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.unstructuredMunes.stream().filter(menuInfo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{menuInfo.getUrl()})).map(menuInfo -> new SimpleGrantedAuthority("URL_" + menuInfo.getUrl())).distinct().collect(Collectors.toList());
    }

    public boolean hasAuthority(String authority) {
        if (authority == null) {
            return false;
        }
        AuthorityInfo authorityInfo = AUTHORITY_CONTEXT.get();
        authorityInfo.setKey(authority);
        return this.permission.contains(authorityInfo);
    }

    public void setUnstructuredMunes(List<MenuInfo> unstructuredMunes) {
        this.unstructuredMunes.addAll(unstructuredMunes);
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAccountNonExpired() {
        return this.isAccountNonExpired;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        this.isAccountNonExpired = accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.isAccountNonLocked;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.isAccountNonLocked = accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.isCredentialsNonExpired;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        this.isCredentialsNonExpired = credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void setPermission(Set<AuthorityInfo> permission) {
        this.permission = permission;
    }

    public Set<AuthorityInfo> getPermission() {
        return this.permission;
    }

    public Map<String, List<MenuInfo>> getMenus() {
        return this.menus;
    }

    public void setMenus(Map<String, List<MenuInfo>> menus) {
        this.menus = menus;
    }

    public List<MenuInfo> getUnMenus() {
        return this.unMenus;
    }

    public void setUnMenus(List<MenuInfo> unMenus) {
        this.unMenus = unMenus;
    }

    public String getOrgPath() {
        return this.orgPath;
    }

    public void setOrgPath(String orgPath) {
        this.orgPath = orgPath;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getCellphone() {
        return this.cellphone;
    }

    public void setCellphone(String cellphone) {
        this.cellphone = cellphone;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getInstitutionalCode() {
        return this.institutionalCode;
    }

    public void setInstitutionalCode(String institutionalCode) {
        this.institutionalCode = institutionalCode;
    }

    public List<String> getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(List<String> stationCode) {
        this.stationCode = stationCode;
    }

    public Long getResTenantIdIn() {
        return this.resTenantIdIn;
    }

    public void setResTenantIdIn(Long resTenantIdIn) {
        this.resTenantIdIn = resTenantIdIn;
    }

    public String getTenementId() {
        return this.tenementId;
    }

    public void setTenementId(String tenementId) {
        this.tenementId = tenementId;
    }

    public String getResTenantNameIn() {
        return this.resTenantNameIn;
    }

    public void setResTenantNameIn(String resTenantNameIn) {
        this.resTenantNameIn = resTenantNameIn;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String toString() {
        return "UserInfo{userId=" + this.userId + ", name='" + this.name + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", userType='" + this.userType + '\'' + ", orgPath='" + this.orgPath + '\'' + ", orgId=" + this.orgId + ", orgName='" + this.orgName + '\'' + ", orgType='" + this.orgType + '\'' + ", institutionalCode='" + this.institutionalCode + '\'' + ", cellphone='" + this.cellphone + '\'' + ", tenantId=" + this.tenantId + ", tenantName='" + this.tenantName + '\'' + ", stationCode=" + this.stationCode + ", resTenantIdIn=" + this.resTenantIdIn + ", tenementId='" + this.tenementId + '\'' + ", resTenantNameIn='" + this.resTenantNameIn + '\'' + ", unstructuredMunes=" + this.unstructuredMunes + ", isAccountNonExpired=" + this.isAccountNonExpired + ", isAccountNonLocked=" + this.isAccountNonLocked + ", isCredentialsNonExpired=" + this.isCredentialsNonExpired + ", isEnabled=" + this.isEnabled + ", permission=" + this.permission + ", menus=" + this.menus + ", unMenus=" + this.unMenus + ", menuCodeList=" + this.menuCodeList + '}';
    }

    public List<String> getMenuCodeList() {
        return this.menuCodeList;
    }

    public void setMenuCodeList(List<String> menuCodeList) {
        this.menuCodeList = menuCodeList;
    }

    public String getOrgType() {
        return this.orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }
}

